/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.actions.OpenEmulatorAction;
import io.flutter.actions.OpenSimulatorAction;
import io.flutter.run.daemon.DeviceService;
import io.flutter.run.daemon.FlutterDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectorAction
extends ComboBoxAction
implements DumbAware {
    private final List<AnAction> actions = new ArrayList<AnAction>();
    private final List<Project> knownProjects = Collections.synchronizedList(new ArrayList());
    private SelectDeviceAction selectedDeviceAction;

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(this.actions);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            DeviceSelectorAction.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    public void update(AnActionEvent e) {
        String place = e.getPlace();
        if (!Objects.equals(place, "NavBarToolbar") && !Objects.equals(place, "MainToolbar")) {
            e.getPresentation().setVisible(false);
            return;
        }
        Project project = e.getProject();
        if (!this.isSelectorVisible(project)) {
            e.getPresentation().setVisible(false);
            return;
        }
        super.update(e);
        if (!this.knownProjects.contains(project)) {
            this.knownProjects.add(project);
            Disposer.register((Disposable)project, () -> this.knownProjects.remove(project));
            DeviceService.getInstance(project).addListener(() -> this.update(project, e.getPresentation()));
            this.update(project, e.getPresentation());
        }
    }

    private void update(Project project, Presentation presentation) {
        FlutterUtils.invokeAndWait(() -> {
            this.updateActions(project, presentation);
            this.updateVisibility(project, presentation);
        });
    }

    private void updateVisibility(Project project, Presentation presentation) {
        boolean visible = this.isSelectorVisible(project);
        presentation.setVisible(visible);
        JComponent component = (JComponent)presentation.getClientProperty("customComponent");
        if (component != null) {
            component.setVisible(visible);
            if (component.getParent() != null) {
                component.getParent().doLayout();
                component.getParent().repaint();
            }
        }
    }

    private boolean isSelectorVisible(@Nullable Project project) {
        return project != null && DeviceService.getInstance(project).getStatus() != DeviceService.State.INACTIVE;
    }

    private void updateActions(@NotNull Project project, Presentation presentation) {
        List<OpenEmulatorAction> emulatorActions;
        if (project == null) {
            DeviceSelectorAction.$$$reportNull$$$0(1);
        }
        this.actions.clear();
        DeviceService service = DeviceService.getInstance(project);
        Collection<FlutterDevice> devices = service.getConnectedDevices();
        for (FlutterDevice device : devices) {
            this.actions.add(new SelectDeviceAction(device, devices));
        }
        if (this.actions.isEmpty()) {
            boolean isLoading = service.getStatus() == DeviceService.State.LOADING;
            String message = isLoading ? FlutterBundle.message("devicelist.loading", new Object[0]) : FlutterBundle.message("devicelist.empty", new Object[0]);
            this.actions.add(new NoDevicesAction(message));
        }
        if (SystemInfo.isMac) {
            boolean simulatorOpen = false;
            for (AnAction action : this.actions) {
                SelectDeviceAction deviceAction;
                FlutterDevice device;
                if (!(action instanceof SelectDeviceAction) || !(device = (deviceAction = (SelectDeviceAction)action).device).isIOS() || !device.emulator()) continue;
                simulatorOpen = true;
            }
            this.actions.add((AnAction)new Separator());
            this.actions.add(new OpenSimulatorAction(!simulatorOpen));
        }
        if (!(emulatorActions = OpenEmulatorAction.getEmulatorActions(project)).isEmpty()) {
            this.actions.add((AnAction)new Separator());
            this.actions.addAll(emulatorActions);
        }
        this.selectedDeviceAction = null;
        FlutterDevice selectedDevice = service.getSelectedDevice();
        for (AnAction action : this.actions) {
            SelectDeviceAction deviceAction;
            if (!(action instanceof SelectDeviceAction) || !Objects.equals((deviceAction = (SelectDeviceAction)action).device, selectedDevice)) continue;
            this.selectedDeviceAction = deviceAction;
            Presentation template = action.getTemplatePresentation();
            presentation.setIcon(template.getIcon());
            presentation.setText(deviceAction.deviceName());
            presentation.setEnabled(true);
            return;
        }
        if (devices.isEmpty()) {
            presentation.setText("<no devices>");
        } else {
            presentation.setText(null);
        }
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action -> action == this.selectedDeviceAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/actions/DeviceSelectorAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/actions/DeviceSelectorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectDeviceAction
    extends AnAction {
        @NotNull
        private final FlutterDevice device;

        SelectDeviceAction(@NotNull FlutterDevice device, @NotNull Collection<FlutterDevice> devices) {
            if (device == null) {
                SelectDeviceAction.$$$reportNull$$$0(0);
            }
            if (devices == null) {
                SelectDeviceAction.$$$reportNull$$$0(1);
            }
            super(device.getUniqueName(devices), null, FlutterIcons.Phone);
            this.device = device;
        }

        public String deviceName() {
            return this.device.deviceName();
        }

        public void actionPerformed(AnActionEvent e) {
            DeviceService service;
            Project project = e.getProject();
            DeviceService deviceService = service = project == null ? null : DeviceService.getInstance(project);
            if (service != null) {
                service.setSelectedDevice(this.device);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "device";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "devices";
                    break;
                }
            }
            objectArray[1] = "io/flutter/actions/DeviceSelectorAction$SelectDeviceAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NoDevicesAction
    extends AnAction
    implements AnAction.TransparentUpdate {
        NoDevicesAction(String message) {
            super(message, null, null);
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

