/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import icons.FlutterIcons;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

public class ProjectOpenActivity
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance(ProjectOpenActivity.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ProjectOpenActivity.$$$reportNull$$$0(0);
        }
        if (!FlutterModuleUtils.declaresFlutter(project)) {
            return;
        }
        FlutterSdk sdk = FlutterSdk.getIncomplete(project);
        if (sdk == null) {
            return;
        }
        for (PubRoot pubRoot : PubRoots.forProject(project)) {
            if (pubRoot.hasUpToDatePackages()) continue;
            Notifications.Bus.notify((Notification)new PackagesOutOfDateNotification(project, pubRoot));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/ProjectOpenActivity", "runActivity"));
    }

    private static class PackagesOutOfDateNotification
    extends Notification {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PubRoot myRoot;

        public PackagesOutOfDateNotification(final @NotNull Project project, final @NotNull PubRoot root) {
            if (project == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(0);
            }
            if (root == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(1);
            }
            super("Flutter Packages", FlutterIcons.Flutter, "Flutter packages get.", null, "The pubspec.yaml file has been modified since the last time 'flutter packages get' was run.", NotificationType.INFORMATION, null);
            this.myProject = project;
            this.myRoot = root;
            this.addAction(new AnAction("Run 'flutter packages get'"){

                public void actionPerformed(AnActionEvent event) {
                    this.expire();
                    FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
                    if (sdk == null) {
                        Messages.showErrorDialog((Project)project, (String)"Flutter SDK not found", (String)"Error");
                        return;
                    }
                    if (sdk.startPackagesGet(root, project) == null) {
                        Messages.showErrorDialog((String)"Unable to run 'flutter packages get'", (String)"Error");
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "io/flutter/ProjectOpenActivity$PackagesOutOfDateNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

