/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.psi.DartFile;
import io.flutter.FlutterConstants;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterRunConfigurationProducer;
import io.flutter.utils.FlutterModuleUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class FlutterUtils {
    private static final Pattern VALID_ID = Pattern.compile("[_a-zA-Z$][_a-zA-Z0-9$]*");
    private static final Pattern VALID_PACKAGE = Pattern.compile("^([a-z]++([_]?[a-z0-9]+)*)++$");

    private FlutterUtils() {
    }

    public static void invokeAndWait(@NotNull Runnable runnable) throws ProcessCanceledException {
        if (runnable == null) {
            FlutterUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.defaultModalityState());
    }

    public static boolean isFlutteryFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterUtils.$$$reportNull$$$0(1);
        }
        return FlutterUtils.isDartFile(file) || PubRoot.isPubspec(file);
    }

    public static boolean isDartFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterUtils.$$$reportNull$$$0(2);
        }
        return Objects.equals(file.getFileType(), DartFileType.INSTANCE);
    }

    public static boolean isAndroidStudio() {
        return StringUtil.equals((CharSequence)PlatformUtils.getPlatformPrefix(), (CharSequence)"AndroidStudio");
    }

    public static boolean is2017_3() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        if (appInfo == null) {
            return false;
        }
        return appInfo.getBuild().getBaselineVersion() == 173;
    }

    public static void disableGradleProjectMigrationNotification(@NotNull Project project) {
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(3);
        }
        String showMigrateToGradlePopup = "show.migrate.to.gradle.popup";
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        if (properties.getValue("show.migrate.to.gradle.popup") == null) {
            properties.setValue("show.migrate.to.gradle.popup", "false");
        }
    }

    public static boolean exists(@Nullable VirtualFile file) {
        return file != null && file.exists();
    }

    public static boolean isInFlutterProject(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            FlutterUtils.$$$reportNull$$$0(4);
        }
        return (module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) != null && FlutterModuleUtils.declaresFlutter(module);
    }

    public static boolean isInTestDir(@Nullable DartFile file) {
        if (file == null) {
            return false;
        }
        PubRoot root = PubRoot.forFile(file.getVirtualFile());
        if (root == null) {
            return false;
        }
        if (!FlutterModuleUtils.isFlutterModule(root.getModule(file.getProject()))) {
            return false;
        }
        VirtualFile candidate = FlutterRunConfigurationProducer.getFlutterEntryFile(file, false, false);
        if (candidate == null) {
            return false;
        }
        String relativePath = root.getRelativePath(candidate);
        return relativePath != null && relativePath.startsWith("test/");
    }

    @Nullable
    public static VirtualFile getRealVirtualFile(@Nullable PsiFile psiFile) {
        return psiFile != null ? psiFile.getOriginalFile().getVirtualFile() : null;
    }

    @Nullable
    public static DartFile getDartFile(@Nullable PsiElement elt) {
        if (elt == null) {
            return null;
        }
        PsiFile psiFile = elt.getContainingFile();
        if (!(psiFile instanceof DartFile)) {
            return null;
        }
        return (DartFile)psiFile;
    }

    public static void openFlutterSettings(@Nullable Project project) {
        ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"flutter.settings", (String)"");
    }

    public static boolean isDartKeyword(@NotNull String string) {
        if (string == null) {
            FlutterUtils.$$$reportNull$$$0(5);
        }
        return FlutterConstants.DART_KEYWORDS.contains(string);
    }

    public static boolean isValidDartIdentifier(@NotNull String id) {
        if (id == null) {
            FlutterUtils.$$$reportNull$$$0(6);
        }
        return VALID_ID.matcher(id).matches();
    }

    public static boolean isValidPackageName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(7);
        }
        return VALID_PACKAGE.matcher(name).matches();
    }

    public static boolean isXcodeFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(8);
        }
        return FlutterUtils.isXcodeProjectFileName(name) || FlutterUtils.isXcodeWorkspaceFileName(name);
    }

    public static boolean isXcodeProjectFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(9);
        }
        return name.endsWith(".xcodeproj");
    }

    public static boolean isXcodeWorkspaceFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(10);
        }
        return name.endsWith(".xcworkspace");
    }

    public static boolean runsCleanly(@NotNull GeneralCommandLine cmd) {
        if (cmd == null) {
            FlutterUtils.$$$reportNull$$$0(11);
        }
        try {
            return ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).getExitCode() == 0;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    public static PluginId getPluginId() {
        PluginId pluginId = PluginId.findId((String[])new String[]{"io.flutter"});
        assert (pluginId != null);
        PluginId pluginId2 = pluginId;
        if (pluginId2 == null) {
            FlutterUtils.$$$reportNull$$$0(12);
        }
        return pluginId2;
    }

    public static boolean declaresFlutter(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(13);
        }
        try {
            String contents = new String(pubspec.contentsToByteArray(true));
            Map<String, Object> yaml = FlutterUtils.loadPubspecInfo(contents);
            if (yaml == null) {
                return false;
            }
            Object name = yaml.get("name");
            if ("flutter".equals(name)) {
                return true;
            }
            Object dependencies = yaml.get("dependencies");
            if (dependencies instanceof Map) {
                return ((Map)dependencies).containsKey("flutter");
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isFlutterPlugin(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(14);
        }
        try {
            String contents = new String(pubspec.contentsToByteArray(true));
            Map<String, Object> yaml = FlutterUtils.loadPubspecInfo(contents);
            if (yaml == null) {
                return false;
            }
            Object flutterEntry = yaml.get("flutter");
            if (flutterEntry instanceof Map) {
                return ((Map)flutterEntry).containsKey("plugin");
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static Project findProject(@NotNull String path) {
        if (path == null) {
            FlutterUtils.$$$reportNull$$$0(15);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)path, (Project)project)) continue;
            return project;
        }
        return null;
    }

    private static Map<String, Object> loadPubspecInfo(@NotNull String yamlContents) {
        if (yamlContents == null) {
            FlutterUtils.$$$reportNull$$$0(16);
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), new DumperOptions(), new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
                this.addImplicitResolver(new Tag("tag:yaml.org,2002:value"), VALUE, "=");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            }
        });
        try {
            return (Map)yaml.load(yamlContents);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/FlutterUtils";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspec";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/FlutterUtils";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFlutteryFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDartFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disableGradleProjectMigrationNotification";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInFlutterProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDartKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidDartIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeFileName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeProjectFileName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeWorkspaceFileName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runsCleanly";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "declaresFlutter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterPlugin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPubspecInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

