/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.Disposable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import io.flutter.FlutterBundle;
import io.flutter.project.FlutterProjectModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSettingsStep
extends SkippableWizardStep<FlutterProjectModel> {
    private final StudioWizardStepPanel myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditButton myPackageName;
    private JCheckBox myKotlinCheckBox;
    private JCheckBox mySwiftCheckBox;

    public FlutterSettingsStep(FlutterProjectModel model, String title, Icon icon) {
        super((WizardModel)model, title, icon);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myKotlinCheckBox.setText(FlutterBundle.message((String)"module.wizard.language.name_kotlin", (Object[])new Object[0]));
        this.mySwiftCheckBox.setText(FlutterBundle.message((String)"module.wizard.language.name_swift", (Object[])new Object[0]));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(model.companyDomain(), model.projectName());
        BoolValueProperty isPackageSynced = new BoolValueProperty(Boolean.valueOf(true));
        this.myBindings.bind((SettableValue)packageNameText, (ObservableValue)computedPackageName, (ObservableValue)isPackageSynced);
        this.myBindings.bind((SettableValue)model.packageName(), (ObservableValue)packageNameText);
        this.myListeners.receive((ObservableValue)packageNameText, arg_0 -> FlutterSettingsStep.lambda$new$0((BoolProperty)isPackageSynced, (Expression)computedPackageName, arg_0));
        this.myBindings.bindTwoWay((SettableValue)new TextProperty((JTextComponent)this.myCompanyDomain), (SettableValue)model.companyDomain());
        this.myBindings.bindTwoWay((SettableValue)new SelectedProperty((AbstractButton)this.myKotlinCheckBox), (SettableValue)model.useKotlin());
        this.myBindings.bindTwoWay((SettableValue)new SelectedProperty((AbstractButton)this.mySwiftCheckBox), (SettableValue)model.useSwift());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)model.packageName(), value -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName((String)value)));
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myRootPanel);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            FlutterSettingsStep.$$$reportNull$$$0(0);
        }
        return studioWizardStepPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myCompanyDomain;
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            FlutterSettingsStep.$$$reportNull$$$0(1);
        }
        return observableBool;
    }

    private static /* synthetic */ void lambda$new$0(BoolProperty isPackageSynced, Expression computedPackageName, String value) {
        isPackageSynced.set((Object)value.equals(computedPackageName.get()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        LabelWithEditButton labelWithEditButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 1, new Insets(0, 5, 0, 5), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jLabel.setText("Company domain");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font2 = jLabel2.getFont();
        if (font2 != null) {
            jLabel2.setFont(new Font(font2.getName(), 1, font2.getSize()));
        }
        jLabel2.setText("Platform channel language");
        jPanel.add((Component)jLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        Font font3 = jLabel3.getFont();
        if (font3 != null) {
            jLabel3.setFont(new Font(font3.getName(), 1, font3.getSize()));
        }
        jLabel3.setText("Package name");
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(7, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myKotlinCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Kotlin");
        jCheckBox2.setToolTipText("Java support will be included");
        jPanel.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySwiftCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Swift");
        jCheckBox.setToolTipText("Objective-C support will be included");
        jPanel.add((Component)jCheckBox, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        Font font4 = jLabel4.getFont();
        if (font4 != null) {
            jLabel4.setFont(new Font(font4.getName(), 1, 20));
        }
        jLabel4.setText("Set the package name");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Applications and plugins need to generate platform-specific code");
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/flutter/project/FlutterSettingsStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

