/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import io.flutter.module.FlutterProjectType;
import io.flutter.project.FlutterProjectCreator;
import org.jetbrains.annotations.NotNull;

public class FlutterProjectModel
extends WizardModel {
    private static final String DEFAULT_DOMAIN = "example.com";
    private static final String PROPERTIES_DOMAIN_KEY = "FLUTTER_COMPANY_DOMAIN";
    private static final String PROPERTIES_KOTLIN_SUPPORT_KEY = "FLUTTER_PROJECT_KOTLIN_SUPPORT";
    private static final String PROPERTIES_SWIFT_SUPPORT_KEY = "FLUTTER_PROJECT_SWIFT_SUPPORT";
    @NotNull
    private final OptionalValueProperty<FlutterProjectType> myProjectType;
    @NotNull
    private final StringProperty myFlutterSdk;
    @NotNull
    private final StringProperty myProjectName;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final StringProperty myProjectLocation;
    @NotNull
    private final StringProperty myCompanyDomain;
    @NotNull
    private final StringProperty myDescription;
    @NotNull
    private final BoolValueProperty myKotlin;
    @NotNull
    private final BoolValueProperty mySwift;
    @NotNull
    private final OptionalProperty<Project> myProject;

    public FlutterProjectModel(@NotNull FlutterProjectType type) {
        if (type == null) {
            FlutterProjectModel.$$$reportNull$$$0(0);
        }
        this.myProjectType = new OptionalValueProperty();
        this.myFlutterSdk = new StringValueProperty();
        this.myProjectName = new StringValueProperty();
        this.myPackageName = new StringValueProperty();
        this.myProjectLocation = new StringValueProperty();
        this.myCompanyDomain = new StringValueProperty(FlutterProjectModel.getInitialDomain());
        this.myDescription = new StringValueProperty();
        this.myKotlin = new BoolValueProperty();
        this.mySwift = new BoolValueProperty();
        this.myProject = new OptionalValueProperty();
        this.myProjectType.set((ObservableValue)new OptionalValueProperty((Object)type));
        this.myCompanyDomain.addListener(sender -> {
            String domain = (String)this.myCompanyDomain.get();
            if (domain.isEmpty()) {
                domain = null;
            }
            PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
        });
        this.myProjectName.addConstraint(String::trim);
        this.myKotlin.set((Object)FlutterProjectModel.getInitialKotlinSupport());
        this.myKotlin.addListener(sender -> FlutterProjectModel.setInitialKotlinSupport(this.myKotlin.get()));
        this.mySwift.set((Object)FlutterProjectModel.getInitialSwiftSupport());
        this.mySwift.addListener(sender -> FlutterProjectModel.setInitialSwiftSupport(this.mySwift.get()));
    }

    @NotNull
    private static String getInitialDomain() {
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        String string = domain == null ? DEFAULT_DOMAIN : domain;
        if (string == null) {
            FlutterProjectModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean getInitialKotlinSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_KOTLIN_SUPPORT_KEY);
    }

    private static void setInitialKotlinSupport(boolean isSupported) {
        PropertiesComponent.getInstance().setValue(PROPERTIES_KOTLIN_SUPPORT_KEY, isSupported);
    }

    private static boolean getInitialSwiftSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_SWIFT_SUPPORT_KEY);
    }

    private static void setInitialSwiftSupport(boolean isSupported) {
        PropertiesComponent.getInstance().setValue(PROPERTIES_SWIFT_SUPPORT_KEY, isSupported);
    }

    @NotNull
    public OptionalValueProperty<FlutterProjectType> projectType() {
        OptionalValueProperty<FlutterProjectType> optionalValueProperty = this.myProjectType;
        if (optionalValueProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(2);
        }
        return optionalValueProperty;
    }

    @NotNull
    public StringProperty projectName() {
        StringProperty stringProperty = this.myProjectName;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(3);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty projectLocation() {
        StringProperty stringProperty = this.myProjectLocation;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(4);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty companyDomain() {
        StringProperty stringProperty = this.myCompanyDomain;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty description() {
        StringProperty stringProperty = this.myDescription;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    @NotNull
    public BoolValueProperty useKotlin() {
        BoolValueProperty boolValueProperty = this.myKotlin;
        if (boolValueProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(8);
        }
        return boolValueProperty;
    }

    @NotNull
    public BoolValueProperty useSwift() {
        BoolValueProperty boolValueProperty = this.mySwift;
        if (boolValueProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(9);
        }
        return boolValueProperty;
    }

    @NotNull
    public StringProperty flutterSdk() {
        StringProperty stringProperty = this.myFlutterSdk;
        if (stringProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(10);
        }
        return stringProperty;
    }

    @NotNull
    public OptionalProperty<Project> project() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            FlutterProjectModel.$$$reportNull$$$0(11);
        }
        return optionalProperty;
    }

    public void dispose() {
        super.dispose();
    }

    protected void handleFinished() {
        String location = (String)this.myProjectLocation.get();
        assert (!((String)this.myProjectName.get()).isEmpty());
        assert (!((String)this.myFlutterSdk.get()).isEmpty());
        assert (!location.isEmpty());
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        if (!FlutterProjectCreator.finalValidityCheckPassed(location)) {
            return;
        }
        new FlutterProjectCreator(this).createProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterProjectModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterProjectModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialDomain";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "projectType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "projectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "projectLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "companyDomain";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "useKotlin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "useSwift";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flutterSdk";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

