/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.repository.io.FileOpUtils;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.containers.ContainerUtil;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.module.FlutterProjectType;
import io.flutter.module.FlutterSmallIDEProjectGenerator;
import io.flutter.project.FlutterProjectModel;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class FlutterProjectCreator {
    private static final Logger LOG = Logger.getInstance(FlutterProjectCreator.class);
    private static final String SEPARATOR = "/";
    @NotNull
    private final FlutterProjectModel myModel;

    public FlutterProjectCreator(@NotNull FlutterProjectModel model) {
        if (model == null) {
            FlutterProjectCreator.$$$reportNull$$$0(0);
        }
        this.myModel = model;
    }

    public static void disableUserConfig(Project project) {
        if (FlutterModuleUtils.declaresFlutter((Project)project)) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                if (facet == null) continue;
                facet.getProperties().ALLOW_USER_CONFIGURATION = false;
            }
        }
    }

    public static boolean finalValidityCheckPassed(@NotNull String projectLocation) {
        boolean couldEnsureLocationExists;
        if (projectLocation == null) {
            FlutterProjectCreator.$$$reportNull$$$0(1);
        }
        if (!(couldEnsureLocationExists = ((Boolean)WriteCommandAction.runWriteCommandAction(null, () -> {
            if (projectLocation == null) {
                FlutterProjectCreator.$$$reportNull$$$0(12);
            }
            try {
                if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
            }
            return false;
        })).booleanValue())) {
            String msg = "Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.";
            Messages.showErrorDialog((String)String.format(msg, projectLocation), (String)"Error Creating Project");
            return false;
        }
        return true;
    }

    private static void deleteDirectoryContents(File location) {
        File[] files = location.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FlutterProjectCreator.deleteDirectoryContents(file);
                }
                file.delete();
            }
        }
    }

    private static void configureFacet(@NotNull AndroidFacet facet, @NotNull File location, @NotNull String dirName) {
        if (facet == null) {
            FlutterProjectCreator.$$$reportNull$$$0(2);
        }
        if (location == null) {
            FlutterProjectCreator.$$$reportNull$$$0(3);
        }
        if (dirName == null) {
            FlutterProjectCreator.$$$reportNull$$$0(4);
        }
        JpsAndroidModuleProperties facetProperties = facet.getProperties();
        File modulePath = new File(location, dirName);
        IdeaSourceProvider sourceProvider = IdeaSourceProvider.create((AndroidFacet)facet);
        facetProperties.MANIFEST_FILE_RELATIVE_PATH = FlutterProjectCreator.relativePath(modulePath, sourceProvider.getManifestFile());
        facetProperties.RES_FOLDER_RELATIVE_PATH = FlutterProjectCreator.relativePath(modulePath, sourceProvider.getResDirectories());
        facetProperties.ASSETS_FOLDER_RELATIVE_PATH = FlutterProjectCreator.relativePath(modulePath, sourceProvider.getAssetsDirectories());
        facetProperties.ALLOW_USER_CONFIGURATION = false;
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<VirtualFile> dirs) {
        if (basePath == null) {
            FlutterProjectCreator.$$$reportNull$$$0(5);
        }
        if (dirs == null) {
            FlutterProjectCreator.$$$reportNull$$$0(6);
        }
        String string = FlutterProjectCreator.relativePath(basePath, (VirtualFile)ContainerUtil.getFirstItem(dirs));
        if (string == null) {
            FlutterProjectCreator.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable VirtualFile file) {
        if (basePath == null) {
            FlutterProjectCreator.$$$reportNull$$$0(8);
        }
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)new File(file.getPath()));
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            String string = SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
            if (string == null) {
                FlutterProjectCreator.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("" == null) {
            FlutterProjectCreator.$$$reportNull$$$0(10);
        }
        return "";
    }

    private static String reversedOrgFromPackage(@NotNull String packageName) {
        int idx;
        if (packageName == null) {
            FlutterProjectCreator.$$$reportNull$$$0(11);
        }
        if ((idx = packageName.lastIndexOf(46)) <= 0) {
            return packageName;
        }
        return packageName.substring(0, idx);
    }

    private static void reloadProjectNow(Project project) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String presentableUrl = project.getPresentableUrl();
            if (!ProjectUtil.closeAndDispose((Project)project)) {
                return;
            }
            ProjectUtil.openProject((String)presentableUrl, null, (boolean)true);
        });
    }

    public void createModule() {
        Project project = (Project)this.myModel.project().getValue();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return;
        }
        String baseDirPath = baseDir.getPath();
        String moduleName = ProjectWizardUtil.findNonExistingFileName((String)baseDirPath, (String)((String)this.myModel.projectName().get()), (String)"");
        String contentRoot = baseDirPath + SEPARATOR + moduleName;
        File location = new File(contentRoot);
        if (!location.exists() && !location.mkdirs()) {
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)project, (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return;
        }
        FlutterModuleBuilder builder = new FlutterModuleBuilder(){

            @NotNull
            public FlutterCreateAdditionalSettings getAdditionalSettings() {
                FlutterCreateAdditionalSettings flutterCreateAdditionalSettings = FlutterProjectCreator.this.makeAdditionalSettings();
                if (flutterCreateAdditionalSettings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return flutterCreateAdditionalSettings;
            }

            protected FlutterSdk getFlutterSdk() {
                return FlutterSdk.forPath((String)((String)FlutterProjectCreator.this.myModel.flutterSdk().get()));
            }

            public boolean validate(Project current, Project dest) {
                return true;
            }

            public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
                return null;
            }

            public void setFlutterSdkPath(String s) {
            }

            public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
                if (settingsStep == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/project/FlutterProjectCreator$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsStep";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalSettings";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/project/FlutterProjectCreator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "modifySettingsStep";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        builder.setName((String)this.myModel.projectName().get());
        builder.setModuleFilePath(FileUtilRt.toSystemIndependentName((String)contentRoot) + SEPARATOR + moduleName + ".iml");
        builder.commitModule(project, null);
    }

    public void createProject() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project projectToClose = frame != null ? frame.getProject() : null;
        File location = new File(FileUtil.toSystemDependentName((String)((String)this.myModel.projectLocation().get())));
        if (!location.exists() && !location.mkdirs()) {
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)projectToClose, (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return;
        }
        final File baseFile = new File(location, (String)this.myModel.projectName().get());
        baseFile.mkdirs();
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(baseFile));
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getPath());
        ProjectOpenedCallback callback = (project, module) -> ProgressManager.getInstance().run((Task)new Task.Modal(null, "Creating Flutter Project", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                FlutterProjectCreator.deleteDirectoryContents(baseFile);
                if (FlutterProjectCreator.this.myModel.projectType().getValue() != FlutterProjectType.PACKAGE) {
                    ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
                    AndroidFacetType facetType = AndroidFacet.getFacetType();
                    AndroidFacet facet = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), null);
                    model.addFacet((Facet)facet);
                    FlutterProjectCreator.configureFacet(facet, baseFile, "android");
                    File appLocation = new File(baseFile, "android");
                    appLocation.mkdirs();
                    AndroidFacet appFacet = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), null);
                    model.addFacet((Facet)appFacet);
                    FlutterProjectCreator.configureFacet(appFacet, appLocation, "app");
                }
                FlutterSmallIDEProjectGenerator.generateProject((Project)project, (VirtualFile)baseDir, (String)((String)FlutterProjectCreator.this.myModel.flutterSdk().get()), (Module)module, (FlutterCreateAdditionalSettings)FlutterProjectCreator.this.makeAdditionalSettings());
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                ConversionService.getInstance().convertSilently(baseDir.getPath(), (ConversionListener)new MyConversionListener());
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                FlutterProjectCreator.reloadProjectNow(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/flutter/project/FlutterProjectCreator$2", "run"));
            }
        });
        EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
        PlatformProjectOpenProcessor.doOpenProject((VirtualFile)baseDir, (Project)projectToClose, (int)-1, (ProjectOpenedCallback)callback, options);
        Project newProject = FlutterUtils.findProject((String)baseDir.getPath());
        if (newProject != null) {
            StartupManager.getInstance((Project)newProject).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> {
                FlutterProjectCreator.disableUserConfig(newProject);
                ProjectView.getInstance((Project)newProject).changeView("ProjectPane");
            }, ModalityState.NON_MODAL));
        }
    }

    private FlutterCreateAdditionalSettings makeAdditionalSettings() {
        return new FlutterCreateAdditionalSettings.Builder().setDescription(((String)this.myModel.description().get()).isEmpty() ? null : (String)this.myModel.description().get()).setType((FlutterProjectType)this.myModel.projectType().getValue()).setOrg(((String)this.myModel.packageName().get()).isEmpty() ? null : FlutterProjectCreator.reversedOrgFromPackage((String)this.myModel.packageName().get())).setKotlin(this.myModel.useKotlin().get() != false ? Boolean.valueOf(true) : null).setSwift(this.myModel.useSwift().get() != false ? Boolean.valueOf(true) : null).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterProjectCreator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterProjectCreator";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "finalValidityCheckPassed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureFacet";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reversedOrgFromPackage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$finalValidityCheckPassed$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        public void successfullyConverted(File backupDir) {
            this.myConverted = true;
        }

        public void error(String message) {
        }

        public void cannotWriteToFiles(List<File> readonlyFiles) {
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }
    }
}

