/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BitUtil;
import io.flutter.FlutterMessages;
import io.flutter.actions.OpenInAndroidStudioAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenAndroidModule
extends OpenInAndroidStudioAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile projectFile = OpenAndroidModule.findProjectFile((AnActionEvent)e);
        if (projectFile == null) {
            FlutterMessages.showError((String)"Error Opening Android Studio", (String)"Project not found.");
            return;
        }
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || e.getPlace() == "WelcomeScreen";
        VirtualFile sourceFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        OpenAndroidModule.openOrImportProject(projectFile, e.getProject(), sourceFile, forceOpenInNewFrame);
    }

    private static void openOrImportProject(@NotNull VirtualFile projectFile, @Nullable Project project, @Nullable VirtualFile sourceFile, boolean forceOpenInNewFrame) {
        VirtualFile target;
        if (projectFile == null) {
            OpenAndroidModule.$$$reportNull$$$0(0);
        }
        if (OpenAndroidModule.canImportAsGradleProject(projectFile) && (target = ProjectImportUtil.findImportTarget((VirtualFile)projectFile)) != null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0) {
                int exitCode;
                int n = exitCode = forceOpenInNewFrame ? 0 : ProjectUtil.confirmOpenNewProject((boolean)false);
                if (exitCode == 1) {
                    Project toClose;
                    Project project2 = toClose = project != null && !project.isDefault() ? project : openProjects[openProjects.length - 1];
                    if (!ProjectUtil.closeAndDispose((Project)toClose)) {
                        return;
                    }
                } else if (exitCode != 0) {
                    return;
                }
            }
            GradleProjectImporter gradleImporter = GradleProjectImporter.getInstance();
            gradleImporter.importProject(projectFile);
            for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
                if (!projectFile.equals(proj.getBaseDir()) && !projectFile.equals(proj.getProjectFile())) continue;
                if (sourceFile == null || sourceFile.isDirectory()) break;
                OpenFileAction.openFile((VirtualFile)sourceFile, (Project)proj);
                break;
            }
            return;
        }
        Project newProject = ProjectUtil.openOrImport((String)projectFile.getPath(), (Project)project, (boolean)false);
        if (newProject != null) {
            FileChooserUtil.setLastOpenedFile((Project)newProject, (VirtualFile)projectFile);
            if (sourceFile != null && !sourceFile.isDirectory()) {
                OpenFileAction.openFile((VirtualFile)sourceFile, (Project)newProject);
            }
        }
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target;
        if (importSource == null) {
            OpenAndroidModule.$$$reportNull$$$0(1);
        }
        return (target = ProjectImportUtil.findImportTarget((VirtualFile)importSource)) != null && "gradle".equals(target.getExtension());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenAndroidModule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openOrImportProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canImportAsGradleProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

