/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.BoundField;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ContextRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.MapAssociation;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.TypeArgumentsRef;

public class Instance
extends Obj {
    public Instance(JsonObject json) {
        super(json);
    }

    public ElementList<MapAssociation> getAssociations() {
        if (this.json.get("associations") == null) {
            return null;
        }
        return new ElementList<MapAssociation>(this.json.get("associations").getAsJsonArray()){

            @Override
            protected MapAssociation basicGet(JsonArray array, int index) {
                return new MapAssociation(array.get(index).getAsJsonObject());
            }
        };
    }

    public InstanceRef getBound() {
        return this.json.get("bound") == null ? null : new InstanceRef((JsonObject)this.json.get("bound"));
    }

    public String getBytes() {
        return this.json.get("bytes").getAsString();
    }

    @Override
    public ClassRef getClassRef() {
        return new ClassRef((JsonObject)this.json.get("class"));
    }

    public ContextRef getClosureContext() {
        return this.json.get("closureContext") == null ? null : new ContextRef((JsonObject)this.json.get("closureContext"));
    }

    public FuncRef getClosureFunction() {
        return this.json.get("closureFunction") == null ? null : new FuncRef((JsonObject)this.json.get("closureFunction"));
    }

    public int getCount() {
        return this.json.get("count") == null ? -1 : this.json.get("count").getAsInt();
    }

    public ElementList<InstanceRef> getElements() {
        if (this.json.get("elements") == null) {
            return null;
        }
        return new ElementList<InstanceRef>(this.json.get("elements").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public ElementList<BoundField> getFields() {
        if (this.json.get("fields") == null) {
            return null;
        }
        return new ElementList<BoundField>(this.json.get("fields").getAsJsonArray()){

            @Override
            protected BoundField basicGet(JsonArray array, int index) {
                return new BoundField(array.get(index).getAsJsonObject());
            }
        };
    }

    public boolean getIsCaseSensitive() {
        return this.json.get("isCaseSensitive") == null ? false : this.json.get("isCaseSensitive").getAsBoolean();
    }

    public boolean getIsMultiLine() {
        return this.json.get("isMultiLine") == null ? false : this.json.get("isMultiLine").getAsBoolean();
    }

    public InstanceKind getKind() {
        String name = this.json.get("kind").getAsString();
        try {
            return InstanceKind.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return InstanceKind.Unknown;
        }
    }

    public int getLength() {
        return this.json.get("length") == null ? -1 : this.json.get("length").getAsInt();
    }

    public InstanceRef getMirrorReferent() {
        return this.json.get("mirrorReferent") == null ? null : new InstanceRef((JsonObject)this.json.get("mirrorReferent"));
    }

    public String getName() {
        return this.json.get("name").getAsString();
    }

    public int getOffset() {
        return this.json.get("offset") == null ? -1 : this.json.get("offset").getAsInt();
    }

    public int getParameterIndex() {
        return this.json.get("parameterIndex") == null ? -1 : this.json.get("parameterIndex").getAsInt();
    }

    public ClassRef getParameterizedClass() {
        return this.json.get("parameterizedClass") == null ? null : new ClassRef((JsonObject)this.json.get("parameterizedClass"));
    }

    public String getPattern() {
        return this.json.get("pattern").getAsString();
    }

    public InstanceRef getPropertyKey() {
        return this.json.get("propertyKey") == null ? null : new InstanceRef((JsonObject)this.json.get("propertyKey"));
    }

    public InstanceRef getPropertyValue() {
        return this.json.get("propertyValue") == null ? null : new InstanceRef((JsonObject)this.json.get("propertyValue"));
    }

    public InstanceRef getTargetType() {
        return this.json.get("targetType") == null ? null : new InstanceRef((JsonObject)this.json.get("targetType"));
    }

    public TypeArgumentsRef getTypeArguments() {
        return this.json.get("typeArguments") == null ? null : new TypeArgumentsRef((JsonObject)this.json.get("typeArguments"));
    }

    public ClassRef getTypeClass() {
        return this.json.get("typeClass") == null ? null : new ClassRef((JsonObject)this.json.get("typeClass"));
    }

    public String getValueAsString() {
        return this.json.get("valueAsString").getAsString();
    }

    public boolean getValueAsStringIsTruncated() {
        JsonElement elem = this.json.get("valueAsStringIsTruncated");
        return elem != null ? elem.getAsBoolean() : false;
    }
}

