/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.ObjRef;

public class FuncRef
extends ObjRef {
    public FuncRef(JsonObject json) {
        super(json);
    }

    public String getName() {
        return this.json.get("name").getAsString();
    }

    public Object getOwner() {
        JsonObject elem = (JsonObject)this.json.get("owner");
        if (elem == null) {
            return null;
        }
        if (elem.get("type").getAsString().equals("@Library")) {
            return new LibraryRef(elem);
        }
        if (elem.get("type").getAsString().equals("@Class")) {
            return new ClassRef(elem);
        }
        if (elem.get("type").getAsString().equals("@Func")) {
            return new FuncRef(elem);
        }
        return null;
    }

    public boolean isConst() {
        return this.json.get("const").getAsBoolean();
    }

    public boolean isStatic() {
        return this.json.get("static").getAsBoolean();
    }
}

