/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketException;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.consumer.Consumer;
import org.dartlang.vm.service.consumer.GetInstanceConsumer;
import org.dartlang.vm.service.consumer.GetLibraryConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.consumer.VersionConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.Version;
import org.dartlang.vm.service.internal.RequestSink;
import org.dartlang.vm.service.internal.VmServiceConst;
import org.dartlang.vm.service.internal.WebSocketRequestSink;
import org.dartlang.vm.service.logging.Logging;

abstract class VmServiceBase
implements VmServiceConst {
    private final Map<String, Consumer> consumerMap = Maps.newHashMap();
    private final Object consumerMapLock = new Object();
    private final AtomicInteger nextId = new AtomicInteger();
    private final List<VmServiceListener> vmListeners = new ArrayList<VmServiceListener>();
    RequestSink requestSink;

    VmServiceBase() {
    }

    public static VmService connect(final String url) throws IOException {
        WebSocket webSocket;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        String wsScheme = uri.getScheme();
        if (!"ws".equals(wsScheme) && !"wss".equals(wsScheme)) {
            throw new IOException("Unsupported URL scheme: " + wsScheme);
        }
        try {
            webSocket = new WebSocket(uri);
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to create websocket: " + url, e);
        }
        final VmService vmService = new VmService();
        webSocket.setEventHandler(new WebSocketEventHandler(){

            public void onClose() {
                Logging.getLogger().logInformation("VM connection closed: " + url);
                vmService.connectionClosed();
            }

            public void onMessage(WebSocketMessage message) {
                Logging.getLogger().logInformation("VM message: " + message.getText());
                try {
                    vmService.processResponse(message.getText());
                }
                catch (Exception e) {
                    Logging.getLogger().logError(e.getMessage(), e);
                }
            }

            public void onOpen() {
                vmService.connectionOpened();
                Logging.getLogger().logInformation("VM connection open: " + url);
            }

            public void onPing() {
            }

            public void onPong() {
            }
        });
        try {
            webSocket.connect();
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to connect: " + url, e);
        }
        vmService.requestSink = new WebSocketRequestSink(webSocket);
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] errMsg = new String[1];
        vmService.getVersion(new VersionConsumer(){

            @Override
            public void onError(RPCError error) {
                String msg = "Failed to determine protocol version: " + error.getCode() + "\n  message: " + error.getMessage() + "\n  details: " + error.getDetails();
                Logging.getLogger().logInformation(msg);
                errMsg[0] = msg;
            }

            @Override
            public void received(Version response) {
                int major = response.getMajor();
                int minor = response.getMinor();
                if (major != 3 || minor != 6) {
                    if (major == 2 || major == 3) {
                        Logging.getLogger().logInformation("Difference in protocol version: client=3.6 vm=" + major + "." + minor);
                    } else {
                        String msg = "Incompatible protocol version: client=3.6 vm=" + major + "." + minor;
                        Logging.getLogger().logError(msg);
                        errMsg[0] = msg;
                    }
                }
                latch.countDown();
            }
        });
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new IOException("Failed to determine protocol version");
            }
            if (errMsg[0] != null) {
                throw new IOException(errMsg[0]);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for response", e);
        }
        return vmService;
    }

    public static VmService localConnect(int port) throws IOException {
        return VmServiceBase.connect("ws://localhost:" + port + "/ws");
    }

    public void addVmServiceListener(VmServiceListener listener) {
        this.vmListeners.add(listener);
    }

    public void disconnect() {
        this.requestSink.close();
    }

    public void getInstance(String isolateId, String instanceId, final GetInstanceConsumer consumer) {
        this.getObject(isolateId, instanceId, new GetObjectConsumer(){

            @Override
            public void onError(RPCError error) {
                consumer.onError(error);
            }

            @Override
            public void received(Obj response) {
                if (response instanceof Instance) {
                    consumer.received((Instance)response);
                } else {
                    this.onError(RPCError.unexpected("Instance", response));
                }
            }

            @Override
            public void received(Sentinel response) {
                this.onError(RPCError.unexpected("Instance", response));
            }
        });
    }

    public void getLibrary(String isolateId, String libraryId, final GetLibraryConsumer consumer) {
        this.getObject(isolateId, libraryId, new GetObjectConsumer(){

            @Override
            public void onError(RPCError error) {
                consumer.onError(error);
            }

            @Override
            public void received(Obj response) {
                if (response instanceof Library) {
                    consumer.received((Library)response);
                } else {
                    this.onError(RPCError.unexpected("Library", response));
                }
            }

            @Override
            public void received(Sentinel response) {
                this.onError(RPCError.unexpected("Library", response));
            }
        });
    }

    public abstract void getObject(String var1, String var2, GetObjectConsumer var3);

    public void callServiceExtension(String isolateId, String method, ServiceExtensionConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request(method, params, consumer);
    }

    public void callServiceExtension(String isolateId, String method, JsonObject params, ServiceExtensionConsumer consumer) {
        params.addProperty("isolateId", isolateId);
        this.request(method, params, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(String method, JsonObject params, Consumer consumer) {
        String id = Integer.toString(this.nextId.incrementAndGet());
        JsonObject request = new JsonObject();
        request.addProperty("id", id);
        request.addProperty("method", method);
        request.add("params", (JsonElement)params);
        Object object = this.consumerMapLock;
        synchronized (object) {
            this.consumerMap.put(id, consumer);
        }
        this.requestSink.add(request);
    }

    public void connectionOpened() {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.connectionOpened();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception notifying listener", e);
            }
        }
    }

    private void forwardEvent(String streamId, Event event) {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.received(streamId, event);
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception processing event: " + streamId + ", " + event.getJson(), e);
            }
        }
    }

    public void connectionClosed() {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.connectionClosed();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception notifying listener", e);
            }
        }
    }

    abstract void forwardResponse(Consumer var1, String var2, JsonObject var3);

    void logUnknownResponse(Consumer consumer, JsonObject json) {
        Class<?> consumerClass = consumer.getClass();
        StringBuilder msg = new StringBuilder();
        msg.append("Expected response for ").append(consumerClass).append("\n");
        for (Class<?> interf : consumerClass.getInterfaces()) {
            msg.append("  implementing ").append(interf).append("\n");
        }
        msg.append("  but received ").append(json);
        Logging.getLogger().logError(msg.toString());
    }

    void processResponse(String jsonText) {
        String id;
        JsonObject json;
        if (jsonText == null || jsonText.isEmpty()) {
            return;
        }
        try {
            json = (JsonObject)new JsonParser().parse(jsonText);
        }
        catch (Exception e) {
            Logging.getLogger().logError("Parse response failed: " + jsonText, e);
            return;
        }
        JsonElement idElem = json.get("id");
        if (idElem == null) {
            Event event;
            String streamId;
            JsonObject params;
            String method;
            try {
                method = json.get("method").getAsString();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing method", e);
                return;
            }
            if (!"streamNotify".equals(method)) {
                Logging.getLogger().logError("Unknown event method: " + method);
                return;
            }
            try {
                params = json.get("params").getAsJsonObject();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing params", e);
                return;
            }
            try {
                streamId = params.get("streamId").getAsString();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing streamId", e);
                return;
            }
            try {
                event = new Event(params.get("event").getAsJsonObject());
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing event", e);
                return;
            }
            this.forwardEvent(streamId, event);
            return;
        }
        try {
            id = idElem.getAsString();
        }
        catch (Exception e) {
            Logging.getLogger().logError("Response missing id", e);
            return;
        }
        Consumer consumer = this.consumerMap.remove(id);
        if (consumer == null) {
            Logging.getLogger().logError("No consumer associated with id: " + id);
            return;
        }
        JsonElement resultElem = json.get("result");
        if (resultElem != null) {
            String responseType;
            JsonObject result;
            try {
                result = resultElem.getAsJsonObject();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response has invalid result", e);
                return;
            }
            try {
                responseType = result.get("type").getAsString();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response missing type", e);
                return;
            }
            this.forwardResponse(consumer, responseType, result);
            return;
        }
        resultElem = json.get("error");
        if (resultElem != null) {
            JsonObject error;
            try {
                error = resultElem.getAsJsonObject();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response has invalid result", e);
                return;
            }
            consumer.onError(new RPCError(error));
            return;
        }
        Logging.getLogger().logError("Response missing result and error");
    }
}

