/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.dartlang.vm.service.VmServiceBase;
import org.dartlang.vm.service.consumer.BreakpointConsumer;
import org.dartlang.vm.service.consumer.Consumer;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.EvaluateInFrameConsumer;
import org.dartlang.vm.service.consumer.FlagListConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.ReloadReportConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.consumer.SourceReportConsumer;
import org.dartlang.vm.service.consumer.StackConsumer;
import org.dartlang.vm.service.consumer.SuccessConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.consumer.VersionConsumer;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.Context;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorObj;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Field;
import org.dartlang.vm.service.element.FlagList;
import org.dartlang.vm.service.element.Func;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.Null;
import org.dartlang.vm.service.element.NullRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.ReloadReport;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.SourceReport;
import org.dartlang.vm.service.element.SourceReportKind;
import org.dartlang.vm.service.element.Stack;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.Success;
import org.dartlang.vm.service.element.TypeArguments;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.element.Version;

public class VmService
extends VmServiceBase {
    public static final String DEBUG_STREAM_ID = "Debug";
    public static final String EXTENSION_STREAM_ID = "Extension";
    public static final String GC_STREAM_ID = "GC";
    public static final String ISOLATE_STREAM_ID = "Isolate";
    public static final String STDERR_STREAM_ID = "Stderr";
    public static final String STDOUT_STREAM_ID = "Stdout";
    public static final String TIMELINE_STREAM_ID = "Timeline";
    public static final String VM_STREAM_ID = "VM";
    public static final int versionMajor = 3;
    public static final int versionMinor = 6;

    public void addBreakpoint(String isolateId, String scriptId, int line, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptId", scriptId);
        params.addProperty("line", (Number)line);
        this.request("addBreakpoint", params, consumer);
    }

    public void addBreakpoint(String isolateId, String scriptId, int line, Integer column, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptId", scriptId);
        params.addProperty("line", (Number)line);
        if (column != null) {
            params.addProperty("column", (Number)column);
        }
        this.request("addBreakpoint", params, consumer);
    }

    public void addBreakpointAtEntry(String isolateId, String functionId, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("functionId", functionId);
        this.request("addBreakpointAtEntry", params, consumer);
    }

    public void addBreakpointWithScriptUri(String isolateId, String scriptUri, int line, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptUri", scriptUri);
        params.addProperty("line", (Number)line);
        this.request("addBreakpointWithScriptUri", params, consumer);
    }

    public void addBreakpointWithScriptUri(String isolateId, String scriptUri, int line, Integer column, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptUri", scriptUri);
        params.addProperty("line", (Number)line);
        if (column != null) {
            params.addProperty("column", (Number)column);
        }
        this.request("addBreakpointWithScriptUri", params, consumer);
    }

    public void evaluate(String isolateId, String targetId, String expression, EvaluateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("expression", expression);
        this.request("evaluate", params, consumer);
    }

    public void evaluate(String isolateId, String targetId, String expression, Map<String, String> scope, EvaluateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("expression", expression);
        if (scope != null) {
            params.add("scope", (JsonElement)this.convertMapToJsonObject(scope));
        }
        this.request("evaluate", params, consumer);
    }

    public void evaluateInFrame(String isolateId, int frameIndex, String expression, EvaluateInFrameConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("frameIndex", (Number)frameIndex);
        params.addProperty("expression", expression);
        this.request("evaluateInFrame", params, consumer);
    }

    public void evaluateInFrame(String isolateId, int frameIndex, String expression, Map<String, String> scope, EvaluateInFrameConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("frameIndex", (Number)frameIndex);
        params.addProperty("expression", expression);
        if (scope != null) {
            params.add("scope", (JsonElement)this.convertMapToJsonObject(scope));
        }
        this.request("evaluateInFrame", params, consumer);
    }

    public void getFlagList(FlagListConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getFlagList", params, consumer);
    }

    public void getIsolate(String isolateId, GetIsolateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getIsolate", params, consumer);
    }

    @Override
    public void getObject(String isolateId, String objectId, GetObjectConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        this.request("getObject", params, consumer);
    }

    public void getObject(String isolateId, String objectId, Integer offset, Integer count, GetObjectConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        if (offset != null) {
            params.addProperty("offset", (Number)offset);
        }
        if (count != null) {
            params.addProperty("count", (Number)count);
        }
        this.request("getObject", params, consumer);
    }

    public void getSourceReport(String isolateId, ElementList<SourceReportKind> reports, SourceReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("reports", (JsonElement)this.convertIterableToJsonArray(reports));
        this.request("getSourceReport", params, consumer);
    }

    public void getSourceReport(String isolateId, ElementList<SourceReportKind> reports, String scriptId, Integer tokenPos, Integer endTokenPos, Boolean forceCompile, SourceReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("reports", (JsonElement)this.convertIterableToJsonArray(reports));
        if (scriptId != null) {
            params.addProperty("scriptId", scriptId);
        }
        if (tokenPos != null) {
            params.addProperty("tokenPos", (Number)tokenPos);
        }
        if (endTokenPos != null) {
            params.addProperty("endTokenPos", (Number)endTokenPos);
        }
        if (forceCompile != null) {
            params.addProperty("forceCompile", forceCompile);
        }
        this.request("getSourceReport", params, consumer);
    }

    public void getStack(String isolateId, StackConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getStack", params, consumer);
    }

    public void getVM(VMConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVM", params, consumer);
    }

    public void getVersion(VersionConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVersion", params, consumer);
    }

    public void pause(String isolateId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("pause", params, consumer);
    }

    public void reloadSources(String isolateId, Boolean force, Boolean pause, String rootLibUri, String packagesUri, ReloadReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (force != null) {
            params.addProperty("force", force);
        }
        if (pause != null) {
            params.addProperty("pause", pause);
        }
        if (rootLibUri != null) {
            params.addProperty("rootLibUri", rootLibUri);
        }
        if (packagesUri != null) {
            params.addProperty("packagesUri", packagesUri);
        }
        this.request("reloadSources", params, consumer);
    }

    public void reloadSources(String isolateId, ReloadReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("reloadSources", params, consumer);
    }

    public void removeBreakpoint(String isolateId, String breakpointId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("breakpointId", breakpointId);
        this.request("removeBreakpoint", params, consumer);
    }

    public void resume(String isolateId, StepOption step, Integer frameIndex, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (step != null) {
            params.addProperty("step", step.name());
        }
        if (frameIndex != null) {
            params.addProperty("frameIndex", (Number)frameIndex);
        }
        this.request("resume", params, consumer);
    }

    public void resume(String isolateId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("resume", params, consumer);
    }

    public void setExceptionPauseMode(String isolateId, ExceptionPauseMode mode, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("mode", mode.name());
        this.request("setExceptionPauseMode", params, consumer);
    }

    public void setLibraryDebuggable(String isolateId, String libraryId, boolean isDebuggable, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("libraryId", libraryId);
        params.addProperty("isDebuggable", Boolean.valueOf(isDebuggable));
        this.request("setLibraryDebuggable", params, consumer);
    }

    public void setName(String isolateId, String name, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("name", name);
        this.request("setName", params, consumer);
    }

    public void setVMName(String name, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        this.request("setVMName", params, consumer);
    }

    public void streamCancel(String streamId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("streamId", streamId);
        this.request("streamCancel", params, consumer);
    }

    public void streamListen(String streamId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("streamId", streamId);
        this.request("streamListen", params, consumer);
    }

    private JsonArray convertIterableToJsonArray(Iterable list) {
        JsonArray arr = new JsonArray();
        for (Object element : list) {
            arr.add((JsonElement)new JsonPrimitive(element.toString()));
        }
        return arr;
    }

    private JsonObject convertMapToJsonObject(Map<String, String> map) {
        JsonObject obj = new JsonObject();
        for (String key : map.keySet()) {
            obj.addProperty(key, map.get(key));
        }
        return obj;
    }

    @Override
    void forwardResponse(Consumer consumer, String responseType, JsonObject json) {
        if (consumer instanceof BreakpointConsumer && responseType.equals("Breakpoint")) {
            ((BreakpointConsumer)consumer).received(new Breakpoint(json));
            return;
        }
        if (consumer instanceof EvaluateConsumer) {
            if (responseType.equals("@Error")) {
                ((EvaluateConsumer)consumer).received(new ErrorRef(json));
                return;
            }
            if (responseType.equals("@Instance")) {
                ((EvaluateConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((EvaluateConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((EvaluateConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof EvaluateInFrameConsumer) {
            if (responseType.equals("@Error")) {
                ((EvaluateInFrameConsumer)consumer).received(new ErrorRef(json));
                return;
            }
            if (responseType.equals("@Instance")) {
                ((EvaluateInFrameConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((EvaluateInFrameConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((EvaluateInFrameConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof FlagListConsumer && responseType.equals("FlagList")) {
            ((FlagListConsumer)consumer).received(new FlagList(json));
            return;
        }
        if (consumer instanceof GetIsolateConsumer) {
            if (responseType.equals(ISOLATE_STREAM_ID)) {
                ((GetIsolateConsumer)consumer).received(new Isolate(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetIsolateConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetObjectConsumer) {
            if (responseType.equals("Breakpoint")) {
                ((GetObjectConsumer)consumer).received(new Breakpoint(json));
                return;
            }
            if (responseType.equals("Class")) {
                ((GetObjectConsumer)consumer).received(new ClassObj(json));
                return;
            }
            if (responseType.equals("Context")) {
                ((GetObjectConsumer)consumer).received(new Context(json));
                return;
            }
            if (responseType.equals("Error")) {
                ((GetObjectConsumer)consumer).received(new ErrorObj(json));
                return;
            }
            if (responseType.equals("Field")) {
                ((GetObjectConsumer)consumer).received(new Field(json));
                return;
            }
            if (responseType.equals("Function")) {
                ((GetObjectConsumer)consumer).received(new Func(json));
                return;
            }
            if (responseType.equals("Instance")) {
                ((GetObjectConsumer)consumer).received(new Instance(json));
                return;
            }
            if (responseType.equals("Library")) {
                ((GetObjectConsumer)consumer).received(new Library(json));
                return;
            }
            if (responseType.equals("Null")) {
                ((GetObjectConsumer)consumer).received(new Null(json));
                return;
            }
            if (responseType.equals("Object")) {
                ((GetObjectConsumer)consumer).received(new Obj(json));
                return;
            }
            if (responseType.equals("Script")) {
                ((GetObjectConsumer)consumer).received(new Script(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetObjectConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("TypeArguments")) {
                ((GetObjectConsumer)consumer).received(new TypeArguments(json));
                return;
            }
        }
        if (consumer instanceof ReloadReportConsumer && responseType.equals("ReloadReport")) {
            ((ReloadReportConsumer)consumer).received(new ReloadReport(json));
            return;
        }
        if (consumer instanceof SourceReportConsumer && responseType.equals("SourceReport")) {
            ((SourceReportConsumer)consumer).received(new SourceReport(json));
            return;
        }
        if (consumer instanceof StackConsumer && responseType.equals("Stack")) {
            ((StackConsumer)consumer).received(new Stack(json));
            return;
        }
        if (consumer instanceof SuccessConsumer && responseType.equals("Success")) {
            ((SuccessConsumer)consumer).received(new Success(json));
            return;
        }
        if (consumer instanceof VMConsumer && responseType.equals(VM_STREAM_ID)) {
            ((VMConsumer)consumer).received(new VM(json));
            return;
        }
        if (consumer instanceof VersionConsumer && responseType.equals("Version")) {
            ((VersionConsumer)consumer).received(new Version(json));
            return;
        }
        if (consumer instanceof ServiceExtensionConsumer) {
            ((ServiceExtensionConsumer)consumer).received(json);
            return;
        }
        this.logUnknownResponse(consumer, json);
    }
}

