/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RequestError {
    public static final RequestError[] EMPTY_ARRAY = new RequestError[0];
    public static final List<RequestError> EMPTY_LIST = Lists.newArrayList();
    private final String code;
    private final String message;
    private final String stackTrace;

    public RequestError(String code, String message, String stackTrace) {
        this.code = code;
        this.message = message;
        this.stackTrace = stackTrace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequestError) {
            RequestError other = (RequestError)obj;
            return ObjectUtilities.equals(other.code, this.code) && ObjectUtilities.equals(other.message, this.message) && ObjectUtilities.equals(other.stackTrace, this.stackTrace);
        }
        return false;
    }

    public static RequestError fromJson(JsonObject jsonObject) {
        String code = jsonObject.get("code").getAsString();
        String message = jsonObject.get("message").getAsString();
        String stackTrace = jsonObject.get("stackTrace") == null ? null : jsonObject.get("stackTrace").getAsString();
        return new RequestError(code, message, stackTrace);
    }

    public static List<RequestError> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<RequestError> list = new ArrayList<RequestError>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(RequestError.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.code);
        builder.append((Object)this.message);
        builder.append((Object)this.stackTrace);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("code", this.code);
        jsonObject.addProperty("message", this.message);
        if (this.stackTrace != null) {
            jsonObject.addProperty("stackTrace", this.stackTrace);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("code=");
        builder.append(this.code + ", ");
        builder.append("message=");
        builder.append(this.message + ", ");
        builder.append("stackTrace=");
        builder.append(this.stackTrace);
        builder.append("]");
        return builder.toString();
    }
}

