/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;

public class RenameFeedback
extends RefactoringFeedback {
    public static final RenameFeedback[] EMPTY_ARRAY = new RenameFeedback[0];
    public static final List<RenameFeedback> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final String elementKindName;
    private final String oldName;

    public RenameFeedback(int offset, int length, String elementKindName, String oldName) {
        this.offset = offset;
        this.length = length;
        this.elementKindName = elementKindName;
        this.oldName = oldName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RenameFeedback) {
            RenameFeedback other = (RenameFeedback)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.elementKindName, this.elementKindName) && ObjectUtilities.equals(other.oldName, this.oldName);
        }
        return false;
    }

    public static RenameFeedback fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        String elementKindName = jsonObject.get("elementKindName").getAsString();
        String oldName = jsonObject.get("oldName").getAsString();
        return new RenameFeedback(offset, length, elementKindName, oldName);
    }

    public static List<RenameFeedback> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<RenameFeedback> list = new ArrayList<RenameFeedback>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(RenameFeedback.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getElementKindName() {
        return this.elementKindName;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOldName() {
        return this.oldName;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.elementKindName);
        builder.append((Object)this.oldName);
        return builder.toHashCode();
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("elementKindName", this.elementKindName);
        jsonObject.addProperty("oldName", this.oldName);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("elementKindName=");
        builder.append(this.elementKindName + ", ");
        builder.append("oldName=");
        builder.append(this.oldName);
        builder.append("]");
        return builder.toString();
    }
}

