/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RefactoringMethodParameter {
    public static final RefactoringMethodParameter[] EMPTY_ARRAY = new RefactoringMethodParameter[0];
    public static final List<RefactoringMethodParameter> EMPTY_LIST = Lists.newArrayList();
    private String id;
    private String kind;
    private String type;
    private String name;
    private String parameters;

    public RefactoringMethodParameter(String id, String kind, String type, String name, String parameters) {
        this.id = id;
        this.kind = kind;
        this.type = type;
        this.name = name;
        this.parameters = parameters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RefactoringMethodParameter) {
            RefactoringMethodParameter other = (RefactoringMethodParameter)obj;
            return ObjectUtilities.equals(other.id, this.id) && ObjectUtilities.equals(other.kind, this.kind) && ObjectUtilities.equals(other.type, this.type) && ObjectUtilities.equals(other.name, this.name) && ObjectUtilities.equals(other.parameters, this.parameters);
        }
        return false;
    }

    public static RefactoringMethodParameter fromJson(JsonObject jsonObject) {
        String id = jsonObject.get("id") == null ? null : jsonObject.get("id").getAsString();
        String kind = jsonObject.get("kind").getAsString();
        String type = jsonObject.get("type").getAsString();
        String name = jsonObject.get("name").getAsString();
        String parameters = jsonObject.get("parameters") == null ? null : jsonObject.get("parameters").getAsString();
        return new RefactoringMethodParameter(id, kind, type, name, parameters);
    }

    public static List<RefactoringMethodParameter> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<RefactoringMethodParameter> list = new ArrayList<RefactoringMethodParameter>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(RefactoringMethodParameter.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.id);
        builder.append((Object)this.kind);
        builder.append((Object)this.type);
        builder.append((Object)this.name);
        builder.append((Object)this.parameters);
        return builder.toHashCode();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.id != null) {
            jsonObject.addProperty("id", this.id);
        }
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("type", this.type);
        jsonObject.addProperty("name", this.name);
        if (this.parameters != null) {
            jsonObject.addProperty("parameters", this.parameters);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.id + ", ");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("type=");
        builder.append(this.type + ", ");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("parameters=");
        builder.append(this.parameters);
        builder.append("]");
        return builder.toString();
    }
}

