/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PubStatus {
    public static final PubStatus[] EMPTY_ARRAY = new PubStatus[0];
    public static final List<PubStatus> EMPTY_LIST = Lists.newArrayList();
    private final boolean isListingPackageDirs;

    public PubStatus(boolean isListingPackageDirs) {
        this.isListingPackageDirs = isListingPackageDirs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PubStatus) {
            PubStatus other = (PubStatus)obj;
            return other.isListingPackageDirs == this.isListingPackageDirs;
        }
        return false;
    }

    public static PubStatus fromJson(JsonObject jsonObject) {
        boolean isListingPackageDirs = jsonObject.get("isListingPackageDirs").getAsBoolean();
        return new PubStatus(isListingPackageDirs);
    }

    public static List<PubStatus> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<PubStatus> list = new ArrayList<PubStatus>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(PubStatus.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean isListingPackageDirs() {
        return this.isListingPackageDirs;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.isListingPackageDirs);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("isListingPackageDirs", Boolean.valueOf(this.isListingPackageDirs));
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("isListingPackageDirs=");
        builder.append(this.isListingPackageDirs);
        builder.append("]");
        return builder.toString();
    }
}

