/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PostfixCompletionTemplate {
    public static final PostfixCompletionTemplate[] EMPTY_ARRAY = new PostfixCompletionTemplate[0];
    private final String key;
    private final String name;
    private final String example;

    public PostfixCompletionTemplate(String key, String name, String example) {
        this.key = key;
        this.name = name;
        this.example = example;
    }

    public static PostfixCompletionTemplate fromJson(JsonObject jsonObject) {
        String name = jsonObject.get("name") == null ? null : jsonObject.get("name").getAsString();
        String key = jsonObject.get("key") == null ? null : jsonObject.get("key").getAsString();
        String example = jsonObject.get("example") == null ? null : jsonObject.get("example").getAsString();
        return new PostfixCompletionTemplate(key, name, example);
    }

    public static PostfixCompletionTemplate[] fromStringArray(String[][] strings) {
        if (strings == null) {
            return EMPTY_ARRAY;
        }
        ArrayList list = new ArrayList(strings.length);
        PostfixCompletionTemplate[] templates = new PostfixCompletionTemplate[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            templates[i] = new PostfixCompletionTemplate(strings[i][1], strings[i][0], strings[i][2]);
        }
        return templates;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PostfixCompletionTemplate) {
            PostfixCompletionTemplate other = (PostfixCompletionTemplate)obj;
            return StringUtil.equals((CharSequence)this.key, (CharSequence)other.key) && StringUtil.equals((CharSequence)this.name, (CharSequence)other.name) && StringUtil.equals((CharSequence)this.example, (CharSequence)other.example);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append((Object)this.key);
        builder.append((Object)this.example);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("name=");
        builder.append(this.name);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", example=");
        builder.append(this.example);
        builder.append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    public String getKey() {
        return this.key;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.name != null) {
            jsonObject.addProperty("name", this.name);
        }
        if (this.key != null) {
            jsonObject.addProperty("key", this.key);
        }
        if (this.example != null) {
            jsonObject.addProperty("example", this.example);
        }
        return jsonObject;
    }
}

