/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;

public class OverriddenMember {
    public static final OverriddenMember[] EMPTY_ARRAY = new OverriddenMember[0];
    public static final List<OverriddenMember> EMPTY_LIST = Lists.newArrayList();
    private final Element element;
    private final String className;

    public OverriddenMember(Element element, String className) {
        this.element = element;
        this.className = className;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OverriddenMember) {
            OverriddenMember other = (OverriddenMember)obj;
            return ObjectUtilities.equals(other.element, this.element) && ObjectUtilities.equals(other.className, this.className);
        }
        return false;
    }

    public static OverriddenMember fromJson(JsonObject jsonObject) {
        Element element = Element.fromJson(jsonObject.get("element").getAsJsonObject());
        String className = jsonObject.get("className").getAsString();
        return new OverriddenMember(element, className);
    }

    public static List<OverriddenMember> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<OverriddenMember> list = new ArrayList<OverriddenMember>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(OverriddenMember.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getClassName() {
        return this.className;
    }

    public Element getElement() {
        return this.element;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.element);
        builder.append((Object)this.className);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("element", (JsonElement)this.element.toJson());
        jsonObject.addProperty("className", this.className);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("element=");
        builder.append(this.element + ", ");
        builder.append("className=");
        builder.append(this.className);
        builder.append("]");
        return builder.toString();
    }
}

