/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NavigationTarget {
    public static final NavigationTarget[] EMPTY_ARRAY = new NavigationTarget[0];
    public static final List<NavigationTarget> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final int fileIndex;
    private final int offset;
    private final int length;
    private final int startLine;
    private final int startColumn;
    private String file;

    public NavigationTarget(String kind, int fileIndex, int offset, int length, int startLine, int startColumn) {
        this.kind = kind;
        this.fileIndex = fileIndex;
        this.offset = offset;
        this.length = length;
        this.startLine = startLine;
        this.startColumn = startColumn;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NavigationTarget) {
            NavigationTarget other = (NavigationTarget)obj;
            return ObjectUtilities.equals(other.kind, this.kind) && other.fileIndex == this.fileIndex && other.offset == this.offset && other.length == this.length && other.startLine == this.startLine && other.startColumn == this.startColumn;
        }
        return false;
    }

    public static NavigationTarget fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        int fileIndex = jsonObject.get("fileIndex").getAsInt();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        int startLine = jsonObject.get("startLine").getAsInt();
        int startColumn = jsonObject.get("startColumn").getAsInt();
        return new NavigationTarget(kind, fileIndex, offset, length, startLine, startColumn);
    }

    public static List<NavigationTarget> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<NavigationTarget> list = new ArrayList<NavigationTarget>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(NavigationTarget.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getFile() {
        return this.file;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getKind() {
        return this.kind;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append(this.fileIndex);
        builder.append(this.offset);
        builder.append(this.length);
        builder.append(this.startLine);
        builder.append(this.startColumn);
        return builder.toHashCode();
    }

    public void lookupFile(String[] allTargetFiles) {
        this.file = allTargetFiles[this.fileIndex];
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("fileIndex", (Number)this.fileIndex);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("startLine", (Number)this.startLine);
        jsonObject.addProperty("startColumn", (Number)this.startColumn);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("fileIndex=");
        builder.append(this.fileIndex + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("startLine=");
        builder.append(this.startLine + ", ");
        builder.append("startColumn=");
        builder.append(this.startColumn);
        builder.append("]");
        return builder.toString();
    }
}

