/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LinkedEditSuggestion {
    public static final LinkedEditSuggestion[] EMPTY_ARRAY = new LinkedEditSuggestion[0];
    public static final List<LinkedEditSuggestion> EMPTY_LIST = Lists.newArrayList();
    private final String value;
    private final String kind;

    public LinkedEditSuggestion(String value, String kind) {
        this.value = value;
        this.kind = kind;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedEditSuggestion) {
            LinkedEditSuggestion other = (LinkedEditSuggestion)obj;
            return ObjectUtilities.equals(other.value, this.value) && ObjectUtilities.equals(other.kind, this.kind);
        }
        return false;
    }

    public static LinkedEditSuggestion fromJson(JsonObject jsonObject) {
        String value = jsonObject.get("value").getAsString();
        String kind = jsonObject.get("kind").getAsString();
        return new LinkedEditSuggestion(value, kind);
    }

    public static List<LinkedEditSuggestion> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<LinkedEditSuggestion> list = new ArrayList<LinkedEditSuggestion>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(LinkedEditSuggestion.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.value);
        builder.append((Object)this.kind);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", this.value);
        jsonObject.addProperty("kind", this.kind);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("value=");
        builder.append(this.value + ", ");
        builder.append("kind=");
        builder.append(this.kind);
        builder.append("]");
        return builder.toString();
    }
}

