/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.LinkedEditSuggestion;
import org.dartlang.analysis.server.protocol.Position;

public class LinkedEditGroup {
    public static final LinkedEditGroup[] EMPTY_ARRAY = new LinkedEditGroup[0];
    public static final List<LinkedEditGroup> EMPTY_LIST = Lists.newArrayList();
    private final List<Position> positions;
    private final int length;
    private final List<LinkedEditSuggestion> suggestions;

    public LinkedEditGroup(List<Position> positions, int length, List<LinkedEditSuggestion> suggestions) {
        this.positions = positions;
        this.length = length;
        this.suggestions = suggestions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedEditGroup) {
            LinkedEditGroup other = (LinkedEditGroup)obj;
            return ObjectUtilities.equals(other.positions, this.positions) && other.length == this.length && ObjectUtilities.equals(other.suggestions, this.suggestions);
        }
        return false;
    }

    public static LinkedEditGroup fromJson(JsonObject jsonObject) {
        List<Position> positions = Position.fromJsonArray(jsonObject.get("positions").getAsJsonArray());
        int length = jsonObject.get("length").getAsInt();
        List<LinkedEditSuggestion> suggestions = LinkedEditSuggestion.fromJsonArray(jsonObject.get("suggestions").getAsJsonArray());
        return new LinkedEditGroup(positions, length, suggestions);
    }

    public static List<LinkedEditGroup> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<LinkedEditGroup> list = new ArrayList<LinkedEditGroup>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(LinkedEditGroup.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public int getLength() {
        return this.length;
    }

    public List<Position> getPositions() {
        return this.positions;
    }

    public List<LinkedEditSuggestion> getSuggestions() {
        return this.suggestions;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.positions);
        builder.append(this.length);
        builder.append(this.suggestions);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArrayPositions = new JsonArray();
        for (Position elt : this.positions) {
            jsonArrayPositions.add((JsonElement)elt.toJson());
        }
        jsonObject.add("positions", (JsonElement)jsonArrayPositions);
        jsonObject.addProperty("length", (Number)this.length);
        JsonArray jsonArraySuggestions = new JsonArray();
        for (LinkedEditSuggestion elt : this.suggestions) {
            jsonArraySuggestions.add((JsonElement)elt.toJson());
        }
        jsonObject.add("suggestions", (JsonElement)jsonArraySuggestions);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("positions=");
        builder.append(StringUtils.join(this.positions, (String)", ") + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("suggestions=");
        builder.append(StringUtils.join(this.suggestions, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

