/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;

public class InlineMethodFeedback
extends RefactoringFeedback {
    public static final InlineMethodFeedback[] EMPTY_ARRAY = new InlineMethodFeedback[0];
    public static final List<InlineMethodFeedback> EMPTY_LIST = Lists.newArrayList();
    private final String className;
    private final String methodName;
    private final boolean isDeclaration;

    public InlineMethodFeedback(String className, String methodName, boolean isDeclaration) {
        this.className = className;
        this.methodName = methodName;
        this.isDeclaration = isDeclaration;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InlineMethodFeedback) {
            InlineMethodFeedback other = (InlineMethodFeedback)obj;
            return ObjectUtilities.equals(other.className, this.className) && ObjectUtilities.equals(other.methodName, this.methodName) && other.isDeclaration == this.isDeclaration;
        }
        return false;
    }

    public static InlineMethodFeedback fromJson(JsonObject jsonObject) {
        String className = jsonObject.get("className") == null ? null : jsonObject.get("className").getAsString();
        String methodName = jsonObject.get("methodName").getAsString();
        boolean isDeclaration = jsonObject.get("isDeclaration").getAsBoolean();
        return new InlineMethodFeedback(className, methodName, isDeclaration);
    }

    public static List<InlineMethodFeedback> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<InlineMethodFeedback> list = new ArrayList<InlineMethodFeedback>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(InlineMethodFeedback.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isDeclaration() {
        return this.isDeclaration;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.className);
        builder.append((Object)this.methodName);
        builder.append(this.isDeclaration);
        return builder.toHashCode();
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.className != null) {
            jsonObject.addProperty("className", this.className);
        }
        jsonObject.addProperty("methodName", this.methodName);
        jsonObject.addProperty("isDeclaration", Boolean.valueOf(this.isDeclaration));
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("className=");
        builder.append(this.className + ", ");
        builder.append("methodName=");
        builder.append(this.methodName + ", ");
        builder.append("isDeclaration=");
        builder.append(this.isDeclaration);
        builder.append("]");
        return builder.toString();
    }
}

