/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ImportedElements {
    public static final ImportedElements[] EMPTY_ARRAY = new ImportedElements[0];
    public static final List<ImportedElements> EMPTY_LIST = Lists.newArrayList();
    private final String path;
    private final String prefix;
    private final List<String> elements;

    public ImportedElements(String path, String prefix, List<String> elements) {
        this.path = path;
        this.prefix = prefix;
        this.elements = elements;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImportedElements) {
            ImportedElements other = (ImportedElements)obj;
            return ObjectUtilities.equals(other.path, this.path) && ObjectUtilities.equals(other.prefix, this.prefix) && ObjectUtilities.equals(other.elements, this.elements);
        }
        return false;
    }

    public static ImportedElements fromJson(JsonObject jsonObject) {
        String path = jsonObject.get("path").getAsString();
        String prefix = jsonObject.get("prefix").getAsString();
        List<String> elements = JsonUtilities.decodeStringList(jsonObject.get("elements").getAsJsonArray());
        return new ImportedElements(path, prefix, elements);
    }

    public static List<ImportedElements> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ImportedElements> list = new ArrayList<ImportedElements>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ImportedElements.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getPath() {
        return this.path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.path);
        builder.append((Object)this.prefix);
        builder.append(this.elements);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("path", this.path);
        jsonObject.addProperty("prefix", this.prefix);
        JsonArray jsonArrayElements = new JsonArray();
        for (String elt : this.elements) {
            jsonArrayElements.add((JsonElement)new JsonPrimitive(elt));
        }
        jsonObject.add("elements", (JsonElement)jsonArrayElements);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("path=");
        builder.append(this.path + ", ");
        builder.append("prefix=");
        builder.append(this.prefix + ", ");
        builder.append("elements=");
        builder.append(StringUtils.join(this.elements, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

