/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ImplementedClass {
    public static final ImplementedClass[] EMPTY_ARRAY = new ImplementedClass[0];
    public static final List<ImplementedClass> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;

    public ImplementedClass(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImplementedClass) {
            ImplementedClass other = (ImplementedClass)obj;
            return other.offset == this.offset && other.length == this.length;
        }
        return false;
    }

    public static ImplementedClass fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        return new ImplementedClass(offset, length);
    }

    public static List<ImplementedClass> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ImplementedClass> list = new ArrayList<ImplementedClass>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ImplementedClass.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

