/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HighlightRegion {
    public static final HighlightRegion[] EMPTY_ARRAY = new HighlightRegion[0];
    public static final List<HighlightRegion> EMPTY_LIST = Lists.newArrayList();
    private final String type;
    private final int offset;
    private final int length;

    public HighlightRegion(String type, int offset, int length) {
        this.type = type;
        this.offset = offset;
        this.length = length;
    }

    public boolean containsInclusive(int x) {
        return this.offset <= x && x <= this.offset + this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HighlightRegion) {
            HighlightRegion other = (HighlightRegion)obj;
            return ObjectUtilities.equals(other.type, this.type) && other.offset == this.offset && other.length == this.length;
        }
        return false;
    }

    public static HighlightRegion fromJson(JsonObject jsonObject) {
        String type = jsonObject.get("type").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        return new HighlightRegion(type, offset, length);
    }

    public static List<HighlightRegion> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<HighlightRegion> list = new ArrayList<HighlightRegion>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(HighlightRegion.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append(this.offset);
        builder.append(this.length);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.type);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("type=");
        builder.append(this.type + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

