/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringMethodParameter;

public class ExtractMethodFeedback
extends RefactoringFeedback {
    public static final ExtractMethodFeedback[] EMPTY_ARRAY = new ExtractMethodFeedback[0];
    public static final List<ExtractMethodFeedback> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final String returnType;
    private final List<String> names;
    private final boolean canCreateGetter;
    private final List<RefactoringMethodParameter> parameters;
    private final int[] offsets;
    private final int[] lengths;

    public ExtractMethodFeedback(int offset, int length, String returnType, List<String> names, boolean canCreateGetter, List<RefactoringMethodParameter> parameters, int[] offsets, int[] lengths) {
        this.offset = offset;
        this.length = length;
        this.returnType = returnType;
        this.names = names;
        this.canCreateGetter = canCreateGetter;
        this.parameters = parameters;
        this.offsets = offsets;
        this.lengths = lengths;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExtractMethodFeedback) {
            ExtractMethodFeedback other = (ExtractMethodFeedback)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.returnType, this.returnType) && ObjectUtilities.equals(other.names, this.names) && other.canCreateGetter == this.canCreateGetter && ObjectUtilities.equals(other.parameters, this.parameters) && Arrays.equals(other.offsets, this.offsets) && Arrays.equals(other.lengths, this.lengths);
        }
        return false;
    }

    public static ExtractMethodFeedback fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        String returnType = jsonObject.get("returnType").getAsString();
        List<String> names = JsonUtilities.decodeStringList(jsonObject.get("names").getAsJsonArray());
        boolean canCreateGetter = jsonObject.get("canCreateGetter").getAsBoolean();
        List<RefactoringMethodParameter> parameters = RefactoringMethodParameter.fromJsonArray(jsonObject.get("parameters").getAsJsonArray());
        int[] offsets = JsonUtilities.decodeIntArray(jsonObject.get("offsets").getAsJsonArray());
        int[] lengths = JsonUtilities.decodeIntArray(jsonObject.get("lengths").getAsJsonArray());
        return new ExtractMethodFeedback(offset, length, returnType, names, canCreateGetter, parameters, offsets, lengths);
    }

    public static List<ExtractMethodFeedback> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ExtractMethodFeedback> list = new ArrayList<ExtractMethodFeedback>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ExtractMethodFeedback.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean canCreateGetter() {
        return this.canCreateGetter;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public List<RefactoringMethodParameter> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.returnType);
        builder.append(this.names);
        builder.append(this.canCreateGetter);
        builder.append(this.parameters);
        builder.append(this.offsets);
        builder.append(this.lengths);
        return builder.toHashCode();
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("returnType", this.returnType);
        JsonArray jsonArrayNames = new JsonArray();
        for (String string : this.names) {
            jsonArrayNames.add((JsonElement)new JsonPrimitive(string));
        }
        jsonObject.add("names", (JsonElement)jsonArrayNames);
        jsonObject.addProperty("canCreateGetter", Boolean.valueOf(this.canCreateGetter));
        JsonArray jsonArrayParameters = new JsonArray();
        for (RefactoringMethodParameter refactoringMethodParameter : this.parameters) {
            jsonArrayParameters.add((JsonElement)refactoringMethodParameter.toJson());
        }
        jsonObject.add("parameters", (JsonElement)jsonArrayParameters);
        JsonArray jsonArray = new JsonArray();
        for (int elt : this.offsets) {
            jsonArray.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("offsets", (JsonElement)jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (int elt : this.lengths) {
            jsonArray2.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("lengths", (JsonElement)jsonArray2);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("returnType=");
        builder.append(this.returnType + ", ");
        builder.append("names=");
        builder.append(StringUtils.join(this.names, (String)", ") + ", ");
        builder.append("canCreateGetter=");
        builder.append(this.canCreateGetter + ", ");
        builder.append("parameters=");
        builder.append(StringUtils.join(this.parameters, (String)", ") + ", ");
        builder.append("offsets=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.offsets, ", "}) + ", ");
        builder.append("lengths=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.lengths, ", "}));
        builder.append("]");
        return builder.toString();
    }
}

