/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Location;

public class Element {
    public static final Element[] EMPTY_ARRAY = new Element[0];
    public static final List<Element> EMPTY_LIST = Lists.newArrayList();
    private static final int ABSTRACT = 1;
    private static final int CONST = 2;
    private static final int FINAL = 4;
    private static final int TOP_LEVEL_STATIC = 8;
    private static final int PRIVATE = 16;
    private static final int DEPRECATED = 32;
    private final String kind;
    private final String name;
    private final Location location;
    private final int flags;
    private final String parameters;
    private final String returnType;
    private final String typeParameters;

    public Element(String kind, String name, Location location, int flags, String parameters, String returnType, String typeParameters) {
        this.kind = kind;
        this.name = name;
        this.location = location;
        this.flags = flags;
        this.parameters = parameters;
        this.returnType = returnType;
        this.typeParameters = typeParameters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element other = (Element)obj;
            return ObjectUtilities.equals(other.kind, this.kind) && ObjectUtilities.equals(other.name, this.name) && ObjectUtilities.equals(other.location, this.location) && other.flags == this.flags && ObjectUtilities.equals(other.parameters, this.parameters) && ObjectUtilities.equals(other.returnType, this.returnType) && ObjectUtilities.equals(other.typeParameters, this.typeParameters);
        }
        return false;
    }

    public static Element fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        String name = jsonObject.get("name").getAsString();
        Location location = jsonObject.get("location") == null ? null : Location.fromJson(jsonObject.get("location").getAsJsonObject());
        int flags = jsonObject.get("flags").getAsInt();
        String parameters = jsonObject.get("parameters") == null ? null : jsonObject.get("parameters").getAsString();
        String returnType = jsonObject.get("returnType") == null ? null : jsonObject.get("returnType").getAsString();
        String typeParameters = jsonObject.get("typeParameters") == null ? null : jsonObject.get("typeParameters").getAsString();
        return new Element(kind, name, location, flags, parameters, returnType, typeParameters);
    }

    public static List<Element> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<Element> list = new ArrayList<Element>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(Element.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getKind() {
        return this.kind;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append((Object)this.name);
        builder.append((Object)this.location);
        builder.append(this.flags);
        builder.append((Object)this.parameters);
        builder.append((Object)this.returnType);
        builder.append((Object)this.typeParameters);
        return builder.toHashCode();
    }

    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    public boolean isConst() {
        return (this.flags & 2) != 0;
    }

    public boolean isDeprecated() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.flags & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isTopLevelOrStatic() {
        return (this.flags & 8) != 0;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("name", this.name);
        if (this.location != null) {
            jsonObject.add("location", (JsonElement)this.location.toJson());
        }
        jsonObject.addProperty("flags", (Number)this.flags);
        if (this.parameters != null) {
            jsonObject.addProperty("parameters", this.parameters);
        }
        if (this.returnType != null) {
            jsonObject.addProperty("returnType", this.returnType);
        }
        if (this.typeParameters != null) {
            jsonObject.addProperty("typeParameters", this.typeParameters);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("location=");
        builder.append(this.location + ", ");
        builder.append("flags=");
        builder.append(this.flags + ", ");
        builder.append("parameters=");
        builder.append(this.parameters + ", ");
        builder.append("returnType=");
        builder.append(this.returnType + ", ");
        builder.append("typeParameters=");
        builder.append(this.typeParameters);
        builder.append("]");
        return builder.toString();
    }
}

