/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;

public class CompletionSuggestion {
    public static final CompletionSuggestion[] EMPTY_ARRAY = new CompletionSuggestion[0];
    public static final List<CompletionSuggestion> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final int relevance;
    private final String completion;
    private final String displayText;
    private final int selectionOffset;
    private final int selectionLength;
    private final boolean isDeprecated;
    private final boolean isPotential;
    private final String docSummary;
    private final String docComplete;
    private final String declaringType;
    private final String defaultArgumentListString;
    private final int[] defaultArgumentListTextRanges;
    private final Element element;
    private final String returnType;
    private final List<String> parameterNames;
    private final List<String> parameterTypes;
    private final Integer requiredParameterCount;
    private final Boolean hasNamedParameters;
    private final String parameterName;
    private final String parameterType;
    private final String importUri;

    public CompletionSuggestion(String kind, int relevance, String completion, String displayText, int selectionOffset, int selectionLength, boolean isDeprecated, boolean isPotential, String docSummary, String docComplete, String declaringType, String defaultArgumentListString, int[] defaultArgumentListTextRanges, Element element, String returnType, List<String> parameterNames, List<String> parameterTypes, Integer requiredParameterCount, Boolean hasNamedParameters, String parameterName, String parameterType, String importUri) {
        this.kind = kind;
        this.relevance = relevance;
        this.completion = completion;
        this.displayText = displayText;
        this.selectionOffset = selectionOffset;
        this.selectionLength = selectionLength;
        this.isDeprecated = isDeprecated;
        this.isPotential = isPotential;
        this.docSummary = docSummary;
        this.docComplete = docComplete;
        this.declaringType = declaringType;
        this.defaultArgumentListString = defaultArgumentListString;
        this.defaultArgumentListTextRanges = defaultArgumentListTextRanges;
        this.element = element;
        this.returnType = returnType;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        this.requiredParameterCount = requiredParameterCount;
        this.hasNamedParameters = hasNamedParameters;
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.importUri = importUri;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompletionSuggestion) {
            CompletionSuggestion other = (CompletionSuggestion)obj;
            return ObjectUtilities.equals(other.kind, this.kind) && other.relevance == this.relevance && ObjectUtilities.equals(other.completion, this.completion) && ObjectUtilities.equals(other.displayText, this.displayText) && other.selectionOffset == this.selectionOffset && other.selectionLength == this.selectionLength && other.isDeprecated == this.isDeprecated && other.isPotential == this.isPotential && ObjectUtilities.equals(other.docSummary, this.docSummary) && ObjectUtilities.equals(other.docComplete, this.docComplete) && ObjectUtilities.equals(other.declaringType, this.declaringType) && ObjectUtilities.equals(other.defaultArgumentListString, this.defaultArgumentListString) && Arrays.equals(other.defaultArgumentListTextRanges, this.defaultArgumentListTextRanges) && ObjectUtilities.equals(other.element, this.element) && ObjectUtilities.equals(other.returnType, this.returnType) && ObjectUtilities.equals(other.parameterNames, this.parameterNames) && ObjectUtilities.equals(other.parameterTypes, this.parameterTypes) && ObjectUtilities.equals(other.requiredParameterCount, this.requiredParameterCount) && ObjectUtilities.equals(other.hasNamedParameters, this.hasNamedParameters) && ObjectUtilities.equals(other.parameterName, this.parameterName) && ObjectUtilities.equals(other.parameterType, this.parameterType) && ObjectUtilities.equals(other.importUri, this.importUri);
        }
        return false;
    }

    public static CompletionSuggestion fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        int relevance = jsonObject.get("relevance").getAsInt();
        String completion = jsonObject.get("completion").getAsString();
        String displayText = jsonObject.get("displayText") == null ? null : jsonObject.get("displayText").getAsString();
        int selectionOffset = jsonObject.get("selectionOffset").getAsInt();
        int selectionLength = jsonObject.get("selectionLength").getAsInt();
        boolean isDeprecated = jsonObject.get("isDeprecated").getAsBoolean();
        boolean isPotential = jsonObject.get("isPotential").getAsBoolean();
        String docSummary = jsonObject.get("docSummary") == null ? null : jsonObject.get("docSummary").getAsString();
        String docComplete = jsonObject.get("docComplete") == null ? null : jsonObject.get("docComplete").getAsString();
        String declaringType = jsonObject.get("declaringType") == null ? null : jsonObject.get("declaringType").getAsString();
        String defaultArgumentListString = jsonObject.get("defaultArgumentListString") == null ? null : jsonObject.get("defaultArgumentListString").getAsString();
        int[] defaultArgumentListTextRanges = jsonObject.get("defaultArgumentListTextRanges") == null ? null : JsonUtilities.decodeIntArray(jsonObject.get("defaultArgumentListTextRanges").getAsJsonArray());
        Element element = jsonObject.get("element") == null ? null : Element.fromJson(jsonObject.get("element").getAsJsonObject());
        String returnType = jsonObject.get("returnType") == null ? null : jsonObject.get("returnType").getAsString();
        List<String> parameterNames = jsonObject.get("parameterNames") == null ? null : JsonUtilities.decodeStringList(jsonObject.get("parameterNames").getAsJsonArray());
        List<String> parameterTypes = jsonObject.get("parameterTypes") == null ? null : JsonUtilities.decodeStringList(jsonObject.get("parameterTypes").getAsJsonArray());
        Integer requiredParameterCount = jsonObject.get("requiredParameterCount") == null ? null : Integer.valueOf(jsonObject.get("requiredParameterCount").getAsInt());
        Boolean hasNamedParameters = jsonObject.get("hasNamedParameters") == null ? null : Boolean.valueOf(jsonObject.get("hasNamedParameters").getAsBoolean());
        String parameterName = jsonObject.get("parameterName") == null ? null : jsonObject.get("parameterName").getAsString();
        String parameterType = jsonObject.get("parameterType") == null ? null : jsonObject.get("parameterType").getAsString();
        String importUri = jsonObject.get("importUri") == null ? null : jsonObject.get("importUri").getAsString();
        return new CompletionSuggestion(kind, relevance, completion, displayText, selectionOffset, selectionLength, isDeprecated, isPotential, docSummary, docComplete, declaringType, defaultArgumentListString, defaultArgumentListTextRanges, element, returnType, parameterNames, parameterTypes, requiredParameterCount, hasNamedParameters, parameterName, parameterType, importUri);
    }

    public static List<CompletionSuggestion> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<CompletionSuggestion> list = new ArrayList<CompletionSuggestion>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(CompletionSuggestion.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getCompletion() {
        return this.completion;
    }

    public String getDeclaringType() {
        return this.declaringType;
    }

    public String getDefaultArgumentListString() {
        return this.defaultArgumentListString;
    }

    public int[] getDefaultArgumentListTextRanges() {
        return this.defaultArgumentListTextRanges;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getDocComplete() {
        return this.docComplete;
    }

    public String getDocSummary() {
        return this.docSummary;
    }

    public Element getElement() {
        return this.element;
    }

    public Boolean getHasNamedParameters() {
        return this.hasNamedParameters;
    }

    public String getImportUri() {
        return this.importUri;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isPotential() {
        return this.isPotential;
    }

    public String getKind() {
        return this.kind;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public Integer getRequiredParameterCount() {
        return this.requiredParameterCount;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public int getSelectionOffset() {
        return this.selectionOffset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append(this.relevance);
        builder.append((Object)this.completion);
        builder.append((Object)this.displayText);
        builder.append(this.selectionOffset);
        builder.append(this.selectionLength);
        builder.append(this.isDeprecated);
        builder.append(this.isPotential);
        builder.append((Object)this.docSummary);
        builder.append((Object)this.docComplete);
        builder.append((Object)this.declaringType);
        builder.append((Object)this.defaultArgumentListString);
        builder.append(this.defaultArgumentListTextRanges);
        builder.append((Object)this.element);
        builder.append((Object)this.returnType);
        builder.append(this.parameterNames);
        builder.append(this.parameterTypes);
        builder.append((Object)this.requiredParameterCount);
        builder.append((Object)this.hasNamedParameters);
        builder.append((Object)this.parameterName);
        builder.append((Object)this.parameterType);
        builder.append((Object)this.importUri);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("relevance", (Number)this.relevance);
        jsonObject.addProperty("completion", this.completion);
        if (this.displayText != null) {
            jsonObject.addProperty("displayText", this.displayText);
        }
        jsonObject.addProperty("selectionOffset", (Number)this.selectionOffset);
        jsonObject.addProperty("selectionLength", (Number)this.selectionLength);
        jsonObject.addProperty("isDeprecated", Boolean.valueOf(this.isDeprecated));
        jsonObject.addProperty("isPotential", Boolean.valueOf(this.isPotential));
        if (this.docSummary != null) {
            jsonObject.addProperty("docSummary", this.docSummary);
        }
        if (this.docComplete != null) {
            jsonObject.addProperty("docComplete", this.docComplete);
        }
        if (this.declaringType != null) {
            jsonObject.addProperty("declaringType", this.declaringType);
        }
        if (this.defaultArgumentListString != null) {
            jsonObject.addProperty("defaultArgumentListString", this.defaultArgumentListString);
        }
        if (this.defaultArgumentListTextRanges != null) {
            JsonArray jsonArrayDefaultArgumentListTextRanges = new JsonArray();
            for (int elt : this.defaultArgumentListTextRanges) {
                jsonArrayDefaultArgumentListTextRanges.add((JsonElement)new JsonPrimitive((Number)elt));
            }
            jsonObject.add("defaultArgumentListTextRanges", (JsonElement)jsonArrayDefaultArgumentListTextRanges);
        }
        if (this.element != null) {
            jsonObject.add("element", (JsonElement)this.element.toJson());
        }
        if (this.returnType != null) {
            jsonObject.addProperty("returnType", this.returnType);
        }
        if (this.parameterNames != null) {
            JsonArray jsonArrayParameterNames = new JsonArray();
            Object object = this.parameterNames.iterator();
            while (object.hasNext()) {
                String elt = (String)object.next();
                jsonArrayParameterNames.add((JsonElement)new JsonPrimitive(elt));
            }
            jsonObject.add("parameterNames", (JsonElement)jsonArrayParameterNames);
        }
        if (this.parameterTypes != null) {
            JsonArray jsonArrayParameterTypes = new JsonArray();
            for (String elt : this.parameterTypes) {
                jsonArrayParameterTypes.add((JsonElement)new JsonPrimitive(elt));
            }
            jsonObject.add("parameterTypes", (JsonElement)jsonArrayParameterTypes);
        }
        if (this.requiredParameterCount != null) {
            jsonObject.addProperty("requiredParameterCount", (Number)this.requiredParameterCount);
        }
        if (this.hasNamedParameters != null) {
            jsonObject.addProperty("hasNamedParameters", this.hasNamedParameters);
        }
        if (this.parameterName != null) {
            jsonObject.addProperty("parameterName", this.parameterName);
        }
        if (this.parameterType != null) {
            jsonObject.addProperty("parameterType", this.parameterType);
        }
        if (this.importUri != null) {
            jsonObject.addProperty("importUri", this.importUri);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("relevance=");
        builder.append(this.relevance + ", ");
        builder.append("completion=");
        builder.append(this.completion + ", ");
        builder.append("displayText=");
        builder.append(this.displayText + ", ");
        builder.append("selectionOffset=");
        builder.append(this.selectionOffset + ", ");
        builder.append("selectionLength=");
        builder.append(this.selectionLength + ", ");
        builder.append("isDeprecated=");
        builder.append(this.isDeprecated + ", ");
        builder.append("isPotential=");
        builder.append(this.isPotential + ", ");
        builder.append("docSummary=");
        builder.append(this.docSummary + ", ");
        builder.append("docComplete=");
        builder.append(this.docComplete + ", ");
        builder.append("declaringType=");
        builder.append(this.declaringType + ", ");
        builder.append("defaultArgumentListString=");
        builder.append(this.defaultArgumentListString + ", ");
        builder.append("defaultArgumentListTextRanges=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.defaultArgumentListTextRanges, ", "}) + ", ");
        builder.append("element=");
        builder.append(this.element + ", ");
        builder.append("returnType=");
        builder.append(this.returnType + ", ");
        builder.append("parameterNames=");
        builder.append(StringUtils.join(this.parameterNames, (String)", ") + ", ");
        builder.append("parameterTypes=");
        builder.append(StringUtils.join(this.parameterTypes, (String)", ") + ", ");
        builder.append("requiredParameterCount=");
        builder.append(this.requiredParameterCount + ", ");
        builder.append("hasNamedParameters=");
        builder.append(this.hasNamedParameters + ", ");
        builder.append("parameterName=");
        builder.append(this.parameterName + ", ");
        builder.append("parameterType=");
        builder.append(this.parameterType + ", ");
        builder.append("importUri=");
        builder.append(this.importUri);
        builder.append("]");
        return builder.toString();
    }
}

