/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ClosingLabel {
    public static final ClosingLabel[] EMPTY_ARRAY = new ClosingLabel[0];
    public static final List<ClosingLabel> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final String label;

    public ClosingLabel(int offset, int length, String label) {
        this.offset = offset;
        this.length = length;
        this.label = label;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClosingLabel) {
            ClosingLabel other = (ClosingLabel)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.label, this.label);
        }
        return false;
    }

    public static ClosingLabel fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        String label = jsonObject.get("label").getAsString();
        return new ClosingLabel(offset, length, label);
    }

    public static List<ClosingLabel> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ClosingLabel> list = new ArrayList<ClosingLabel>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ClosingLabel.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.label);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("label", this.label);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("label=");
        builder.append(this.label);
        builder.append("]");
        return builder.toString();
    }
}

