/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AnalysisOptions {
    public static final AnalysisOptions[] EMPTY_ARRAY = new AnalysisOptions[0];
    public static final List<AnalysisOptions> EMPTY_LIST = Lists.newArrayList();
    private final Boolean enableAsync;
    private final Boolean enableDeferredLoading;
    private final Boolean enableEnums;
    private final Boolean enableNullAwareOperators;
    private final Boolean enableSuperMixins;
    private final Boolean generateDart2jsHints;
    private final Boolean generateHints;
    private final Boolean generateLints;

    public AnalysisOptions(Boolean enableAsync, Boolean enableDeferredLoading, Boolean enableEnums, Boolean enableNullAwareOperators, Boolean enableSuperMixins, Boolean generateDart2jsHints, Boolean generateHints, Boolean generateLints) {
        this.enableAsync = enableAsync;
        this.enableDeferredLoading = enableDeferredLoading;
        this.enableEnums = enableEnums;
        this.enableNullAwareOperators = enableNullAwareOperators;
        this.enableSuperMixins = enableSuperMixins;
        this.generateDart2jsHints = generateDart2jsHints;
        this.generateHints = generateHints;
        this.generateLints = generateLints;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalysisOptions) {
            AnalysisOptions other = (AnalysisOptions)obj;
            return ObjectUtilities.equals(other.enableAsync, this.enableAsync) && ObjectUtilities.equals(other.enableDeferredLoading, this.enableDeferredLoading) && ObjectUtilities.equals(other.enableEnums, this.enableEnums) && ObjectUtilities.equals(other.enableNullAwareOperators, this.enableNullAwareOperators) && ObjectUtilities.equals(other.enableSuperMixins, this.enableSuperMixins) && ObjectUtilities.equals(other.generateDart2jsHints, this.generateDart2jsHints) && ObjectUtilities.equals(other.generateHints, this.generateHints) && ObjectUtilities.equals(other.generateLints, this.generateLints);
        }
        return false;
    }

    public static AnalysisOptions fromJson(JsonObject jsonObject) {
        Boolean enableAsync = jsonObject.get("enableAsync") == null ? null : Boolean.valueOf(jsonObject.get("enableAsync").getAsBoolean());
        Boolean enableDeferredLoading = jsonObject.get("enableDeferredLoading") == null ? null : Boolean.valueOf(jsonObject.get("enableDeferredLoading").getAsBoolean());
        Boolean enableEnums = jsonObject.get("enableEnums") == null ? null : Boolean.valueOf(jsonObject.get("enableEnums").getAsBoolean());
        Boolean enableNullAwareOperators = jsonObject.get("enableNullAwareOperators") == null ? null : Boolean.valueOf(jsonObject.get("enableNullAwareOperators").getAsBoolean());
        Boolean enableSuperMixins = jsonObject.get("enableSuperMixins") == null ? null : Boolean.valueOf(jsonObject.get("enableSuperMixins").getAsBoolean());
        Boolean generateDart2jsHints = jsonObject.get("generateDart2jsHints") == null ? null : Boolean.valueOf(jsonObject.get("generateDart2jsHints").getAsBoolean());
        Boolean generateHints = jsonObject.get("generateHints") == null ? null : Boolean.valueOf(jsonObject.get("generateHints").getAsBoolean());
        Boolean generateLints = jsonObject.get("generateLints") == null ? null : Boolean.valueOf(jsonObject.get("generateLints").getAsBoolean());
        return new AnalysisOptions(enableAsync, enableDeferredLoading, enableEnums, enableNullAwareOperators, enableSuperMixins, generateDart2jsHints, generateHints, generateLints);
    }

    public static List<AnalysisOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<AnalysisOptions> list = new ArrayList<AnalysisOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(AnalysisOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public Boolean getEnableAsync() {
        return this.enableAsync;
    }

    public Boolean getEnableDeferredLoading() {
        return this.enableDeferredLoading;
    }

    public Boolean getEnableEnums() {
        return this.enableEnums;
    }

    public Boolean getEnableNullAwareOperators() {
        return this.enableNullAwareOperators;
    }

    public Boolean getEnableSuperMixins() {
        return this.enableSuperMixins;
    }

    public Boolean getGenerateDart2jsHints() {
        return this.generateDart2jsHints;
    }

    public Boolean getGenerateHints() {
        return this.generateHints;
    }

    public Boolean getGenerateLints() {
        return this.generateLints;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.enableAsync);
        builder.append((Object)this.enableDeferredLoading);
        builder.append((Object)this.enableEnums);
        builder.append((Object)this.enableNullAwareOperators);
        builder.append((Object)this.enableSuperMixins);
        builder.append((Object)this.generateDart2jsHints);
        builder.append((Object)this.generateHints);
        builder.append((Object)this.generateLints);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.enableAsync != null) {
            jsonObject.addProperty("enableAsync", this.enableAsync);
        }
        if (this.enableDeferredLoading != null) {
            jsonObject.addProperty("enableDeferredLoading", this.enableDeferredLoading);
        }
        if (this.enableEnums != null) {
            jsonObject.addProperty("enableEnums", this.enableEnums);
        }
        if (this.enableNullAwareOperators != null) {
            jsonObject.addProperty("enableNullAwareOperators", this.enableNullAwareOperators);
        }
        if (this.enableSuperMixins != null) {
            jsonObject.addProperty("enableSuperMixins", this.enableSuperMixins);
        }
        if (this.generateDart2jsHints != null) {
            jsonObject.addProperty("generateDart2jsHints", this.generateDart2jsHints);
        }
        if (this.generateHints != null) {
            jsonObject.addProperty("generateHints", this.generateHints);
        }
        if (this.generateLints != null) {
            jsonObject.addProperty("generateLints", this.generateLints);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("enableAsync=");
        builder.append(this.enableAsync + ", ");
        builder.append("enableDeferredLoading=");
        builder.append(this.enableDeferredLoading + ", ");
        builder.append("enableEnums=");
        builder.append(this.enableEnums + ", ");
        builder.append("enableNullAwareOperators=");
        builder.append(this.enableNullAwareOperators + ", ");
        builder.append("enableSuperMixins=");
        builder.append(this.enableSuperMixins + ", ");
        builder.append("generateDart2jsHints=");
        builder.append(this.generateDart2jsHints + ", ");
        builder.append("generateHints=");
        builder.append(this.generateHints + ", ");
        builder.append("generateLints=");
        builder.append(this.generateLints);
        builder.append("]");
        return builder.toString();
    }
}

