/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.lang.dart.DartTokenTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsefulPsiTreeUtil {
    public static ASTNode[] findChildrenRange(ASTNode[] elements, int startOffset, int endOffset) {
        int i = UsefulPsiTreeUtil.findChildIndex(elements, startOffset);
        int j = UsefulPsiTreeUtil.findChildIndex(elements, endOffset);
        i = i == -1 ? 0 : i;
        int n = j = j == -1 ? elements.length : j;
        while (0 < j && j < elements.length && elements[j].getElementType() == TokenType.WHITE_SPACE) {
            --j;
        }
        int to = j;
        if (j < elements.length && elements[j].getElementType() != DartTokenTypes.SEMICOLON) {
            while (j + 1 < elements.length && (elements[j + 1].getElementType() == DartTokenTypes.SEMICOLON || elements[j + 1].getElementType() == TokenType.WHITE_SPACE)) {
                if (elements[++j].getElementType() != DartTokenTypes.SEMICOLON) continue;
                to = j;
            }
        }
        if ((to = Math.min(elements.length, to + 1)) < i) {
            return ASTNode.EMPTY_ARRAY;
        }
        return Arrays.copyOfRange(elements, i, to);
    }

    private static int findChildIndex(ASTNode[] children, int offset) {
        int length = children.length;
        for (int i = 0; i < length; ++i) {
            ASTNode child = children[i];
            if (!child.getTextRange().contains(offset)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isWhitespaceOrComment(PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof PsiComment;
    }

    @Nullable
    public static List<PsiElement> getPathToParentOfType(@Nullable PsiElement element, @NotNull Class<? extends PsiElement> aClass) {
        if (aClass == null) {
            UsefulPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (element != null) {
            result.add(element);
            if (aClass.isInstance(element)) {
                return result;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSiblingSkippingWhiteSpacesAndComments(PsiElement sibling) {
        return UsefulPsiTreeUtil.getSiblingSkippingCondition(sibling, (Function<PsiElement, PsiElement>)((Function)PsiElement::getNextSibling), (Condition<PsiElement>)((Condition)UsefulPsiTreeUtil::isWhitespaceOrComment), true);
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipWhiteSpacesAndComments(@Nullable PsiElement sibling, boolean strictly) {
        return UsefulPsiTreeUtil.getPrevSiblingSkippingCondition(sibling, (Condition<PsiElement>)((Condition)UsefulPsiTreeUtil::isWhitespaceOrComment), strictly);
    }

    @Nullable
    public static ASTNode getPrevSiblingSkipWhiteSpacesAndComments(@Nullable ASTNode sibling) {
        ASTNode result;
        if (sibling == null) {
            return null;
        }
        for (result = sibling.getTreePrev(); result != null && UsefulPsiTreeUtil.isWhitespaceOrComment(result.getPsi()); result = result.getTreePrev()) {
        }
        return result;
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipWhiteSpaces(@Nullable PsiElement sibling, boolean strictly) {
        return UsefulPsiTreeUtil.getPrevSiblingSkippingCondition(sibling, (Condition<PsiElement>)((Condition)element -> element instanceof PsiWhiteSpace), strictly);
    }

    @Nullable
    private static PsiElement getPrevSiblingSkippingCondition(@Nullable PsiElement sibling, Condition<PsiElement> condition, boolean strictly) {
        return UsefulPsiTreeUtil.getSiblingSkippingCondition(sibling, (Function<PsiElement, PsiElement>)((Function)PsiElement::getPrevSibling), condition, strictly);
    }

    @Nullable
    private static PsiElement getSiblingSkippingCondition(@Nullable PsiElement sibling, Function<PsiElement, PsiElement> nextSibling, Condition<PsiElement> condition, boolean strictly) {
        PsiElement result;
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof PsiFile) {
            return sibling;
        }
        PsiElement psiElement = result = strictly ? (PsiElement)nextSibling.fun((Object)sibling) : sibling;
        while (result != null && !(result instanceof PsiFile) && condition.value((Object)result)) {
            result = (PsiElement)nextSibling.fun((Object)result);
        }
        return result;
    }

    public static boolean isAncestor(@NotNull PsiElement element, List<PsiElement> children, boolean strict) {
        if (element == null) {
            UsefulPsiTreeUtil.$$$reportNull$$$0(1);
        }
        for (PsiElement child : children) {
            if (child == null || PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)child, (boolean)strict)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/util/UsefulPsiTreeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathToParentOfType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAncestor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

