/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class PubspecYamlUtil {
    public static final String PUBSPEC_YAML = "pubspec.yaml";
    private static final String NAME = "name";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "dev_dependencies";
    public static final String DEPENDENCY_OVERRIDES = "dependency_overrides";
    public static final String PATH = "path";
    public static final String LIB_DIR_NAME = "lib";
    private static final Key<Pair<Long, Map<String, Object>>> MOD_STAMP_TO_PUBSPEC_NAME = Key.create((String)"MOD_STAMP_TO_PUBSPEC_NAME");

    public static boolean isPubspecFile(@NotNull VirtualFile file) {
        if (file == null) {
            PubspecYamlUtil.$$$reportNull$$$0(0);
        }
        return !file.isDirectory() && file.getName().equals(PUBSPEC_YAML);
    }

    @Nullable
    public static VirtualFile findPubspecYamlFile(@NotNull Project project, @NotNull VirtualFile contextFile) {
        VirtualFile parent;
        if (project == null) {
            PubspecYamlUtil.$$$reportNull$$$0(1);
        }
        if (contextFile == null) {
            PubspecYamlUtil.$$$reportNull$$$0(2);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile current = contextFile;
        VirtualFile virtualFile = parent = contextFile.isDirectory() ? contextFile : contextFile.getParent();
        while (parent != null && (LIB_DIR_NAME.equals(current.getName()) || fileIndex.isInContent(parent))) {
            current = parent;
            VirtualFile file = parent.findChild(PUBSPEC_YAML);
            if (file != null && !file.isDirectory()) {
                return file;
            }
            parent = current.getParent();
        }
        return null;
    }

    @Nullable
    public static String getDartProjectName(@NotNull VirtualFile pubspecYamlFile) {
        Map<String, Object> yamlInfo;
        if (pubspecYamlFile == null) {
            PubspecYamlUtil.$$$reportNull$$$0(3);
        }
        Object name = (yamlInfo = PubspecYamlUtil.getPubspecYamlInfo(pubspecYamlFile)) == null ? null : yamlInfo.get(NAME);
        return name instanceof String ? (String)name : null;
    }

    public static void processInProjectPathPackagesRecursively(@NotNull Project project, @NotNull VirtualFile pubspecYamlFile, @NotNull PairConsumer<String, VirtualFile> pathPackageNameAndDirConsumer) {
        if (project == null) {
            PubspecYamlUtil.$$$reportNull$$$0(4);
        }
        if (pubspecYamlFile == null) {
            PubspecYamlUtil.$$$reportNull$$$0(5);
        }
        if (pathPackageNameAndDirConsumer == null) {
            PubspecYamlUtil.$$$reportNull$$$0(6);
        }
        PubspecYamlUtil.processInProjectPathPackagesRecursively(project, pubspecYamlFile, (Set<VirtualFile>)new THashSet(), pathPackageNameAndDirConsumer);
    }

    private static void processInProjectPathPackagesRecursively(@NotNull Project project, @NotNull VirtualFile pubspecYamlFile, @NotNull Set<VirtualFile> processedPubspecs, @NotNull PairConsumer<String, VirtualFile> pathPackageNameAndDirConsumer) {
        if (project == null) {
            PubspecYamlUtil.$$$reportNull$$$0(7);
        }
        if (pubspecYamlFile == null) {
            PubspecYamlUtil.$$$reportNull$$$0(8);
        }
        if (processedPubspecs == null) {
            PubspecYamlUtil.$$$reportNull$$$0(9);
        }
        if (pathPackageNameAndDirConsumer == null) {
            PubspecYamlUtil.$$$reportNull$$$0(10);
        }
        if (!processedPubspecs.add(pubspecYamlFile)) {
            return;
        }
        VirtualFile baseDir = pubspecYamlFile.getParent();
        Map<String, Object> yamlInfo = PubspecYamlUtil.getPubspecYamlInfo(pubspecYamlFile);
        if (baseDir == null || yamlInfo == null) {
            return;
        }
        PubspecYamlUtil.processYamlDepsRecursively(project, processedPubspecs, pathPackageNameAndDirConsumer, baseDir, yamlInfo.get(DEPENDENCIES));
        PubspecYamlUtil.processYamlDepsRecursively(project, processedPubspecs, pathPackageNameAndDirConsumer, baseDir, yamlInfo.get(DEV_DEPENDENCIES));
        PubspecYamlUtil.processYamlDepsRecursively(project, processedPubspecs, pathPackageNameAndDirConsumer, baseDir, yamlInfo.get(DEPENDENCY_OVERRIDES));
    }

    private static void processYamlDepsRecursively(@NotNull Project project, @NotNull Set<VirtualFile> processedPubspecs, @NotNull PairConsumer<String, VirtualFile> pathPackageNameAndRelPathConsumer, @NotNull VirtualFile baseDir, @Nullable Object yamlDep) {
        if (project == null) {
            PubspecYamlUtil.$$$reportNull$$$0(11);
        }
        if (processedPubspecs == null) {
            PubspecYamlUtil.$$$reportNull$$$0(12);
        }
        if (pathPackageNameAndRelPathConsumer == null) {
            PubspecYamlUtil.$$$reportNull$$$0(13);
        }
        if (baseDir == null) {
            PubspecYamlUtil.$$$reportNull$$$0(14);
        }
        if (!(yamlDep instanceof Map)) {
            return;
        }
        for (Map.Entry packageEntry : ((Map)yamlDep).entrySet()) {
            VirtualFile packageFolder;
            Object pathObj;
            String packageName = (String)packageEntry.getKey();
            Object packageEntryValue = packageEntry.getValue();
            if (!(packageEntryValue instanceof Map) || !((pathObj = ((Map)packageEntryValue).get(PATH)) instanceof String) || (packageFolder = VfsUtilCore.findRelativeFile((String)(pathObj + "/" + LIB_DIR_NAME), (VirtualFile)baseDir)) == null || !packageFolder.isDirectory() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(packageFolder)) continue;
            pathPackageNameAndRelPathConsumer.consume((Object)packageName, (Object)packageFolder);
            VirtualFile otherPubspecYaml = packageFolder.getParent().findChild(PUBSPEC_YAML);
            if (otherPubspecYaml == null || otherPubspecYaml.isDirectory()) continue;
            PubspecYamlUtil.processInProjectPathPackagesRecursively(project, otherPubspecYaml, processedPubspecs, pathPackageNameAndRelPathConsumer);
        }
    }

    @Nullable
    private static Map<String, Object> getPubspecYamlInfo(@NotNull VirtualFile pubspecYamlFile) {
        Long cachedTimestamp;
        if (pubspecYamlFile == null) {
            PubspecYamlUtil.$$$reportNull$$$0(15);
        }
        Pair data = (Pair)pubspecYamlFile.getUserData(MOD_STAMP_TO_PUBSPEC_NAME);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document cachedDocument = documentManager.getCachedDocument(pubspecYamlFile);
        Long currentTimestamp = cachedDocument != null ? cachedDocument.getModificationStamp() : pubspecYamlFile.getModificationCount();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            data = null;
            pubspecYamlFile.putUserData(MOD_STAMP_TO_PUBSPEC_NAME, null);
            try {
                Map<String, Object> pubspecYamlInfo = cachedDocument != null ? PubspecYamlUtil.loadPubspecYamlInfo(cachedDocument.getText()) : PubspecYamlUtil.loadPubspecYamlInfo(VfsUtilCore.loadText((VirtualFile)pubspecYamlFile));
                if (pubspecYamlInfo != null) {
                    data = Pair.create((Object)currentTimestamp, pubspecYamlInfo);
                    pubspecYamlFile.putUserData(MOD_STAMP_TO_PUBSPEC_NAME, (Object)data);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return data == null ? null : (Map)data.second;
    }

    @Nullable
    private static Map<String, Object> loadPubspecYamlInfo(@NotNull String pubspecYamlFileContents) {
        if (pubspecYamlFileContents == null) {
            PubspecYamlUtil.$$$reportNull$$$0(16);
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), new DumperOptions(), new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
                this.addImplicitResolver(new Tag("tag:yaml.org,2002:value"), VALUE, "=");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            }
        });
        try {
            return (Map)yaml.load(pubspecYamlFileContents);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecYamlFile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPackageNameAndDirConsumer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedPubspecs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPackageNameAndRelPathConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecYamlFileContents";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/util/PubspecYamlUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPubspecFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPubspecYamlFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDartProjectName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processInProjectPathPackagesRecursively";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processYamlDepsRecursively";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getPubspecYamlInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPubspecYamlInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

