/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DotPackagesFileUtil {
    public static final String DOT_PACKAGES = ".packages";
    private static final Key<Pair<Long, Map<String, String>>> MOD_STAMP_TO_PACKAGES_MAP = Key.create((String)"MOD_STAMP_TO_PACKAGES_MAP");

    @Nullable
    public static Map<String, String> getPackagesMap(@NotNull VirtualFile dotPackagesFile) {
        Long cachedTimestamp;
        if (dotPackagesFile == null) {
            DotPackagesFileUtil.$$$reportNull$$$0(0);
        }
        Pair data = (Pair)dotPackagesFile.getUserData(MOD_STAMP_TO_PACKAGES_MAP);
        Long currentTimestamp = dotPackagesFile.getModificationCount();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            data = null;
            dotPackagesFile.putUserData(MOD_STAMP_TO_PACKAGES_MAP, null);
            Map<String, String> packagesMap = DotPackagesFileUtil.loadPackagesMap(dotPackagesFile);
            if (packagesMap != null) {
                data = Pair.create((Object)currentTimestamp, packagesMap);
                dotPackagesFile.putUserData(MOD_STAMP_TO_PACKAGES_MAP, (Object)data);
            }
        }
        return data == null ? null : (Map)data.second;
    }

    @Nullable
    private static Map<String, String> loadPackagesMap(@NotNull VirtualFile dotPackagesFile) {
        if (dotPackagesFile == null) {
            DotPackagesFileUtil.$$$reportNull$$$0(1);
        }
        try {
            List lines = ApplicationManager.getApplication().isUnitTestMode() ? StringUtil.split((String)new String(dotPackagesFile.contentsToByteArray(), "UTF-8"), (String)"\n") : FileUtil.loadLines((String)dotPackagesFile.getPath(), (String)"UTF-8");
            THashMap result = new THashMap();
            for (String line : lines) {
                int colonIndex;
                if (line.trim().isEmpty() || line.startsWith("#") || (colonIndex = line.indexOf(58)) <= 0 || colonIndex >= line.length() - 1) continue;
                String packageName = line.substring(0, colonIndex).trim();
                String encodedUri = line.substring(colonIndex + 1).trim();
                String encodedUriWithoutPluses = StringUtil.replace((String)encodedUri, (String)"+", (String)"%2B");
                String uri = URLDecoder.decode(encodedUriWithoutPluses, "UTF-8");
                String packageUri = DotPackagesFileUtil.getAbsolutePackageRootPath(dotPackagesFile.getParent(), uri);
                if (packageName.isEmpty() || packageUri == null) continue;
                result.put(packageName, packageUri);
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static String getAbsolutePackageRootPath(@NotNull VirtualFile baseDir, @NotNull String uri) {
        if (baseDir == null) {
            DotPackagesFileUtil.$$$reportNull$$$0(2);
        }
        if (uri == null) {
            DotPackagesFileUtil.$$$reportNull$$$0(3);
        }
        if (!uri.startsWith("file:/")) return FileUtil.toCanonicalPath((String)(baseDir.getPath() + "/" + uri));
        String pathAfterSlashes = StringUtil.trimEnd((String)StringUtil.trimLeading((String)StringUtil.trimStart((String)uri, (String)"file:/"), (char)'/'), (String)"/");
        if (!SystemInfo.isWindows || ApplicationManager.getApplication().isUnitTestMode()) return "/" + pathAfterSlashes;
        if (pathAfterSlashes.length() <= 2 || !Character.isLetter(pathAfterSlashes.charAt(0)) || ':' != pathAfterSlashes.charAt(1)) return null;
        return pathAfterSlashes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotPackagesFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/util/DotPackagesFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackagesMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackagesMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAbsolutePackageRootPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

