/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.PairConsumer;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryProperties;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartUrlResolverImpl
extends DartUrlResolver {
    @NotNull
    private final Project myProject;
    @Nullable
    private final DartSdk myDartSdk;
    @Nullable
    private final VirtualFile myPubspecYamlFile;
    @NotNull
    private final Map<String, VirtualFile> myLivePackageNameToDirMap;
    @NotNull
    private final Map<String, List<String>> myPackagesMapFromLib;

    public DartUrlResolverImpl(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(1);
        }
        this.myLivePackageNameToDirMap = new THashMap();
        this.myPackagesMapFromLib = new THashMap();
        this.myProject = project;
        this.myDartSdk = DartSdk.getDartSdk(project);
        this.myPubspecYamlFile = PubspecYamlUtil.findPubspecYamlFile(this.myProject, contextFile);
        this.initLivePackageNameToDirMap();
        if (this.myPubspecYamlFile == null) {
            this.initPackagesMapFromLib(contextFile);
        }
    }

    @Override
    @Nullable
    public VirtualFile getPubspecYamlFile() {
        return this.myPubspecYamlFile;
    }

    @Override
    public void processLivePackages(@NotNull PairConsumer<String, VirtualFile> packageNameAndDirConsumer) {
        if (packageNameAndDirConsumer == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(2);
        }
        for (Map.Entry<String, VirtualFile> entry : this.myLivePackageNameToDirMap.entrySet()) {
            packageNameAndDirConsumer.consume((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Override
    public Collection<String> getLivePackageNames() {
        return this.myLivePackageNameToDirMap.keySet();
    }

    @Override
    @Nullable
    public VirtualFile getPackageDirIfNotInOldStylePackagesFolder(@NotNull String packageName, @Nullable String pathRelToPackageDir) {
        VirtualFile dir;
        if (packageName == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(3);
        }
        if ((dir = this.myLivePackageNameToDirMap.get(packageName)) != null) {
            return dir;
        }
        List<String> dirPaths = this.myPackagesMapFromLib.get(packageName);
        if (dirPaths != null) {
            VirtualFile notNullPackageDir = null;
            for (String dirPath : dirPaths) {
                VirtualFile packageDir;
                VirtualFile virtualFile = packageDir = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(dirPath) : LocalFileSystem.getInstance().findFileByPath(dirPath);
                if (notNullPackageDir == null && packageDir != null) {
                    notNullPackageDir = packageDir;
                }
                if (packageDir == null || !StringUtil.isEmpty((String)pathRelToPackageDir) && packageDir.findFileByRelativePath(pathRelToPackageDir) == null) continue;
                return packageDir;
            }
            return notNullPackageDir;
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile findFileByDartUrl(@NotNull String url) {
        if (url == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(4);
        }
        if (url.startsWith("dart:")) {
            return DartUrlResolverImpl.findFileInDartSdkLibFolder(this.myProject, this.myDartSdk, url);
        }
        if (url.startsWith("package:")) {
            VirtualFile packageDir;
            String packageRelPath = url.substring("package:".length());
            int slashIndex = packageRelPath.indexOf(47);
            String packageName = slashIndex > 0 ? packageRelPath.substring(0, slashIndex) : packageRelPath;
            String pathRelToPackageDir = slashIndex > 0 ? packageRelPath.substring(slashIndex + 1) : "";
            VirtualFile virtualFile = packageDir = StringUtil.isEmpty((String)packageName) ? null : this.myLivePackageNameToDirMap.get(packageName);
            if (packageDir != null) {
                return packageDir.findFileByRelativePath(pathRelToPackageDir);
            }
            List<String> packageDirs = this.myPackagesMapFromLib.get(packageName);
            if (packageDirs != null) {
                for (String packageDirPath : packageDirs) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(packageDirPath + "/" + pathRelToPackageDir);
                    if (file == null) continue;
                    return file;
                }
            }
        }
        if (url.startsWith("file:")) {
            String path = StringUtil.trimLeading((String)url.substring("file:".length()), (char)'/');
            return LocalFileSystem.getInstance().findFileByPath(SystemInfo.isWindows ? path : "/" + path);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && url.startsWith("temp:")) {
            return TempFileSystem.getInstance().findFileByPath(url.substring("temp:".length()));
        }
        return null;
    }

    @Override
    @NotNull
    public String getDartUrlForFile(@NotNull VirtualFile file) {
        if (file == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(5);
        }
        String result = null;
        if (this.myDartSdk != null) {
            result = DartUrlResolverImpl.getUrlIfFileFromSdkLib(this.myProject, file, this.myDartSdk);
        }
        if (result != null) {
            String string = result;
            if (string == null) {
                DartUrlResolverImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        result = DartUrlResolverImpl.getUrlIfFileFromLivePackage(file, this.myLivePackageNameToDirMap);
        if (result != null) {
            String string = result;
            if (string == null) {
                DartUrlResolverImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        result = DartUrlResolverImpl.getUrlIfFileFromDartPackagesLib(file, this.myPackagesMapFromLib);
        if (result != null) {
            String string = result;
            if (string == null) {
                DartUrlResolverImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = new File(file.getPath()).toURI().toString();
        if (string == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static String getUrlIfFileFromSdkLib(@NotNull Project project, @NotNull VirtualFile file, @NotNull DartSdk sdk) {
        String sdkLibUri;
        VirtualFile sdkLibFolder;
        if (project == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(12);
        }
        String relativeToSdkLibFolder = (sdkLibFolder = LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib")) == null ? null : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sdkLibFolder, (char)'/');
        String string = sdkLibUri = relativeToSdkLibFolder == null ? null : DartLibraryIndex.getSdkLibUriByRelativePath(project, relativeToSdkLibFolder);
        return sdkLibUri != null ? sdkLibUri : (relativeToSdkLibFolder != null ? "dart:" + relativeToSdkLibFolder : null);
    }

    @Nullable
    private static String getUrlIfFileFromLivePackage(@NotNull VirtualFile file, @NotNull Map<String, VirtualFile> livePackageNameToDirMap) {
        if (file == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(13);
        }
        if (livePackageNameToDirMap == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(14);
        }
        for (Map.Entry<String, VirtualFile> entry : livePackageNameToDirMap.entrySet()) {
            String packageName = entry.getKey();
            VirtualFile packageDir = entry.getValue();
            String relPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)packageDir, (char)'/');
            if (relPath == null) continue;
            return "package:" + packageName + "/" + relPath;
        }
        return null;
    }

    @Nullable
    private static String getUrlIfFileFromDartPackagesLib(@NotNull VirtualFile file, @NotNull Map<String, List<String>> pubListPackageDirsMap) {
        if (file == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(15);
        }
        if (pubListPackageDirsMap == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(16);
        }
        for (Map.Entry<String, List<String>> mapEntry : pubListPackageDirsMap.entrySet()) {
            for (String dirPath : mapEntry.getValue()) {
                if (!file.getPath().startsWith(dirPath + "/")) continue;
                String packageName = mapEntry.getKey();
                return "package:" + packageName + file.getPath().substring(dirPath.length());
            }
        }
        return null;
    }

    private void initLivePackageNameToDirMap() {
        VirtualFile baseDir;
        VirtualFile virtualFile = baseDir = this.myPubspecYamlFile == null ? null : this.myPubspecYamlFile.getParent();
        if (this.myPubspecYamlFile == null || baseDir == null) {
            return;
        }
        VirtualFile dotPackagesFile = baseDir.findChild(".packages");
        if (dotPackagesFile != null && !dotPackagesFile.isDirectory()) {
            Map<String, String> packagesMap = DotPackagesFileUtil.getPackagesMap(dotPackagesFile);
            if (packagesMap != null) {
                for (Map.Entry<String, String> entry : packagesMap.entrySet()) {
                    String packageName = entry.getKey();
                    String packagePath = entry.getValue();
                    VirtualFile packageDir = this.myPubspecYamlFile.getFileSystem().findFileByPath(packagePath);
                    if (packageDir == null) continue;
                    this.myLivePackageNameToDirMap.put(packageName, packageDir);
                }
            }
        } else {
            String name = PubspecYamlUtil.getDartProjectName(this.myPubspecYamlFile);
            VirtualFile libFolder = baseDir.findChild("lib");
            if (name != null && libFolder != null && libFolder.isDirectory()) {
                this.myLivePackageNameToDirMap.put(name, libFolder);
            }
            PubspecYamlUtil.processInProjectPathPackagesRecursively(this.myProject, this.myPubspecYamlFile, (PairConsumer<String, VirtualFile>)((PairConsumer)this.myLivePackageNameToDirMap::put));
        }
    }

    private void initPackagesMapFromLib(@NotNull VirtualFile contextFile) {
        Module module;
        if (contextFile == null) {
            DartUrlResolverImpl.$$$reportNull$$$0(17);
        }
        List orderEntries = (module = ModuleUtilCore.findModuleForFile((VirtualFile)contextFile, (Project)this.myProject)) != null ? Arrays.asList(ModuleRootManager.getInstance((Module)module).getOrderEntries()) : ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getOrderEntriesForFile(contextFile);
        for (OrderEntry orderEntry : orderEntries) {
            LibraryEx library;
            LibraryProperties properties;
            if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName()) || !((properties = (library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary()) == null ? null : library.getProperties()) instanceof DartPackagesLibraryProperties)) continue;
            for (Map.Entry<String, List<String>> entry : ((DartPackagesLibraryProperties)properties).getPackageNameToDirsMap().entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                this.myPackagesMapFromLib.put(entry.getKey(), entry.getValue());
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameAndDirConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartUrlResolverImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "livePackageNameToDirMap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubListPackageDirsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartUrlResolverImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDartUrlForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processLivePackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDirIfNotInOldStylePackagesFolder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileByDartUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDartUrlForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUrlIfFileFromSdkLib";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUrlIfFileFromLivePackage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getUrlIfFileFromDartPackagesLib";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initPackagesMapFromLib";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

