/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolverImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartUrlResolver {
    public static final String DART_SCHEME = "dart";
    public static final String DART_PREFIX = "dart:";
    public static final String PACKAGE_SCHEME = "package";
    public static final String PACKAGE_PREFIX = "package:";
    public static final String FILE_SCHEME = "file";
    public static final String FILE_PREFIX = "file:";
    public static final String TEMP_SCHEME = "temp";
    public static final String TEMP_PREFIX = "temp:";
    public static final String PACKAGES_FOLDER_NAME = "packages";
    public static final String DART_CORE_URI = "dart:core";

    @NotNull
    public static DartUrlResolver getInstance(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            DartUrlResolver.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            DartUrlResolver.$$$reportNull$$$0(1);
        }
        DartUrlResolverImpl dartUrlResolverImpl = new DartUrlResolverImpl(project, contextFile);
        if (dartUrlResolverImpl == null) {
            DartUrlResolver.$$$reportNull$$$0(2);
        }
        return dartUrlResolverImpl;
    }

    @Nullable
    public abstract VirtualFile getPubspecYamlFile();

    public abstract void processLivePackages(@NotNull PairConsumer<String, VirtualFile> var1);

    public abstract Collection<String> getLivePackageNames();

    @Nullable
    public abstract VirtualFile getPackageDirIfNotInOldStylePackagesFolder(@NotNull String var1, @Nullable String var2);

    @Nullable
    public abstract VirtualFile findFileByDartUrl(@NotNull String var1);

    @Nullable
    public static VirtualFile findFileInDartSdkLibFolder(@NotNull Project project, @Nullable DartSdk dartSdk, @Nullable String dartUri) {
        if (project == null) {
            DartUrlResolver.$$$reportNull$$$0(3);
        }
        if (dartSdk == null || dartUri == null || !dartUri.startsWith(DART_PREFIX)) {
            return null;
        }
        int firstSlashIndex = dartUri.indexOf(47);
        if (firstSlashIndex < 0) {
            return DartLibraryIndex.getSdkLibByUri(project, dartUri);
        }
        String mainLibUri = dartUri.substring(0, firstSlashIndex);
        VirtualFile mainLibFile = DartLibraryIndex.getSdkLibByUri(project, mainLibUri);
        if (mainLibFile != null) {
            String partRelPath = dartUri.substring(firstSlashIndex + 1);
            VirtualFile partFile = mainLibFile.getParent().findFileByRelativePath(partRelPath);
            if (partFile != null) {
                return partFile;
            }
        }
        String sdkLibRelPath = dartUri.substring(DART_PREFIX.length());
        String path = dartSdk.getHomePath() + "/lib/" + sdkLibRelPath;
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    public abstract String getDartUrlForFile(@NotNull VirtualFile var1);

    public boolean mayNeedDynamicUpdate() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartUrlResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartUrlResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileInDartSdkLibFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

