/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartExpressionList;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.resolve.ComponentNameScopeProcessor;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRefactoringUtil {
    public static Set<String> collectUsedNames(PsiElement context) {
        return new THashSet((Collection)ContainerUtil.map(DartRefactoringUtil.collectUsedComponents(context), NavigationItem::getName));
    }

    public static Set<DartComponentName> collectUsedComponents(PsiElement context) {
        THashSet usedComponentNames = new THashSet();
        PsiTreeUtil.treeWalkUp((PsiScopeProcessor)new ComponentNameScopeProcessor((Set<DartComponentName>)usedComponentNames), (PsiElement)context, null, (ResolveState)ResolveState.initial());
        return usedComponentNames;
    }

    @Nullable
    public static DartExpression getSelectedExpression(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent;
        if (project == null) {
            DartRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DartRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (element1 == null) {
            DartRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DartRefactoringUtil.$$$reportNull$$$0(3);
        }
        if ((parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) == null) {
            return null;
        }
        if (parent instanceof DartExpression) {
            return (DartExpression)parent;
        }
        return (DartExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, DartExpression.class);
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            DartRefactoringUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DartRefactoringUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        context.acceptChildren((PsiElementVisitor)new DartRecursiveVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DartComponentType.typeOf(element) == DartComponentType.PARAMETER) {
                    return;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    occurrences.add(element);
                    return;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartRefactoringUtil$1", "visitElement"));
            }
        });
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            DartRefactoringUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement commonParent;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 != null && element2 != null && (commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) instanceof DartExpression) {
            PsiElement[] psiElementArray = new PsiElement[]{commonParent};
            if (psiElementArray == null) {
                DartRefactoringUtil.$$$reportNull$$$0(7);
            }
            return psiElementArray;
        }
        DartStatements statements = (DartStatements)PsiTreeUtil.getParentOfType((PsiElement)element1, DartStatements.class);
        if (statements == null || element2 == null || !PsiTreeUtil.isAncestor((PsiElement)statements, (PsiElement)element2, (boolean)true)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                DartRefactoringUtil.$$$reportNull$$$0(8);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Object[] astResult = UsefulPsiTreeUtil.findChildrenRange(statements.getNode().getChildren(null), startOffset, endOffset);
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])astResult, PsiElement.class, ASTNode::getPsi);
        if (psiElementArray == null) {
            DartRefactoringUtil.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @Nullable
    public static DartExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        DartExpression expression;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((expression = (DartExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, DartExpression.class)) == null || expression.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        if (expression instanceof DartReference && expression.getParent() instanceof DartCallExpression) {
            return null;
        }
        return expression;
    }

    @NotNull
    public static PsiElement[] findListExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        DartExpression expression;
        if (file == null) {
            DartRefactoringUtil.$$$reportNull$$$0(10);
        }
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((expression = (DartExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, DartExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                DartRefactoringUtil.$$$reportNull$$$0(11);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (expression.getTextRange().getEndOffset() != endOffset) {
            element2 = file.findElementAt(endOffset - 1);
            if (element2 != null && DartRefactoringUtil.isComma(element2)) {
                PsiElement prev = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(element2, true);
                if (prev instanceof DartExpressionList) {
                    prev = prev.getLastChild();
                } else if (prev instanceof DartNamedArgument && prev == expression.getParent()) {
                    PsiElement[] psiElementArray = new PsiElement[]{prev, element2};
                    if (psiElementArray == null) {
                        DartRefactoringUtil.$$$reportNull$$$0(12);
                    }
                    return psiElementArray;
                }
                if (prev == expression) {
                    PsiElement[] psiElementArray = new PsiElement[]{expression, element2};
                    if (psiElementArray == null) {
                        DartRefactoringUtil.$$$reportNull$$$0(13);
                    }
                    return psiElementArray;
                }
                if (PsiElement.EMPTY_ARRAY == null) {
                    DartRefactoringUtil.$$$reportNull$$$0(14);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                DartRefactoringUtil.$$$reportNull$$$0(15);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = new PsiElement[]{expression};
        if (psiElementArray == null) {
            DartRefactoringUtil.$$$reportNull$$$0(16);
        }
        return psiElementArray;
    }

    public static boolean isRightBracket(@NotNull PsiElement element) {
        if (element == null) {
            DartRefactoringUtil.$$$reportNull$$$0(17);
        }
        return element.getNode().getElementType() == DartTokenTypes.RBRACKET;
    }

    public static boolean isRightParen(@NotNull PsiElement element) {
        if (element == null) {
            DartRefactoringUtil.$$$reportNull$$$0(18);
        }
        return element.getNode().getElementType() == DartTokenTypes.RPAREN;
    }

    public static boolean isComma(@NotNull PsiElement element) {
        if (element == null) {
            DartRefactoringUtil.$$$reportNull$$$0(19);
        }
        return element.getNode().getElementType() == DartTokenTypes.COMMA;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartRefactoringUtil";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartRefactoringUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findListExpressionInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findListExpressionInRange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRightBracket";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRightParen";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isComma";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

