/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDoWhileStatement;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFieldFormalParameter;
import com.jetbrains.lang.dart.psi.DartForStatement;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartFunctionFormalParameter;
import com.jetbrains.lang.dart.psi.DartIfStatement;
import com.jetbrains.lang.dart.psi.DartLabel;
import com.jetbrains.lang.dart.psi.DartLibraryId;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartMetadata;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartPsiCompositeElement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartSimpleFormalParameter;
import com.jetbrains.lang.dart.psi.DartSimpleType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartUriBasedDirective;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.psi.DartWhileStatement;
import com.jetbrains.lang.dart.psi.IDartBlock;
import com.jetbrains.lang.dart.resolve.DartPsiScopeProcessor;
import com.jetbrains.lang.dart.resolve.DartResolveProcessor;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPsiImplUtil {
    private static final String TRIPLE_APOS = "'''";
    private static final String TRIPLE_QUOTE = "\"\"\"";
    private static final String APOS = "'";
    private static final String QUOTE = "\"";
    private static final String R_TRIPLE_APOS = "r'''";
    private static final String R_TRIPLE_QUOTE = "r\"\"\"";
    private static final String R_APOS = "r'";
    private static final String R_QUOTE = "r\"";
    private static final Key<CachedValue<PsiElement>> DART_TYPE_CACHED_RESOLVE_RESULT_KEY = Key.create((String)"DART_TYPE_CACHED_RESOLVE_RESULT_KEY");

    @NotNull
    public static String getUriString(@NotNull DartUriBasedDirective uriBasedDirective) {
        if (uriBasedDirective == null) {
            DartPsiImplUtil.$$$reportNull$$$0(0);
        }
        String string = (String)DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)uriBasedDirective.getUriElement().getText()).first;
        if (string == null) {
            DartPsiImplUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Pair<String, TextRange> getUriStringAndItsRange(@NotNull DartUriElement uriElement) {
        if (uriElement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(2);
        }
        Pair<String, TextRange> pair = DartPsiImplUtil.getUnquotedDartStringAndItsRange(uriElement.getText());
        if (pair == null) {
            DartPsiImplUtil.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public static Pair<String, TextRange> getUnquotedDartStringAndItsRange(@NotNull String quotedDartString) {
        int endOffset;
        int startOffset;
        if (quotedDartString == null) {
            DartPsiImplUtil.$$$reportNull$$$0(4);
        }
        if (quotedDartString.startsWith(TRIPLE_APOS)) {
            startOffset = TRIPLE_APOS.length();
            endOffset = quotedDartString.endsWith(TRIPLE_APOS) && quotedDartString.length() >= TRIPLE_APOS.length() * 2 ? quotedDartString.length() - TRIPLE_APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(TRIPLE_QUOTE)) {
            startOffset = TRIPLE_QUOTE.length();
            endOffset = quotedDartString.endsWith(TRIPLE_QUOTE) && quotedDartString.length() >= TRIPLE_QUOTE.length() * 2 ? quotedDartString.length() - TRIPLE_QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(APOS)) {
            startOffset = APOS.length();
            endOffset = quotedDartString.endsWith(APOS) && quotedDartString.length() >= APOS.length() * 2 ? quotedDartString.length() - APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(QUOTE)) {
            startOffset = QUOTE.length();
            endOffset = quotedDartString.endsWith(QUOTE) && quotedDartString.length() >= QUOTE.length() * 2 ? quotedDartString.length() - QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_TRIPLE_APOS)) {
            startOffset = R_TRIPLE_APOS.length();
            endOffset = quotedDartString.endsWith(TRIPLE_APOS) && quotedDartString.length() >= R_TRIPLE_APOS.length() + TRIPLE_APOS.length() ? quotedDartString.length() - TRIPLE_APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_TRIPLE_QUOTE)) {
            startOffset = R_TRIPLE_QUOTE.length();
            endOffset = quotedDartString.endsWith(TRIPLE_QUOTE) && quotedDartString.length() >= R_TRIPLE_QUOTE.length() + TRIPLE_QUOTE.length() ? quotedDartString.length() - TRIPLE_QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_APOS)) {
            startOffset = R_APOS.length();
            endOffset = quotedDartString.endsWith(APOS) && quotedDartString.length() >= R_APOS.length() + APOS.length() ? quotedDartString.length() - APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_QUOTE)) {
            startOffset = R_QUOTE.length();
            endOffset = quotedDartString.endsWith(QUOTE) && quotedDartString.length() >= R_QUOTE.length() + QUOTE.length() ? quotedDartString.length() - QUOTE.length() : quotedDartString.length();
        } else {
            startOffset = 0;
            endOffset = quotedDartString.length();
        }
        Pair pair = Pair.create((Object)quotedDartString.substring(startOffset, endOffset), (Object)TextRange.create((int)startOffset, (int)endOffset));
        if (pair == null) {
            DartPsiImplUtil.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    public static String getLibraryName(@NotNull DartPartOfStatement partOfStatement) {
        DartLibraryStatement libraryStatement;
        DartLibraryId libraryId;
        if (partOfStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(6);
        }
        if ((libraryId = partOfStatement.getLibraryId()) != null) {
            String string = libraryId.getText();
            if (string == null) {
                DartPsiImplUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        DartUriElement uriElement = partOfStatement.getUriElement();
        assert (uriElement != null) : "[" + partOfStatement.toString() + "]";
        String uri = (String)uriElement.getUriStringAndItsRange().first;
        VirtualFile file = DartResolveUtil.getRealVirtualFile(partOfStatement.getContainingFile());
        VirtualFile targetFile = file == null ? null : DartResolveUtil.getImportedFile(partOfStatement.getProject(), file, uri);
        PsiFile targetPsiFile = targetFile == null || file.equals(targetFile) ? null : partOfStatement.getManager().findFile(targetFile);
        DartLibraryStatement dartLibraryStatement = libraryStatement = targetPsiFile == null ? null : (DartLibraryStatement)PsiTreeUtil.getChildOfType((PsiElement)targetPsiFile, DartLibraryStatement.class);
        if (libraryStatement != null) {
            String string = libraryStatement.getLibraryNameElement().getName();
            if (string == null) {
                DartPsiImplUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = PathUtil.getFileName((String)uri);
        if (string == null) {
            DartPsiImplUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartLabel element) {
        if (element == null) {
            DartPsiImplUtil.$$$reportNull$$$0(10);
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            DartPsiImplUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartEnumConstantDeclaration element) {
        if (element == null) {
            DartPsiImplUtil.$$$reportNull$$$0(12);
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            DartPsiImplUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartVarDeclarationListPart element) {
        if (element == null) {
            DartPsiImplUtil.$$$reportNull$$$0(14);
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            DartPsiImplUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    public static DartComponentName getComponentName(@NotNull DartNamedConstructorDeclaration element) {
        List<DartComponentName> list;
        if (element == null) {
            DartPsiImplUtil.$$$reportNull$$$0(16);
        }
        return (list = element.getComponentNameList()).size() == 2 ? list.get(1) : null;
    }

    @Nullable
    public static DartComponentName getComponentName(@NotNull DartFactoryConstructorDeclaration element) {
        List<DartComponentName> list;
        if (element == null) {
            DartPsiImplUtil.$$$reportNull$$$0(17);
        }
        return (list = element.getComponentNameList()).size() == 2 ? list.get(1) : (list.size() == 1 ? list.get(0) : null);
    }

    @Nullable
    public static DartReferenceExpression getReferenceExpression(@NotNull DartType dartType) {
        DartSimpleType simpleType;
        if (dartType == null) {
            DartPsiImplUtil.$$$reportNull$$$0(18);
        }
        return (simpleType = dartType.getSimpleType()) == null ? null : simpleType.getReferenceExpression();
    }

    @Nullable
    public static DartTypeArguments getTypeArguments(@NotNull DartType dartType) {
        DartSimpleType simpleType;
        if (dartType == null) {
            DartPsiImplUtil.$$$reportNull$$$0(19);
        }
        return (simpleType = dartType.getSimpleType()) == null ? null : simpleType.getTypeArguments();
    }

    @Nullable
    public static PsiElement resolveReference(@NotNull DartType dartType) {
        CachedValue cachedValue;
        if (dartType == null) {
            DartPsiImplUtil.$$$reportNull$$$0(20);
        }
        if ((cachedValue = (CachedValue)dartType.getUserData(DART_TYPE_CACHED_RESOLVE_RESULT_KEY)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)dartType.getProject()).createCachedValue(() -> {
                if (dartType == null) {
                    DartPsiImplUtil.$$$reportNull$$$0(31);
                }
                return new CachedValueProvider.Result((Object)DartPsiImplUtil.doResolveTypeReference(dartType), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            dartType.putUserData(DART_TYPE_CACHED_RESOLVE_RESULT_KEY, cachedValue);
        }
        return (PsiElement)cachedValue.getValue();
    }

    private static PsiElement doResolveTypeReference(DartType dartType) {
        DartReferenceExpression expression = dartType.getReferenceExpression();
        if (expression == null) {
            return null;
        }
        String typeName = expression.getText();
        if (typeName.indexOf(46) != -1) {
            return ((DartReference)expression).resolve();
        }
        ArrayList<DartComponentName> result = new ArrayList<DartComponentName>();
        DartResolveProcessor dartResolveProcessor = new DartResolveProcessor(result, typeName);
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(dartType.getContainingFile());
        if (virtualFile != null) {
            DartResolveUtil.processTopLevelDeclarations((PsiElement)dartType, (DartPsiScopeProcessor)dartResolveProcessor, virtualFile, typeName);
        }
        if (result.isEmpty()) {
            PsiTreeUtil.treeWalkUp((PsiScopeProcessor)dartResolveProcessor, (PsiElement)dartType, null, (ResolveState)ResolveState.initial());
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                if (((DartComponentName)iterator.next()).getParent() instanceof DartTypeParameter) continue;
                iterator.remove();
            }
        }
        if (result.isEmpty()) {
            List<VirtualFile> libraryFiles = DartResolveUtil.findLibrary(dartType.getContainingFile());
            DartResolveUtil.processTopLevelDeclarations((PsiElement)dartType, (DartPsiScopeProcessor)dartResolveProcessor, libraryFiles, typeName);
        }
        return result.isEmpty() ? null : (PsiElement)result.iterator().next();
    }

    @Nullable
    public static DartComponentName findComponentName(@NotNull DartNormalFormalParameter normalFormalParameter) {
        if (normalFormalParameter == null) {
            DartPsiImplUtil.$$$reportNull$$$0(21);
        }
        DartFunctionFormalParameter functionFormalParameter = normalFormalParameter.getFunctionFormalParameter();
        DartFieldFormalParameter fieldFormalParameter = normalFormalParameter.getFieldFormalParameter();
        DartSimpleFormalParameter simpleFormalParameter = normalFormalParameter.getSimpleFormalParameter();
        if (functionFormalParameter != null) {
            return functionFormalParameter.getComponentName();
        }
        if (fieldFormalParameter != null) {
            return null;
        }
        if (simpleFormalParameter != null) {
            return simpleFormalParameter.getComponentName();
        }
        return null;
    }

    public static DartExpression getParameterReferenceExpression(DartNamedArgument argument) {
        return (DartExpression)PsiTreeUtil.getChildOfType((PsiElement)argument, DartExpression.class);
    }

    public static DartExpression getExpression(DartNamedArgument argument) {
        DartExpression[] expressions = (DartExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)argument, DartExpression.class);
        return expressions != null && expressions.length > 1 ? expressions[expressions.length - 1] : null;
    }

    @Nullable
    public static IDartBlock getBlock(DartFunctionBody functionBody) {
        return (IDartBlock)PsiTreeUtil.getChildOfType((PsiElement)functionBody, IDartBlock.class);
    }

    public static boolean isConstantObjectExpression(@NotNull DartNewExpression newExpression) {
        PsiElement child;
        if (newExpression == null) {
            DartPsiImplUtil.$$$reportNull$$$0(22);
        }
        return (child = newExpression.getFirstChild()) != null && child.getNode().getElementType() == DartTokenTypes.CONST;
    }

    @Nullable
    public static DartArguments getArguments(@NotNull DartNewExpression newExpression) {
        if (newExpression == null) {
            DartPsiImplUtil.$$$reportNull$$$0(23);
        }
        return (DartArguments)PsiTreeUtil.findChildOfType((PsiElement)newExpression, DartArguments.class);
    }

    @Nullable
    public static DartArguments getArguments(@NotNull DartCallExpression callExpression) {
        if (callExpression == null) {
            DartPsiImplUtil.$$$reportNull$$$0(24);
        }
        return (DartArguments)PsiTreeUtil.findChildOfType((PsiElement)callExpression, DartArguments.class);
    }

    @Nullable
    public static DartExpression getCondition(@NotNull DartPsiCompositeElement ifStatement) {
        if (ifStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(25);
        }
        return (DartExpression)PsiTreeUtil.findChildOfType((PsiElement)ifStatement, DartExpression.class);
    }

    @Nullable
    public static PsiElement getThenBranch(@NotNull DartIfStatement ifStatement) {
        if (ifStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(26);
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)DartPsiImplUtil.getCondition(ifStatement));
    }

    @Nullable
    public static PsiElement getElseBranch(@NotNull DartIfStatement ifStatement) {
        if (ifStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(27);
        }
        return DartPsiImplUtil.getBranchAfter(DartPsiImplUtil.getThenBranch(ifStatement));
    }

    @Nullable
    private static PsiElement getBranchAfter(@Nullable PsiElement child) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{LeafPsiElement.class, PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement getDoBody(@NotNull DartDoWhileStatement doStatement) {
        if (doStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(28);
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)doStatement);
    }

    @Nullable
    public static PsiElement getForBody(@NotNull DartForStatement forStatement) {
        if (forStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(29);
        }
        return forStatement.getLastChild();
    }

    @Nullable
    public static PsiElement getWhileBody(@NotNull DartWhileStatement whileStatement) {
        if (whileStatement == null) {
            DartPsiImplUtil.$$$reportNull$$$0(30);
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)DartPsiImplUtil.getCondition(whileStatement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uriBasedDirective";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartPsiImplUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uriElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedDartString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partOfStatement";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalFormalParameter";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartPsiImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriStringAndItsRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnquotedDartStringAndItsRange";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUriString";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUriStringAndItsRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedDartStringAndItsRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataList";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getComponentName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArguments";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findComponentName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConstantObjectExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCondition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getThenBranch";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getElseBranch";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDoBody";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getForBody";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getWhileBody";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveReference$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

