/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDefaultFormalNamedParameter;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFieldFormalParameter;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartFunctionFormalParameter;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartSimpleFormalParameter;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartNameSuggesterUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPresentableUtil {
    @NonNls
    public static final String RIGHT_ARROW = UIUtil.rightArrow();
    @NonNls
    private static final String SPACE = " ";

    public static String setterGetterName(String name) {
        return name.startsWith("_") ? name.substring(1) : name;
    }

    @NotNull
    public static String getPresentableParameterList(DartComponent element) {
        String string = DartPresentableUtil.getPresentableParameterList(element, new DartGenericSpecialization());
        if (string == null) {
            DartPresentableUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getPresentableParameterList(DartComponent element, DartGenericSpecialization specialization) {
        String string = DartPresentableUtil.getPresentableParameterList(element, specialization, false, false, false);
        if (string == null) {
            DartPresentableUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getPresentableParameterList(DartComponent element, DartGenericSpecialization specialization, boolean functionalStyleSignatures, boolean displayDefaultValues, boolean displayFinalKeyword) {
        StringBuilder result = new StringBuilder();
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
        if (parameterList == null) {
            if ("" == null) {
                DartPresentableUtil.$$$reportNull$$$0(2);
            }
            return "";
        }
        List<DartNormalFormalParameter> list = parameterList.getNormalFormalParameterList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result.append(DartPresentableUtil.getPresentableNormalFormalParameter(list.get(i), specialization, functionalStyleSignatures, displayDefaultValues, displayFinalKeyword));
            if (i >= size - 1) continue;
            result.append(", ");
        }
        DartOptionalFormalParameters optionalFormalParameters = parameterList.getOptionalFormalParameters();
        if (optionalFormalParameters != null) {
            boolean isOptional;
            if (!list.isEmpty()) {
                result.append(", ");
            }
            result.append((isOptional = DartPresentableUtil.isOptionalParameterList(optionalFormalParameters)) ? (char)'{' : '[');
            List<DartDefaultFormalNamedParameter> list1 = optionalFormalParameters.getDefaultFormalNamedParameterList();
            int size2 = list1.size();
            for (int i = 0; i < size2; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                DartDefaultFormalNamedParameter formalParameter = list1.get(i);
                result.append(DartPresentableUtil.getPresentableNormalFormalParameter(formalParameter.getNormalFormalParameter(), specialization, functionalStyleSignatures, displayDefaultValues, displayFinalKeyword));
            }
            result.append(isOptional ? (char)'}' : ']');
        }
        String string = result.toString();
        if (string == null) {
            DartPresentableUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isOptionalParameterList(@NotNull DartOptionalFormalParameters parameters) {
        PsiElement firstChild;
        if (parameters == null) {
            DartPresentableUtil.$$$reportNull$$$0(4);
        }
        return (firstChild = parameters.getFirstChild()) != null && "{".equals(firstChild.getText());
    }

    public static String getPresentableNormalFormalParameter(DartNormalFormalParameter parameter, DartGenericSpecialization specialization) {
        return DartPresentableUtil.getPresentableNormalFormalParameter(parameter, specialization, false, false, false);
    }

    public static String getPresentableNormalFormalParameter(DartNormalFormalParameter parameter, DartGenericSpecialization specialization, boolean functionalStyleSignature, boolean displayDefaultValues, boolean displayFinalKeyword) {
        StringBuilder result = new StringBuilder();
        DartFunctionFormalParameter functionFormalParameter = parameter.getFunctionFormalParameter();
        DartFieldFormalParameter fieldFormalParameter = parameter.getFieldFormalParameter();
        DartSimpleFormalParameter simpleFormalParameter = parameter.getSimpleFormalParameter();
        if (functionFormalParameter != null) {
            DartReturnType returnType = functionFormalParameter.getReturnType();
            if (!functionalStyleSignature && returnType != null) {
                result.append(DartPresentableUtil.buildTypeText((DartComponent)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartComponent.class), returnType, specialization));
                result.append(SPACE);
            }
            result.append(functionFormalParameter.getName());
            result.append("(");
            result.append(DartPresentableUtil.getPresentableParameterList(functionFormalParameter, specialization, functionalStyleSignature, displayDefaultValues, displayFinalKeyword));
            result.append(")");
            if (functionalStyleSignature && returnType != null) {
                result.append(SPACE);
                result.append(RIGHT_ARROW);
                result.append(SPACE);
                result.append(DartPresentableUtil.buildTypeText((DartComponent)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartComponent.class), returnType, specialization));
            }
        } else if (fieldFormalParameter != null) {
            PsiElement resolve;
            DartVarDeclarationList varDeclarationList;
            DartType type = fieldFormalParameter.getType();
            if (type == null && (varDeclarationList = (DartVarDeclarationList)PsiTreeUtil.getParentOfType((PsiElement)(resolve = fieldFormalParameter.getReferenceExpression().resolve()), DartVarDeclarationList.class)) != null) {
                type = varDeclarationList.getVarAccessDeclaration().getType();
            }
            if (type != null) {
                result.append(DartPresentableUtil.buildTypeText((DartComponent)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartComponent.class), type, specialization));
                result.append(SPACE);
            }
            result.append(fieldFormalParameter.getReferenceExpression().getText());
        } else if (simpleFormalParameter != null) {
            if (displayDefaultValues) {
                PsiElement defaultFormalNamedParameter = PsiTreeUtil.getParentOfType((PsiElement)simpleFormalParameter, DartDefaultFormalNamedParameter.class);
                if (defaultFormalNamedParameter != null) {
                    result.append(defaultFormalNamedParameter.getText());
                } else {
                    DartType type;
                    if (displayFinalKeyword && simpleFormalParameter.isFinal()) {
                        result.append(DartTokenTypes.FINAL.toString());
                        result.append(SPACE);
                    }
                    if ((type = simpleFormalParameter.getType()) != null) {
                        result.append(DartPresentableUtil.buildTypeText((DartComponent)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartComponent.class), type, specialization));
                        result.append(SPACE);
                    }
                    result.append(simpleFormalParameter.getComponentName().getText());
                }
            } else {
                DartType type;
                if (displayFinalKeyword && simpleFormalParameter.isFinal()) {
                    result.append(DartTokenTypes.FINAL.toString());
                    result.append(SPACE);
                }
                if ((type = simpleFormalParameter.getType()) != null) {
                    result.append(DartPresentableUtil.buildTypeText((DartComponent)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartComponent.class), type, specialization));
                    result.append(SPACE);
                }
                result.append(simpleFormalParameter.getComponentName().getText());
            }
        }
        return result.toString();
    }

    public static String buildTypeText(@Nullable DartComponent element, @NotNull DartReturnType returnType, @Nullable DartGenericSpecialization specializations) {
        if (returnType == null) {
            DartPresentableUtil.$$$reportNull$$$0(5);
        }
        return returnType.getType() == null ? "void" : DartPresentableUtil.buildTypeText(element, returnType.getType(), specializations);
    }

    public static String buildTypeText(@Nullable DartComponent element, @Nullable DartType type, @Nullable DartGenericSpecialization specializations) {
        if (type == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        DartReferenceExpression expression = type.getReferenceExpression();
        if (expression != null) {
            String typeText = expression.getText();
            if (specializations != null && !typeText.isEmpty() && specializations.containsKey((PsiElement)element, typeText)) {
                DartClass dartClass = specializations.get((PsiElement)element, typeText).getDartClass();
                result.append(dartClass == null ? typeText : dartClass.getName());
            } else {
                result.append(typeText);
            }
            DartTypeArguments typeArguments = type.getTypeArguments();
            if (typeArguments != null) {
                result.append("<");
                List<DartType> list = typeArguments.getTypeList().getTypeList();
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    DartType typeListPart = list.get(i);
                    result.append(DartPresentableUtil.buildTypeText(element, typeListPart, specializations));
                }
                result.append(">");
            }
        } else {
            result.append("Function");
        }
        return result.toString();
    }

    public static void appendArgumentList(@NotNull Template result, @NotNull DartArgumentList argumentList) {
        if (result == null) {
            DartPresentableUtil.$$$reportNull$$$0(6);
        }
        if (argumentList == null) {
            DartPresentableUtil.$$$reportNull$$$0(7);
        }
        List<DartNamedArgument> namedArgumentList = argumentList.getNamedArgumentList();
        THashSet additionalUsedNamed = new THashSet();
        for (DartNamedArgument namedArgument : namedArgumentList) {
            additionalUsedNamed.add(namedArgument.getParameterReferenceExpression().getText());
        }
        boolean needComma = false;
        for (DartExpression expression : argumentList.getExpressionList()) {
            String name;
            DartClass dartClass;
            if (needComma) {
                result.addTextSegment(", ");
            }
            if (expression instanceof DartReference && (dartClass = ((DartReference)expression).resolveDartClass().getDartClass()) != null && (name = dartClass.getName()) != null) {
                result.addTextSegment(name);
                result.addTextSegment(SPACE);
            }
            Collection<String> suggestedNames = DartNameSuggesterUtil.getSuggestedNames(expression, (Collection<String>)additionalUsedNamed);
            String parameterName = suggestedNames.iterator().next();
            additionalUsedNamed.add(parameterName);
            result.addVariable(DartPresentableUtil.getExpression(parameterName), true);
            needComma = true;
        }
        if (namedArgumentList.isEmpty()) {
            return;
        }
        if (needComma) {
            result.addTextSegment(", ");
            needComma = false;
        }
        result.addTextSegment("{");
        for (DartNamedArgument namedArgument : namedArgumentList) {
            String name;
            DartClass dartClass;
            DartExpression expression;
            if (needComma) {
                result.addTextSegment(", ");
            }
            if ((expression = namedArgument.getExpression()) instanceof DartReference && (dartClass = ((DartReference)expression).resolveDartClass().getDartClass()) != null && (name = dartClass.getName()) != null) {
                result.addTextSegment(name);
                result.addTextSegment(SPACE);
            }
            result.addVariable(DartPresentableUtil.getExpression(namedArgument.getParameterReferenceExpression().getText()), true);
            needComma = true;
        }
        result.addTextSegment("}");
    }

    public static Expression getExpression(String parameterName) {
        return new DartTemplateExpression(parameterName);
    }

    public static String buildClassText(@NotNull DartClass dartClass, DartGenericSpecialization specialization) {
        if (dartClass == null) {
            DartPresentableUtil.$$$reportNull$$$0(8);
        }
        StringBuilder result = new StringBuilder();
        result.append(dartClass.getName());
        DartTypeParameters typeParameters = (DartTypeParameters)PsiTreeUtil.getChildOfType((PsiElement)dartClass, DartTypeParameters.class);
        if (typeParameters != null) {
            result.append("<");
            for (DartTypeParameter typeParameter : typeParameters.getTypeParameterList()) {
                DartClass paramDartClass;
                DartComponentName componentName = typeParameter.getComponentName();
                String typeParamName = componentName.getText();
                DartClassResolveResult resolveResult = specialization.get((PsiElement)dartClass, typeParamName);
                DartClass dartClass2 = paramDartClass = resolveResult == null ? null : resolveResult.getDartClass();
                if (paramDartClass == null) {
                    result.append(typeParamName);
                    continue;
                }
                result.append(DartPresentableUtil.buildClassText(paramDartClass, resolveResult.getSpecialization()));
            }
            result.append(">");
        }
        return result.toString();
    }

    @Nullable
    public static String findLastQuotedWord(@NotNull String text) {
        if (text == null) {
            DartPresentableUtil.$$$reportNull$$$0(9);
        }
        return DartPresentableUtil.findLastQuotedWord(text, '\'');
    }

    @Nullable
    public static String findLastDoubleQuotedWord(@NotNull String text) {
        if (text == null) {
            DartPresentableUtil.$$$reportNull$$$0(10);
        }
        return DartPresentableUtil.findLastQuotedWord(text, '\"');
    }

    @Nullable
    public static String findLastQuotedWord(@NotNull String text, char quote) {
        int j;
        if (text == null) {
            DartPresentableUtil.$$$reportNull$$$0(11);
        }
        if ((j = text.lastIndexOf(quote)) == -1) {
            return null;
        }
        int i = (text = text.substring(0, j)).lastIndexOf(quote);
        if (i == -1) {
            return null;
        }
        return text.substring(i + 1);
    }

    @Nullable
    public static String findFirstQuotedWord(@NotNull String text) {
        if (text == null) {
            DartPresentableUtil.$$$reportNull$$$0(12);
        }
        return DartPresentableUtil.findFirstQuotedWord(text, '\'');
    }

    @Nullable
    public static String findFirstQuotedWord(@NotNull String text, char quote) {
        int i;
        if (text == null) {
            DartPresentableUtil.$$$reportNull$$$0(13);
        }
        if ((i = text.indexOf(quote)) == -1) {
            return null;
        }
        int j = (text = text.substring(i + 1)).indexOf(quote);
        if (j == -1) {
            return null;
        }
        return text.substring(0, j);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartPresentableUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableParameterList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartPresentableUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOptionalParameterList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildClassText";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLastQuotedWord";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findLastDoubleQuotedWord";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFirstQuotedWord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartTemplateExpression
    extends Expression {
        private final TextResult myResult;

        public DartTemplateExpression(String text) {
            this.myResult = new TextResult(text);
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            return this.myResult;
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return this.myResult;
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return LookupElement.EMPTY_ARRAY;
        }
    }
}

