/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarInit;
import com.jetbrains.lang.dart.psi.IDartBlock;
import com.jetbrains.lang.dart.psi.impl.DartExpressionCodeFragmentImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartElementGenerator {
    @Nullable
    public static DartReference createReferenceFromText(Project myProject, String text) {
        DartExpression expression = DartElementGenerator.createExpressionFromText(myProject, text);
        return expression instanceof DartReference ? (DartReference)expression : null;
    }

    @Nullable
    public static DartExpression createExpressionFromText(Project myProject, String text) {
        PsiFile file = DartElementGenerator.createDummyFile(myProject, "var dummy = " + text + ";");
        PsiElement child = file.getFirstChild();
        if (child instanceof DartVarDeclarationList) {
            DartVarInit varInit = ((DartVarDeclarationList)child).getVarInit();
            return varInit == null ? null : varInit.getExpression();
        }
        return null;
    }

    public static PsiFile createExpressionCodeFragment(Project myProject, String text, PsiElement context) {
        String name = "dummy.dart";
        DartExpressionCodeFragmentImpl codeFragment = new DartExpressionCodeFragmentImpl(myProject, "dummy.dart", text, true);
        codeFragment.setContext(context);
        return codeFragment;
    }

    @Nullable
    public static PsiElement createStatementFromText(Project myProject, String text) {
        PsiFile file = DartElementGenerator.createDummyFile(myProject, "dummy(){" + text + "}");
        PsiElement child = file.getFirstChild();
        if (child instanceof DartFunctionDeclarationWithBodyOrNative) {
            DartFunctionBody functionBody = ((DartFunctionDeclarationWithBodyOrNative)child).getFunctionBody();
            IDartBlock block = (IDartBlock)PsiTreeUtil.getChildOfType((PsiElement)functionBody, IDartBlock.class);
            DartStatements statements = block == null ? null : block.getStatements();
            return statements == null ? null : statements.getFirstChild();
        }
        return null;
    }

    @Nullable
    public static DartId createIdentifierFromText(Project myProject, String name) {
        PsiFile dummyFile = DartElementGenerator.createDummyFile(myProject, name + "(){}");
        DartComponent dartComponent = (DartComponent)PsiTreeUtil.getChildOfType((PsiElement)dummyFile, DartComponent.class);
        DartComponentName componentName = dartComponent == null ? null : dartComponent.getComponentName();
        return componentName == null ? null : componentName.getId();
    }

    @Nullable
    public static DartLibraryNameElement createLibraryNameElementFromText(@NotNull Project project, @NotNull String libraryName) {
        PsiFile dummyFile;
        DartLibraryStatement libraryStatement;
        if (project == null) {
            DartElementGenerator.$$$reportNull$$$0(0);
        }
        if (libraryName == null) {
            DartElementGenerator.$$$reportNull$$$0(1);
        }
        return (libraryStatement = (DartLibraryStatement)PsiTreeUtil.getChildOfType((PsiElement)(dummyFile = DartElementGenerator.createDummyFile(project, "library " + libraryName + ";")), DartLibraryStatement.class)) == null ? null : libraryStatement.getLibraryNameElement();
    }

    public static PsiFile createDummyFile(Project myProject, String text) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)myProject);
        String name = "dummy." + DartFileType.INSTANCE.getDefaultExtension();
        LightVirtualFile virtualFile = new LightVirtualFile(name, (FileType)DartFileType.INSTANCE, (CharSequence)text);
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, DartLanguage.INSTANCE, false, true);
        assert (psiFile != null);
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "libraryName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/util/DartElementGenerator";
        objectArray[2] = "createLibraryNameElementFromText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

