/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassResolveCache;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartClassResolveResult
implements Cloneable {
    public static final DartClassResolveResult EMPTY = new DartClassResolveResult(null);
    @Nullable
    private final DartClass myDartClass;
    @NotNull
    private final DartGenericSpecialization mySpecialization;

    protected DartClassResolveResult(@Nullable DartClass aClass) {
        this(aClass, new DartGenericSpecialization());
    }

    protected DartClassResolveResult(@Nullable DartClass aClass, @NotNull DartGenericSpecialization specialization) {
        if (specialization == null) {
            DartClassResolveResult.$$$reportNull$$$0(0);
        }
        this.myDartClass = aClass;
        this.mySpecialization = specialization;
    }

    public DartClassResolveResult clone() {
        return new DartClassResolveResult(this.myDartClass, this.mySpecialization.clone());
    }

    @NotNull
    public static DartClassResolveResult create(@Nullable DartClass dartClass) {
        DartClassResolveResult dartClassResolveResult = DartClassResolveResult.create(dartClass, new DartGenericSpecialization());
        if (dartClassResolveResult == null) {
            DartClassResolveResult.$$$reportNull$$$0(1);
        }
        return dartClassResolveResult;
    }

    @NotNull
    public static DartClassResolveResult create(@Nullable DartClass dartClass, @NotNull DartGenericSpecialization specialization) {
        if (specialization == null) {
            DartClassResolveResult.$$$reportNull$$$0(2);
        }
        if (dartClass == null) {
            DartClassResolveResult dartClassResolveResult = new DartClassResolveResult(null);
            if (dartClassResolveResult == null) {
                DartClassResolveResult.$$$reportNull$$$0(3);
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult resolveResult = DartClassResolveCache.getInstance(dartClass.getProject()).get(dartClass);
        if (resolveResult == null) {
            resolveResult = new DartClassResolveResult(dartClass);
            DartClassResolveCache.getInstance(dartClass.getProject()).put(dartClass, resolveResult);
            DartType superClass = dartClass.getSuperClass();
            if (superClass != null) {
                DartClassResolveResult result = DartResolveUtil.resolveClassByType(superClass);
                result.specializeByParameters(superClass.getTypeArguments());
                resolveResult.merge(result.getSpecialization());
            }
            for (DartType dartType : DartResolveUtil.getImplementsAndMixinsList(dartClass)) {
                DartClassResolveResult result = DartResolveUtil.resolveClassByType(dartType);
                result.specializeByParameters(dartType.getTypeArguments());
                resolveResult.merge(result.getSpecialization());
            }
        }
        DartClassResolveResult clone = resolveResult.clone();
        clone.softMerge(specialization);
        DartClassResolveResult dartClassResolveResult = clone;
        if (dartClassResolveResult == null) {
            DartClassResolveResult.$$$reportNull$$$0(4);
        }
        return dartClassResolveResult;
    }

    private void merge(@NotNull DartGenericSpecialization otherSpecializations) {
        if (otherSpecializations == null) {
            DartClassResolveResult.$$$reportNull$$$0(5);
        }
        for (String key : otherSpecializations.map.keySet()) {
            this.mySpecialization.map.put(key, otherSpecializations.map.get(key));
        }
    }

    private void softMerge(@NotNull DartGenericSpecialization otherSpecializations) {
        if (otherSpecializations == null) {
            DartClassResolveResult.$$$reportNull$$$0(6);
        }
        for (String key : otherSpecializations.map.keySet()) {
            if (this.mySpecialization.map.containsKey(key)) continue;
            this.mySpecialization.map.put(key, otherSpecializations.map.get(key));
        }
    }

    @Nullable
    public DartClass getDartClass() {
        return this.myDartClass;
    }

    @NotNull
    public DartGenericSpecialization getSpecialization() {
        DartGenericSpecialization dartGenericSpecialization = this.mySpecialization;
        if (dartGenericSpecialization == null) {
            DartClassResolveResult.$$$reportNull$$$0(7);
        }
        return dartGenericSpecialization;
    }

    public void specialize(@Nullable PsiElement element) {
        DartType type;
        if (element == null || this.myDartClass == null || !this.myDartClass.isGeneric()) {
            return;
        }
        if (element instanceof DartNewExpression && (type = ((DartNewExpression)element).getType()) != null) {
            this.specializeByParameters(type.getTypeArguments());
        }
    }

    public void specializeByParameters(@Nullable DartTypeArguments typeArguments) {
        if (typeArguments == null || this.myDartClass == null || !this.myDartClass.isGeneric()) {
            return;
        }
        DartTypeParameters parameters = this.myDartClass.getTypeParameters();
        assert (parameters != null);
        List<DartType> typeList = typeArguments.getTypeList().getTypeList();
        int size = parameters.getTypeParameterList().size();
        for (int i = 0; i < size; ++i) {
            DartTypeParameter dartTypeParameter = parameters.getTypeParameterList().get(i);
            DartComponentName componentName = dartTypeParameter == null ? null : dartTypeParameter.getComponentName();
            DartType specializedType = typeList.get(i);
            if (componentName == null || specializedType == null) continue;
            this.mySpecialization.put((PsiElement)this.myDartClass, componentName.getText(), DartResolveUtil.getDartClassResolveResult((PsiElement)specializedType, this.mySpecialization));
        }
        DartClassResolveResult.specializeSupers(this.myDartClass, this.mySpecialization);
    }

    private static void specializeSupers(@Nullable DartClass dartClass, @NotNull DartGenericSpecialization specialization) {
        if (specialization == null) {
            DartClassResolveResult.$$$reportNull$$$0(8);
        }
        if (dartClass == null) {
            return;
        }
        DartType superType = dartClass.getSuperClass();
        if (superType != null) {
            DartClassResolveResult.specializeSuperType(dartClass, specialization, superType);
        }
        for (DartType dartType : DartResolveUtil.getImplementsAndMixinsList(dartClass)) {
            DartClassResolveResult.specializeSuperType(dartClass, specialization, dartType);
        }
    }

    private static void specializeSuperType(@Nullable DartClass dartClass, @NotNull DartGenericSpecialization specialization, @NotNull DartType type) {
        DartTypeArguments targetTypeArguments;
        if (specialization == null) {
            DartClassResolveResult.$$$reportNull$$$0(9);
        }
        if (type == null) {
            DartClassResolveResult.$$$reportNull$$$0(10);
        }
        if ((targetTypeArguments = type.getTypeArguments()) == null || dartClass == null || dartClass.getTypeParameters() == null) {
            return;
        }
        DartClassResolveResult typeTargetClassResolve = DartResolveUtil.resolveClassByType(type);
        DartClass typeTargetClass = typeTargetClassResolve.getDartClass();
        if (typeTargetClass == null) {
            return;
        }
        DartTypeParameters typeTargetClassTypeParameters = typeTargetClass.getTypeParameters();
        List<DartType> list = targetTypeArguments.getTypeList().getTypeList();
        if (typeTargetClassTypeParameters == null || typeTargetClassTypeParameters.getTypeParameterList().size() != list.size()) {
            return;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String superGenericName;
            DartClassResolveResult resolveResult;
            DartType argumentType = list.get(i);
            PsiElement argumentTarget = argumentType.resolveReference();
            if (argumentTarget == null || dartClass.getTypeParameters() != PsiTreeUtil.getParentOfType((PsiElement)argumentTarget, DartTypeParameters.class) || (resolveResult = specialization.get((PsiElement)typeTargetClass, superGenericName = typeTargetClassTypeParameters.getTypeParameterList().get(i).getComponentName().getText())) != null && resolveResult.getDartClass() != null) continue;
            specialization.put((PsiElement)typeTargetClass, superGenericName, specialization.get((PsiElement)dartClass, argumentTarget.getText()));
            DartClassResolveResult.specializeSupers(typeTargetClass, specialization);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialization";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/util/DartClassResolveResult";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSpecializations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/util/DartClassResolveResult";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "softMerge";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "specializeSupers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "specializeSuperType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

