/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSdkUtil {
    private static final Map<Pair<File, Long>, String> ourVersions = new HashMap<Pair<File, Long>, String>();
    private static final String DART_SDK_KNOWN_PATHS = "DART_SDK_KNOWN_PATHS";
    private static final String DARTIUM_KNOWN_PATHS = "DARTIUM_KNOWN_PATHS";

    @Nullable
    public static String getSdkVersion(@NotNull String sdkHomePath) {
        String cachedVersion;
        File versionFile;
        if (sdkHomePath == null) {
            DartSdkUtil.$$$reportNull$$$0(0);
        }
        if ((versionFile = new File(sdkHomePath + "/version")).isFile() && (cachedVersion = ourVersions.get(Pair.create((Object)versionFile, (Object)versionFile.lastModified()))) != null) {
            return cachedVersion;
        }
        String version = DartSdkUtil.readVersionFile(sdkHomePath);
        if (version != null) {
            ourVersions.put((Pair<File, Long>)Pair.create((Object)versionFile, (Object)versionFile.lastModified()), version);
            return version;
        }
        return null;
    }

    private static String readVersionFile(String sdkHomePath) {
        File versionFile = new File(sdkHomePath + "/version");
        if (versionFile.isFile() && versionFile.length() < 100L) {
            try {
                return FileUtil.loadFile((File)versionFile).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Contract(value="null->false")
    public static boolean isDartSdkHome(@Nullable String path) {
        return path != null && !path.isEmpty() && new File(path + "/lib/core/core.dart").isFile();
    }

    public static void initDartSdkAndDartiumControls(@Nullable Project project, final @NotNull ComboboxWithBrowseButton dartSdkPathComponent, final @NotNull JBLabel versionLabel, final @NotNull ComboboxWithBrowseButton dartiumPathComponent, @NotNull Computable<ChromeSettings> currentDartiumSettingsRetriever, @NotNull JButton dartiumSettingsButton, final @NotNull Computable<Boolean> isResettingControlsComputable) {
        String sdkHomePath;
        if (dartSdkPathComponent == null) {
            DartSdkUtil.$$$reportNull$$$0(1);
        }
        if (versionLabel == null) {
            DartSdkUtil.$$$reportNull$$$0(2);
        }
        if (dartiumPathComponent == null) {
            DartSdkUtil.$$$reportNull$$$0(3);
        }
        if (currentDartiumSettingsRetriever == null) {
            DartSdkUtil.$$$reportNull$$$0(4);
        }
        if (dartiumSettingsButton == null) {
            DartSdkUtil.$$$reportNull$$$0(5);
        }
        if (isResettingControlsComputable == null) {
            DartSdkUtil.$$$reportNull$$$0(6);
        }
        dartSdkPathComponent.getComboBox().setEditable(true);
        DartSdkUtil.addKnownPathsToCombo(dartSdkPathComponent.getComboBox(), DART_SDK_KNOWN_PATHS, (BooleanFunction<String>)((BooleanFunction)DartSdkUtil::isDartSdkHome));
        if (SystemInfo.isMac && DartSdkUtil.getItemFromCombo(dartSdkPathComponent.getComboBox()).isEmpty()) {
            dartSdkPathComponent.getComboBox().getEditor().setItem("/usr/local/opt/dart/libexec");
        }
        dartiumPathComponent.getComboBox().setEditable(true);
        DartSdkUtil.addKnownPathsToCombo(dartiumPathComponent.getComboBox(), DARTIUM_KNOWN_PATHS, (BooleanFunction<String>)((BooleanFunction)path -> !path.isEmpty() && new File((String)path).exists()));
        if (SystemInfo.isMac && DartSdkUtil.getItemFromCombo(dartiumPathComponent.getComboBox()).isEmpty() && new File("/usr/local/opt/dart/Chromium.app").isDirectory()) {
            dartiumPathComponent.getComboBox().getEditor().setItem("/usr/local/opt/dart/Chromium.app");
        }
        versionLabel.setText((sdkHomePath = DartSdkUtil.getItemFromCombo(dartSdkPathComponent.getComboBox())).isEmpty() ? "" : DartSdkUtil.getSdkVersion(sdkHomePath));
        TextComponentAccessor<JComboBox> textComponentAccessor = new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                return DartSdkUtil.getItemFromCombo(component);
            }

            public void setText(@NotNull JComboBox component, @NotNull String text) {
                String probablySdkPath;
                if (component == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!text.isEmpty() && !DartSdkUtil.isDartSdkHome(text) && DartSdkUtil.isDartSdkHome(probablySdkPath = text + "/dart-sdk")) {
                    component.getEditor().setItem(FileUtilRt.toSystemDependentName((String)probablySdkPath));
                    return;
                }
                component.getEditor().setItem(FileUtilRt.toSystemDependentName((String)text));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/lang/dart/sdk/DartSdkUtil$1";
                objectArray[2] = "setText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ComponentWithBrowseButton.BrowseFolderActionListener browseFolderListener = new ComponentWithBrowseButton.BrowseFolderActionListener("Select Dart SDK path", null, (ComponentWithBrowseButton)dartSdkPathComponent, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (TextComponentAccessor)textComponentAccessor);
        dartSdkPathComponent.addActionListener((ActionListener)browseFolderListener);
        dartiumPathComponent.addBrowseFolderListener("Select Dartium browser path", null, project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        JTextComponent editorComponent = (JTextComponent)dartSdkPathComponent.getComboBox().getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String dartiumPath;
                String sdkHomePath = DartSdkUtil.getItemFromCombo(dartSdkPathComponent.getComboBox());
                versionLabel.setText(sdkHomePath.isEmpty() ? "" : DartSdkUtil.getSdkVersion(sdkHomePath));
                if (!((Boolean)isResettingControlsComputable.compute()).booleanValue() && DartSdkUtil.isDartSdkHome(sdkHomePath) && (dartiumPath = DartiumUtil.getDartiumPathForSdk(sdkHomePath)) != null) {
                    dartiumPathComponent.getComboBox().getEditor().setItem(FileUtilRt.toSystemDependentName((String)dartiumPath));
                }
            }
        });
        dartiumSettingsButton.addActionListener(e -> {
            if (dartiumSettingsButton == null) {
                DartSdkUtil.$$$reportNull$$$0(22);
            }
            if (currentDartiumSettingsRetriever == null) {
                DartSdkUtil.$$$reportNull$$$0(23);
            }
            ShowSettingsUtil.getInstance().editConfigurable((Component)dartiumSettingsButton, (Configurable)((ChromeSettings)currentDartiumSettingsRetriever.compute()).createConfigurable());
        });
    }

    @NotNull
    private static String getItemFromCombo(@NotNull JComboBox combo) {
        if (combo == null) {
            DartSdkUtil.$$$reportNull$$$0(7);
        }
        String string = combo.getEditor().getItem().toString().trim();
        if (string == null) {
            DartSdkUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String getFirstKnownDartSdkPath() {
        String[] knownPaths = PropertiesComponent.getInstance().getValues(DART_SDK_KNOWN_PATHS);
        if (knownPaths != null && knownPaths.length > 0 && DartSdkUtil.isDartSdkHome(knownPaths[0])) {
            return knownPaths[0];
        }
        return null;
    }

    private static void addKnownPathsToCombo(@NotNull JComboBox combo, @NotNull String propertyKey, @NotNull BooleanFunction<String> pathChecker) {
        String[] knownPaths;
        if (combo == null) {
            DartSdkUtil.$$$reportNull$$$0(9);
        }
        if (propertyKey == null) {
            DartSdkUtil.$$$reportNull$$$0(10);
        }
        if (pathChecker == null) {
            DartSdkUtil.$$$reportNull$$$0(11);
        }
        SmartList validPathsForUI = new SmartList();
        String currentPath = DartSdkUtil.getItemFromCombo(combo);
        if (!currentPath.isEmpty()) {
            validPathsForUI.add((Object)currentPath);
        }
        if ((knownPaths = PropertiesComponent.getInstance().getValues(propertyKey)) != null && knownPaths.length > 0) {
            for (String path : knownPaths) {
                String pathSD = FileUtil.toSystemDependentName((String)path);
                if (pathSD.equals(currentPath) || !pathChecker.fun((Object)path)) continue;
                validPathsForUI.add((Object)pathSD);
            }
        }
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray((Collection)validPathsForUI)));
    }

    public static void updateKnownSdkPaths(@NotNull Project project, @NotNull String newSdkPath) {
        DartSdk oldSdk;
        if (project == null) {
            DartSdkUtil.$$$reportNull$$$0(12);
        }
        if (newSdkPath == null) {
            DartSdkUtil.$$$reportNull$$$0(13);
        }
        DartSdkUtil.updateKnownPaths(DART_SDK_KNOWN_PATHS, (oldSdk = DartSdk.getDartSdk(project)) == null ? null : oldSdk.getHomePath(), newSdkPath);
    }

    public static void updateKnownDartiumPaths(@Nullable String oldPath, @NotNull String newPath) {
        if (newPath == null) {
            DartSdkUtil.$$$reportNull$$$0(14);
        }
        DartSdkUtil.updateKnownPaths(DARTIUM_KNOWN_PATHS, oldPath, newPath);
    }

    private static void updateKnownPaths(@NotNull String propertyKey, @Nullable String oldPath, @NotNull String newPath) {
        if (propertyKey == null) {
            DartSdkUtil.$$$reportNull$$$0(15);
        }
        if (newPath == null) {
            DartSdkUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> knownPaths = new ArrayList<String>();
        String[] oldKnownPaths = PropertiesComponent.getInstance().getValues(propertyKey);
        if (oldKnownPaths != null) {
            knownPaths.addAll(Arrays.asList(oldKnownPaths));
        }
        if (oldPath != null) {
            knownPaths.remove(oldPath);
            knownPaths.add(0, oldPath);
        }
        knownPaths.remove(newPath);
        knownPaths.add(0, newPath);
        if (knownPaths.isEmpty()) {
            PropertiesComponent.getInstance().unsetValue(propertyKey);
        } else {
            PropertiesComponent.getInstance().setValues(propertyKey, ArrayUtil.toStringArray(knownPaths));
        }
    }

    @Nullable
    public static String getErrorMessageIfWrongSdkRootPath(@NotNull String sdkRootPath) {
        if (sdkRootPath == null) {
            DartSdkUtil.$$$reportNull$$$0(17);
        }
        if (sdkRootPath.isEmpty()) {
            return DartBundle.message("error.path.to.sdk.not.specified", new Object[0]);
        }
        File sdkRoot = new File(sdkRootPath);
        if (!sdkRoot.isDirectory()) {
            return DartBundle.message("error.folder.specified.as.sdk.not.exists", new Object[0]);
        }
        if (!DartSdkUtil.isDartSdkHome(sdkRootPath)) {
            return DartBundle.message("error.sdk.not.found.in.specified.location", new Object[0]);
        }
        return null;
    }

    public static String getDartExePath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            DartSdkUtil.$$$reportNull$$$0(18);
        }
        return sdk.getHomePath() + (SystemInfo.isWindows ? "/bin/dart.exe" : "/bin/dart");
    }

    public static String getPubPath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            DartSdkUtil.$$$reportNull$$$0(19);
        }
        return DartSdkUtil.getPubPath(sdk.getHomePath());
    }

    public static String getPubPath(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            DartSdkUtil.$$$reportNull$$$0(20);
        }
        return sdkRoot + (SystemInfo.isWindows ? "/bin/pub.bat" : "/bin/pub");
    }

    public static String getPubSnapshotPath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            DartSdkUtil.$$$reportNull$$$0(21);
        }
        return sdk.getHomePath() + "/bin/snapshots/pub.dart.snapshot";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartSdkPathComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionLabel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartiumPathComponent";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDartiumSettingsRetriever";
                break;
            }
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartiumSettingsButton";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isResettingControlsComputable";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/sdk/DartSdkUtil";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkPath";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRootPath";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/sdk/DartSdkUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemFromCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initDartSdkAndDartiumControls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItemFromCombo";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addKnownPathsToCombo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownSdkPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownDartiumPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfWrongSdkRootPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDartExePath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPubPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPubSnapshotPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initDartSdkAndDartiumControls$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

