/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class DartSdkUpdateChecker {
    public static final String SDK_STABLE_DOWNLOAD_URL = "https://www.dartlang.org/redirects/sdk-download-stable";
    private static final String SDK_DEV_DOWNLOAD_URL = "https://www.dartlang.org/redirects/sdk-download-dev";
    private static final String SDK_STABLE_UPDATE_CHECK_URL = "https://storage.googleapis.com/dart-archive/channels/stable/release/latest/VERSION";
    private static final String SDK_DEV_UPDATE_CHECK_URL = "https://storage.googleapis.com/dart-archive/channels/dev/release/latest/VERSION";
    private static final String DART_LAST_SDK_CHECK_KEY = "DART_LAST_SDK_CHECK_KEY";
    private static final long CHECK_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)([0-9A-Za-z\\-\\+\\.]*)");

    public static void mayBeCheckForSdkUpdate(@NotNull Project project) {
        if (project == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"dart.projects.without.pubspec", (boolean)false)) {
            return;
        }
        DartSdkUpdateOption option = DartSdkUpdateOption.getDartSdkUpdateOption();
        if (option == DartSdkUpdateOption.DoNotCheck) {
            return;
        }
        long lastCheckedMillis = PropertiesComponent.getInstance().getOrInitLong(DART_LAST_SDK_CHECK_KEY, 0L);
        if (System.currentTimeMillis() - lastCheckedMillis < CHECK_INTERVAL) {
            return;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null) {
            return;
        }
        if (FlutterUtil.getFlutterRoot(sdk.getHomePath()) != null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                DartSdkUpdateChecker.$$$reportNull$$$0(13);
            }
            if (!project.isDisposed()) {
                PropertiesComponent.getInstance().setValue(DART_LAST_SDK_CHECK_KEY, String.valueOf(System.currentTimeMillis()));
                String currentSdkVersion = sdk.getVersion();
                SdkUpdateInfo sdkUpdateInfo = DartSdkUpdateChecker.getSdkUpdateInfo(option);
                if (sdkUpdateInfo != null && DartSdkUpdateChecker.compareDartSdkVersions(sdkUpdateInfo.myVersion, currentSdkVersion) > 0) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            DartSdkUpdateChecker.$$$reportNull$$$0(14);
                        }
                        DartSdkUpdateChecker.notifySdkUpdateAvailable(project, currentSdkVersion, sdkUpdateInfo.myVersion, sdkUpdateInfo.myDownloadUrl);
                    }, ModalityState.NON_MODAL, project.getDisposed());
                }
            }
        });
    }

    @Nullable
    static SdkUpdateInfo getSdkUpdateInfo(@NotNull DartSdkUpdateOption updateOption) {
        SdkUpdateInfo devSdkInfo;
        if (updateOption == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(1);
        }
        boolean checkForStable = updateOption == DartSdkUpdateOption.Stable || updateOption == DartSdkUpdateOption.StableAndDev;
        boolean checkForDev = updateOption == DartSdkUpdateOption.StableAndDev;
        SdkUpdateInfo stableSdkInfo = checkForStable ? DartSdkUpdateChecker.getSdkUpdateInfo(SDK_STABLE_UPDATE_CHECK_URL, SDK_STABLE_DOWNLOAD_URL) : null;
        SdkUpdateInfo sdkUpdateInfo = devSdkInfo = checkForDev ? DartSdkUpdateChecker.getSdkUpdateInfo(SDK_DEV_UPDATE_CHECK_URL, SDK_DEV_DOWNLOAD_URL) : null;
        SdkUpdateInfo sdkUpdateInfo2 = stableSdkInfo == null ? devSdkInfo : (devSdkInfo == null ? stableSdkInfo : (DartSdkUpdateChecker.compareDartSdkVersions(devSdkInfo.myVersion, stableSdkInfo.myVersion) > 0 ? devSdkInfo : stableSdkInfo));
        return sdkUpdateInfo2;
    }

    public static int compareDartSdkVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(2);
        }
        if (version2 == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(3);
        }
        Couple<String> version1Parts = DartSdkUpdateChecker.getMajorMinorPatchAndRemainder(version1);
        Couple<String> version2Parts = DartSdkUpdateChecker.getMajorMinorPatchAndRemainder(version2);
        if (version1Parts == null || version2Parts == null) {
            return StringUtil.compareVersionNumbers((String)version1, (String)version2);
        }
        String majorMinorPatch1 = (String)version1Parts.first;
        String remainder1 = (String)version1Parts.second;
        String majorMinorPatch2 = (String)version2Parts.first;
        String remainder2 = (String)version2Parts.second;
        int result = StringUtil.compareVersionNumbers((String)majorMinorPatch1, (String)majorMinorPatch2);
        if (result != 0 || Comparing.equal((String)remainder1, (String)remainder2)) {
            return result;
        }
        if (remainder1.isEmpty()) {
            return 1;
        }
        if (remainder2.isEmpty()) {
            return -1;
        }
        return StringUtil.compareVersionNumbers((String)remainder1, (String)remainder2);
    }

    @Nullable
    private static Couple<String> getMajorMinorPatchAndRemainder(@NotNull String semanticVersion) {
        Matcher matcher;
        if (semanticVersion == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(4);
        }
        if ((matcher = SEMANTIC_VERSION_PATTERN.matcher(semanticVersion)).matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    private static void notifySdkUpdateAvailable(@NotNull Project project, @NotNull String currentSdkVersion, @NotNull String availableSdkVersion, @NotNull String downloadUrl) {
        if (project == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(5);
        }
        if (currentSdkVersion == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(6);
        }
        if (availableSdkVersion == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(7);
        }
        if (downloadUrl == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(8);
        }
        String title = DartBundle.message("dart.sdk.update.title", new Object[0]);
        String message = DartBundle.message("new.dart.sdk.available.for.download..notification", availableSdkVersion, currentSdkVersion);
        UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, (notification, event) -> {
            if (downloadUrl == null) {
                DartSdkUpdateChecker.$$$reportNull$$$0(11);
            }
            if (project == null) {
                DartSdkUpdateChecker.$$$reportNull$$$0(12);
            }
            notification.expire();
            if ("download".equals(event.getDescription())) {
                BrowserUtil.browse((String)downloadUrl);
            }
            if ("settings".equals(event.getDescription())) {
                DartConfigurable.openDartSettings(project);
            }
        }).notify(project);
    }

    @Nullable
    private static SdkUpdateInfo getSdkUpdateInfo(@NotNull String updateCheckUrl, @NotNull String sdkDownloadUrl) {
        if (updateCheckUrl == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(9);
        }
        if (sdkDownloadUrl == null) {
            DartSdkUpdateChecker.$$$reportNull$$$0(10);
        }
        try {
            String versionFileContents = HttpRequests.request((String)updateCheckUrl).readString(null);
            String version = new JSONObject(versionFileContents).optString("version", null);
            if (version != null) {
                return new SdkUpdateInfo(sdkDownloadUrl, version);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateOption";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semanticVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdkVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableSdkVersion";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateCheckUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDownloadUrl";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mayBeCheckForSdkUpdate";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdkUpdateInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareDartSdkVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMajorMinorPatchAndRemainder";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "notifySdkUpdateAvailable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$notifySdkUpdateAvailable$2";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$mayBeCheckForSdkUpdate$1";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class SdkUpdateInfo {
        @NotNull
        final String myDownloadUrl;
        @NotNull
        final String myVersion;

        public SdkUpdateInfo(@NotNull String downloadUrl, @NotNull String version) {
            if (downloadUrl == null) {
                SdkUpdateInfo.$$$reportNull$$$0(0);
            }
            if (version == null) {
                SdkUpdateInfo.$$$reportNull$$$0(1);
            }
            this.myDownloadUrl = downloadUrl;
            this.myVersion = version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "downloadUrl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker$SdkUpdateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

