/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class DartSdkLibUtil {
    private static final Logger LOG = Logger.getInstance((String)DartSdkLibUtil.class.getName());
    private static final String[] SDK_LIB_SUBFOLDERS_BLACKLIST = new String[]{"analysis_server", "analyzer", "dev_compiler", "front_end", "internal", "kernel", "profiler"};

    public static boolean isIdeWithMultipleModuleSupport() {
        return PlatformUtils.isIntelliJ();
    }

    public static void ensureDartSdkConfigured(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(0);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(1);
        }
        DartSdkLibUtil.configureDartSdkAndReturnUndoingDisposable(project, sdkHomePath);
    }

    @NotNull
    @VisibleForTesting
    public static Disposable configureDartSdkAndReturnUndoingDisposable(@NotNull Project project, @NotNull String sdkHomePath) {
        LibraryTable libraryTable;
        Library library;
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(2);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(3);
        }
        if ((library = (libraryTable = ProjectLibraryTable.getInstance((Project)project)).getLibraryByName("Dart SDK")) == null) {
            LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
            Library lib = DartSdkLibUtil.createDartSdkLib(project, model, sdkHomePath);
            model.commit();
            Disposable disposable = () -> {
                if (((LibraryEx)lib).isDisposed()) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction(null, () -> {
                    LibraryTable.ModifiableModel m = libraryTable.getModifiableModel();
                    m.removeLibrary(lib);
                    m.commit();
                });
            };
            if (disposable == null) {
                DartSdkLibUtil.$$$reportNull$$$0(4);
            }
            return disposable;
        }
        DartSdk sdk = DartSdk.getSdkByLibrary(library);
        if (sdk == null || !sdkHomePath.equals(sdk.getHomePath())) {
            Disposable disposable = DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
            if (disposable == null) {
                DartSdkLibUtil.$$$reportNull$$$0(5);
            }
            return disposable;
        }
        Disposable disposable = () -> {};
        if (disposable == null) {
            DartSdkLibUtil.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    public static void ensureDartSdkConfigured(@NotNull Project project, @NotNull LibraryTable.ModifiableModel libraryTableModel, @NotNull String sdkHomePath) {
        Library library;
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(7);
        }
        if (libraryTableModel == null) {
            DartSdkLibUtil.$$$reportNull$$$0(8);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(9);
        }
        if ((library = libraryTableModel.getLibraryByName("Dart SDK")) == null) {
            DartSdkLibUtil.createDartSdkLib(project, libraryTableModel, sdkHomePath);
        } else {
            DartSdk sdk = DartSdk.getSdkByLibrary(library);
            if (sdk == null || !sdkHomePath.equals(sdk.getHomePath())) {
                DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
            }
        }
    }

    @NotNull
    private static Library createDartSdkLib(@NotNull Project project, @NotNull LibraryTable.ModifiableModel libraryTableModel, @NotNull String sdkHomePath) {
        Library existingLib;
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(10);
        }
        if (libraryTableModel == null) {
            DartSdkLibUtil.$$$reportNull$$$0(11);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(12);
        }
        if ((existingLib = libraryTableModel.getLibraryByName("Dart SDK")) != null) {
            DartSdkLibUtil.setupDartSdkRoots(project, existingLib, sdkHomePath);
            Library library = existingLib;
            if (library == null) {
                DartSdkLibUtil.$$$reportNull$$$0(13);
            }
            return library;
        }
        Library library = libraryTableModel.createLibrary("Dart SDK");
        DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
        Library library2 = library;
        if (library2 == null) {
            DartSdkLibUtil.$$$reportNull$$$0(14);
        }
        return library2;
    }

    @NotNull
    private static Disposable setupDartSdkRoots(@NotNull Project project, @NotNull Library library, @NotNull String sdkHomePath) {
        Disposable disposable;
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(15);
        }
        if (library == null) {
            DartSdkLibUtil.$$$reportNull$$$0(16);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(17);
        }
        LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkHomePath + "/lib");
        SortedSet<String> roots = DartSdkLibUtil.getRootUrls(project, sdkHomePath);
        if (roots.isEmpty()) {
            Disposable disposable2 = () -> {};
            if (disposable2 == null) {
                DartSdkLibUtil.$$$reportNull$$$0(18);
            }
            return disposable2;
        }
        if (Comparing.haveEqualElements((Object[])ArrayUtil.toStringArray(roots), (Object[])library.getRootProvider().getUrls(OrderRootType.CLASSES))) {
            Disposable disposable3 = () -> {};
            if (disposable3 == null) {
                DartSdkLibUtil.$$$reportNull$$$0(19);
            }
            return disposable3;
        }
        LibraryEx.ModifiableModelEx libModifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        try {
            for (String url : libModifiableModel.getUrls(OrderRootType.CLASSES)) {
                libModifiableModel.removeRoot(url, OrderRootType.CLASSES);
            }
            for (String url : libModifiableModel.getExcludedRootUrls()) {
                libModifiableModel.removeExcludedRoot(url);
            }
            for (String root : roots) {
                libModifiableModel.addRoot(root, OrderRootType.CLASSES);
            }
            libModifiableModel.commit();
            disposable = () -> {
                if (library == null) {
                    DartSdkLibUtil.$$$reportNull$$$0(46);
                }
                WriteCommandAction.runWriteCommandAction(null, () -> {
                    if (library == null) {
                        DartSdkLibUtil.$$$reportNull$$$0(47);
                    }
                    Library.ModifiableModel m = library.getModifiableModel();
                    for (String root : roots) {
                        m.removeRoot(root, OrderRootType.CLASSES);
                    }
                    m.commit();
                });
            };
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Disposer.dispose((Disposable)libModifiableModel);
            Disposable disposable4 = () -> {};
            if (disposable4 == null) {
                DartSdkLibUtil.$$$reportNull$$$0(21);
            }
            return disposable4;
        }
        if (disposable == null) {
            DartSdkLibUtil.$$$reportNull$$$0(20);
        }
        return disposable;
    }

    @NotNull
    private static SortedSet<String> getRootUrls(@NotNull Project project, @NotNull String sdkHomePath) {
        SortedSet<String> result;
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(22);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(23);
        }
        if ((result = DartSdkLibUtil.getRootUrlsFromLibrariesFile(project, sdkHomePath)).isEmpty() || !result.contains(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/core")))) {
            LOG.info("Failed to get useful info from " + sdkHomePath + "/lib/_internal/libraries.dart");
            SortedSet<String> sortedSet = DartSdkLibUtil.getRootUrlsFailover(sdkHomePath);
            if (sortedSet == null) {
                DartSdkLibUtil.$$$reportNull$$$0(24);
            }
            return sortedSet;
        }
        SortedSet<String> sortedSet = result;
        if (sortedSet == null) {
            DartSdkLibUtil.$$$reportNull$$$0(25);
        }
        return sortedSet;
    }

    @NotNull
    @VisibleForTesting
    public static SortedSet<String> getRootUrlsFromLibrariesFile(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(26);
        }
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(27);
        }
        BidirectionalMap<String, String> map = DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdkHomePath);
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).startsWith("dart:_")) continue;
            String relPath = (String)entry.getValue();
            int slashIndex = relPath.indexOf("/");
            if (slashIndex <= 0) {
                LOG.info("Skipping unexpected Dart library path: " + relPath);
                continue;
            }
            result.add(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/" + relPath.substring(0, slashIndex))));
        }
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            DartSdkLibUtil.$$$reportNull$$$0(28);
        }
        return treeSet;
    }

    @NotNull
    @VisibleForTesting
    public static SortedSet<String> getRootUrlsFailover(@NotNull String sdkHomePath) {
        if (sdkHomePath == null) {
            DartSdkLibUtil.$$$reportNull$$$0(29);
        }
        TreeSet<String> result = new TreeSet<String>();
        File lib = new File(sdkHomePath + "/lib");
        if (!lib.isDirectory()) {
            TreeSet<String> treeSet = result;
            if (treeSet == null) {
                DartSdkLibUtil.$$$reportNull$$$0(30);
            }
            return treeSet;
        }
        File[] children = lib.listFiles();
        if (children == null) {
            TreeSet<String> treeSet = result;
            if (treeSet == null) {
                DartSdkLibUtil.$$$reportNull$$$0(31);
            }
            return treeSet;
        }
        for (File subDir : children) {
            String subDirName = subDir.getName();
            if (!subDir.isDirectory() || subDirName.startsWith("_") || ArrayUtil.contains((String)subDirName, (String[])SDK_LIB_SUBFOLDERS_BLACKLIST)) continue;
            result.add(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/" + subDirName)));
        }
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            DartSdkLibUtil.$$$reportNull$$$0(32);
        }
        return treeSet;
    }

    public static boolean isDartSdkEnabled(@NotNull Module module) {
        if (module == null) {
            DartSdkLibUtil.$$$reportNull$$$0(33);
        }
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
            return true;
        }
        return false;
    }

    public static void enableDartSdk(@NotNull Module module) {
        if (module == null) {
            DartSdkLibUtil.$$$reportNull$$$0(34);
        }
        DartSdkLibUtil.enableDartSdkAndReturnUndoingDisposable(module);
    }

    @NotNull
    @VisibleForTesting
    public static Disposable enableDartSdkAndReturnUndoingDisposable(@NotNull Module module) {
        Disposable disposable;
        if (module == null) {
            DartSdkLibUtil.$$$reportNull$$$0(35);
        }
        if (DartSdkLibUtil.isDartSdkEnabled(module)) {
            Disposable disposable2 = () -> {};
            if (disposable2 == null) {
                DartSdkLibUtil.$$$reportNull$$$0(36);
            }
            return disposable2;
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            modifiableModel.addInvalidLibrary("Dart SDK", "project");
            modifiableModel.commit();
            disposable = () -> {
                if (module == null) {
                    DartSdkLibUtil.$$$reportNull$$$0(44);
                }
                if (module.isDisposed()) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction(null, () -> {
                    if (module == null) {
                        DartSdkLibUtil.$$$reportNull$$$0(45);
                    }
                    ModifiableRootModel m = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    for (OrderEntry orderEntry : m.getOrderEntries()) {
                        if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                        m.removeOrderEntry(orderEntry);
                    }
                    m.commit();
                });
            };
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
            Disposable disposable3 = () -> {};
            if (disposable3 == null) {
                DartSdkLibUtil.$$$reportNull$$$0(38);
            }
            return disposable3;
        }
        if (disposable == null) {
            DartSdkLibUtil.$$$reportNull$$$0(37);
        }
        return disposable;
    }

    public static void disableDartSdk(@NotNull Collection<Module> modules) {
        if (modules == null) {
            DartSdkLibUtil.$$$reportNull$$$0(39);
        }
        if (modules.isEmpty()) {
            return;
        }
        SmartList models = new SmartList();
        for (Module module : modules) {
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            models.add(modifiableModel);
        }
        DartProjectComponent.commitModifiableModels(modules.iterator().next().getProject(), (Collection<ModifiableRootModel>)models);
    }

    public static Collection<Module> getModulesWithDartSdkEnabled(@NotNull Project project) {
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(40);
        }
        SmartList result = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!DartSdkLibUtil.isDartSdkEnabled(module)) continue;
            result.add(module);
        }
        return result;
    }

    public static void enableDartSdkForSpecifiedModulesAndDisableForOthers(@NotNull Project project, @NotNull Module[] modulesWithDart) {
        if (project == null) {
            DartSdkLibUtil.$$$reportNull$$$0(41);
        }
        if (modulesWithDart == null) {
            DartSdkLibUtil.$$$reportNull$$$0(42);
        }
        SmartList modelsToCommit = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean mustHaveDart = ArrayUtil.contains((Object)module, (Object[])modulesWithDart);
            boolean hasDart = false;
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                hasDart = true;
                if (mustHaveDart) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (mustHaveDart && !hasDart) {
                modifiableModel.addInvalidLibrary("Dart SDK", "project");
            }
            if (modifiableModel.isChanged()) {
                modelsToCommit.add(modifiableModel);
                continue;
            }
            modifiableModel.dispose();
        }
        DartProjectComponent.commitModifiableModels(project, (Collection<ModifiableRootModel>)modelsToCommit);
    }

    public static boolean isDartSdkOrderEntry(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            DartSdkLibUtil.$$$reportNull$$$0(43);
        }
        return orderEntry instanceof LibraryOrderEntry && "project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) && "Dart SDK".equals(((LibraryOrderEntry)orderEntry).getLibraryName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/sdk/DartSdkLibUtil";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTableModel";
                break;
            }
            case 16: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesWithDart";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/sdk/DartSdkLibUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "configureDartSdkAndReturnUndoingDisposable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDartSdkLib";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setupDartSdkRoots";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrls";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrlsFromLibrariesFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrlsFailover";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "enableDartSdkAndReturnUndoingDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureDartSdkConfigured";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureDartSdkAndReturnUndoingDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDartSdkLib";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupDartSdkRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRootUrls";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRootUrlsFromLibrariesFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRootUrlsFailover";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isDartSdkEnabled";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSdk";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSdkAndReturnUndoingDisposable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "disableDartSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getModulesWithDartSdkEnabled";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSdkForSpecifiedModulesAndDisableForOthers";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isDartSdkOrderEntry";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$enableDartSdkAndReturnUndoingDisposable$10";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setupDartSdkRoots$6";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

