/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.sdk.DartSdkLibraryPresentationProvider;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSdk {
    public static final String DART_SDK_LIB_NAME = "Dart SDK";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final Key<CachedValue<DartSdk>> CACHED_DART_SDK_KEY = Key.create((String)"CACHED_DART_SDK_KEY");
    @NotNull
    private final String myHomePath;
    @NotNull
    private final String myVersion;

    private DartSdk(@NotNull String homePath, @NotNull String version) {
        if (homePath == null) {
            DartSdk.$$$reportNull$$$0(0);
        }
        if (version == null) {
            DartSdk.$$$reportNull$$$0(1);
        }
        this.myHomePath = homePath;
        this.myVersion = version;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHomePath;
        if (string == null) {
            DartSdk.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            DartSdk.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static DartSdk getDartSdk(@NotNull Project project) {
        CachedValue cachedValue;
        if (project == null) {
            DartSdk.$$$reportNull$$$0(4);
        }
        if ((cachedValue = (CachedValue)project.getUserData(CACHED_DART_SDK_KEY)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                DartSdk sdk;
                if (project == null) {
                    DartSdk.$$$reportNull$$$0(6);
                }
                if ((sdk = DartSdk.findDartSdkAmongLibraries(ProjectLibraryTable.getInstance((Project)project).getLibraries())) == null) {
                    return new CachedValueProvider.Result(null, new Object[]{DartProjectComponent.getProjectRootsModificationTracker(project)});
                }
                ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>(3);
                dependencies.add(DartProjectComponent.getProjectRootsModificationTracker(project));
                ContainerUtil.addIfNotNull(dependencies, (Object)LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/version"));
                ContainerUtil.addIfNotNull(dependencies, (Object)LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib/core/core.dart"));
                return new CachedValueProvider.Result((Object)sdk, ArrayUtil.toObjectArray(dependencies));
            }, false);
            project.putUserData(CACHED_DART_SDK_KEY, (Object)cachedValue);
        }
        return (DartSdk)cachedValue.getValue();
    }

    @Nullable
    private static DartSdk findDartSdkAmongLibraries(Library[] libs) {
        for (Library library : libs) {
            if (!DART_SDK_LIB_NAME.equals(library.getName())) continue;
            return DartSdk.getSdkByLibrary(library);
        }
        return null;
    }

    @Nullable
    public static DartSdk getSdkByLibrary(@NotNull Library library) {
        VirtualFile[] roots;
        VirtualFile dartCoreRoot;
        if (library == null) {
            DartSdk.$$$reportNull$$$0(5);
        }
        if ((dartCoreRoot = DartSdkLibraryPresentationProvider.findDartCoreRoot(Arrays.asList(roots = library.getFiles(OrderRootType.CLASSES)))) != null) {
            String homePath = dartCoreRoot.getParent().getParent().getPath();
            String version = StringUtil.notNullize((String)DartSdkUtil.getSdkVersion(homePath), (String)UNKNOWN_VERSION);
            return new DartSdk(homePath, version);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/sdk/DartSdk";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/sdk/DartSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDartSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkByLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDartSdk$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

