/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckboxTreeTable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateChecker;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final String DART_SETTINGS_PAGE_ID = "dart.settings";
    private static final String DART_SETTINGS_PAGE_NAME = DartBundle.message("dart.title", new Object[0]);
    private JPanel myMainPanel;
    private JBCheckBox myEnableDartSupportCheckBox;
    private JPanel mySettingsPanel;
    private ComboboxWithBrowseButton mySdkPathComboWithBrowse;
    private JBLabel myVersionLabel;
    private JBCheckBox myCheckSdkUpdateCheckBox;
    private JBCheckBox myCheckSdkUpdateCheckBoxFake;
    private ComboBox mySdkUpdateChannelCombo;
    private JButton myCheckSdkUpdateButton;
    private ComboboxWithBrowseButton myDartiumPathComboWithBrowse;
    private JButton myDartiumSettingsButton;
    private JBCheckBox myCheckedModeCheckBox;
    private JPanel myModulesPanel;
    private CheckboxTreeTable myModulesCheckboxTreeTable;
    private JBLabel myErrorLabel;
    @NotNull
    private final Project myProject;
    private boolean myInReset;
    private boolean myDartSupportEnabledInitial;
    @Nullable
    private DartSdk mySdkInitial;
    @NotNull
    private final Collection<Module> myModulesWithDartSdkLibAttachedInitial;
    @Nullable
    private WebBrowser myDartiumInitial;
    private ChromeSettings myDartiumSettingsCurrent;

    public DartConfigurable(@NotNull Project project) {
        if (project == null) {
            DartConfigurable.$$$reportNull$$$0(0);
        }
        this.myInReset = false;
        this.$$$setupUI$$$();
        this.myModulesWithDartSdkLibAttachedInitial = new THashSet();
        this.myProject = project;
        this.initEnableDartSupportCheckBox();
        this.initDartSdkAndDartiumControls();
        this.initModulesPanel();
        this.myErrorLabel.setIcon(AllIcons.Actions.Lightning);
    }

    private void initEnableDartSupportCheckBox() {
        this.myEnableDartSupportCheckBox.setText(DartBundle.message("enable.dart.support.for.project.0", this.myProject.getName()));
        this.myEnableDartSupportCheckBox.addActionListener(e -> {
            this.updateControlsEnabledState();
            this.updateErrorLabel();
        });
    }

    private void initDartSdkAndDartiumControls() {
        Computable currentDartiumSettingsRetriever = () -> this.myDartiumSettingsCurrent;
        Computable isResettingControlsComputable = () -> this.myInReset;
        DartSdkUtil.initDartSdkAndDartiumControls(this.myProject, this.mySdkPathComboWithBrowse, this.myVersionLabel, this.myDartiumPathComboWithBrowse, (Computable<ChromeSettings>)currentDartiumSettingsRetriever, this.myDartiumSettingsButton, (Computable<Boolean>)isResettingControlsComputable);
        JTextComponent sdkEditor = (JTextComponent)this.mySdkPathComboWithBrowse.getComboBox().getEditor().getEditorComponent();
        sdkEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String version;
                String sdkHomePath = DartConfigurable.getTextFromCombo(DartConfigurable.this.mySdkPathComboWithBrowse);
                if (!sdkHomePath.isEmpty() && (version = DartSdkUtil.getSdkVersion(sdkHomePath)) != null && (version.contains("-dev.") || version.contains("-edge."))) {
                    DartConfigurable.this.mySdkUpdateChannelCombo.setSelectedItem((Object)DartSdkUpdateOption.StableAndDev);
                }
                DartConfigurable.this.updateControlsEnabledState();
                DartConfigurable.this.updateErrorLabel();
            }
        });
        JTextComponent dartiumEditor = (JTextComponent)this.myDartiumPathComboWithBrowse.getComboBox().getEditor().getEditorComponent();
        dartiumEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DartConfigurable.this.updateErrorLabel();
            }
        });
        this.myCheckSdkUpdateCheckBox.addActionListener(e -> {
            boolean enabled = this.myCheckSdkUpdateCheckBox.isSelected() && this.myCheckSdkUpdateCheckBox.isEnabled();
            this.mySdkUpdateChannelCombo.setEnabled(enabled);
            this.myCheckSdkUpdateButton.setEnabled(enabled);
            if (enabled) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySdkUpdateChannelCombo, true);
            }
        });
        this.mySdkUpdateChannelCombo.setModel(new DefaultComboBoxModel<DartSdkUpdateOption>(DartSdkUpdateOption.OPTIONS_TO_SHOW_IN_COMBO));
        this.mySdkUpdateChannelCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DartSdkUpdateOption>(){

            public void customize(JList list, DartSdkUpdateOption value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableName());
            }
        });
        this.myCheckSdkUpdateButton.addActionListener(e -> {
            Runnable runnable = this::checkSdkUpdate;
            ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(runnable, DartBundle.message("checking.dart.sdk.update", new Object[0]), true, this.myProject, (JComponent)this.myMainPanel);
        });
    }

    private void checkSdkUpdate() {
        String currentSdkVersion = this.myVersionLabel.getText();
        DartSdkUpdateChecker.SdkUpdateInfo sdkUpdateInfo = DartSdkUpdateChecker.getSdkUpdateInfo((DartSdkUpdateOption)((Object)this.mySdkUpdateChannelCombo.getSelectedItem()));
        ApplicationManager.getApplication().invokeLater(() -> {
            if (sdkUpdateInfo == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)DartBundle.message("dart.sdk.update.check.failed", new Object[0]), (String)DartBundle.message("dart.sdk.update.title", new Object[0]));
            } else {
                String message = currentSdkVersion == null || currentSdkVersion.isEmpty() ? DartBundle.message("dart.sdk.0.available.for.download", sdkUpdateInfo.myVersion, sdkUpdateInfo.myDownloadUrl) : (DartSdkUpdateChecker.compareDartSdkVersions(currentSdkVersion, sdkUpdateInfo.myVersion) >= 0 ? DartBundle.message("dart.sdk.0.is.up.to.date", currentSdkVersion) : DartBundle.message("new.dart.sdk.0.available.for.download..dialog", sdkUpdateInfo.myVersion, sdkUpdateInfo.myDownloadUrl));
                Messages.showInfoMessage((Project)this.myProject, (String)message, (String)DartBundle.message("dart.sdk.update.title", new Object[0]));
            }
        }, ModalityState.defaultModalityState(), this.myProject.getDisposed());
    }

    private void initModulesPanel() {
        if (!DartSdkLibUtil.isIdeWithMultipleModuleSupport()) {
            this.myModulesPanel.setVisible(false);
            return;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Arrays.sort(modules, Comparator.comparing(module -> module.getName().toLowerCase(Locale.US)));
        CheckedTreeNode rootNode = new CheckedTreeNode((Object)this.myProject);
        ((DefaultTreeModel)this.myModulesCheckboxTreeTable.getTree().getModel()).setRoot((TreeNode)rootNode);
        this.myModulesCheckboxTreeTable.getTree().setRootVisible(true);
        this.myModulesCheckboxTreeTable.getTree().setShowsRootHandles(false);
        for (Module module2 : modules) {
            rootNode.add((MutableTreeNode)new CheckedTreeNode((Object)module2));
        }
        ((DefaultTreeModel)this.myModulesCheckboxTreeTable.getTree().getModel()).reload((TreeNode)rootNode);
    }

    @NotNull
    public String getId() {
        if (DART_SETTINGS_PAGE_ID == null) {
            DartConfigurable.$$$reportNull$$$0(1);
        }
        return DART_SETTINGS_PAGE_ID;
    }

    @Nls
    public String getDisplayName() {
        return DART_SETTINGS_PAGE_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.dart.settings";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        String dartiumPathInitial;
        boolean flutter;
        String initialSdkHomePath;
        String sdkHomePath = DartConfigurable.getTextFromCombo(this.mySdkPathComboWithBrowse);
        boolean sdkSelected = DartSdkUtil.isDartSdkHome(sdkHomePath);
        if (!(this.myDartSupportEnabledInitial || this.myEnableDartSupportCheckBox.isSelected() && sdkSelected)) {
            return false;
        }
        if (this.myDartSupportEnabledInitial && !this.myEnableDartSupportCheckBox.isSelected()) {
            return true;
        }
        String string = initialSdkHomePath = this.mySdkInitial == null ? "" : this.mySdkInitial.getHomePath();
        if (sdkSelected && !sdkHomePath.equals(initialSdkHomePath)) {
            return true;
        }
        boolean bl = flutter = FlutterUtil.getFlutterRoot(sdkHomePath) != null;
        if (!flutter) {
            DartSdkUpdateOption sdkUpdateOption;
            DartSdkUpdateOption dartSdkUpdateOption = sdkUpdateOption = this.myCheckSdkUpdateCheckBox.isSelected() ? (DartSdkUpdateOption)((Object)this.mySdkUpdateChannelCombo.getSelectedItem()) : DartSdkUpdateOption.DoNotCheck;
            if (sdkUpdateOption != DartSdkUpdateOption.getDartSdkUpdateOption()) {
                return true;
            }
        }
        String dartiumPath = DartConfigurable.getTextFromCombo(this.myDartiumPathComboWithBrowse);
        String string2 = dartiumPathInitial = this.myDartiumInitial == null ? null : this.myDartiumInitial.getPath();
        if (!dartiumPath.isEmpty() && new File(dartiumPath).exists() && !dartiumPath.equals(dartiumPathInitial)) {
            return true;
        }
        if (this.myDartiumInitial != null && !this.myDartiumSettingsCurrent.equals((Object)this.myDartiumInitial.getSpecificSettings())) {
            return true;
        }
        if (DartSdkLibUtil.isIdeWithMultipleModuleSupport()) {
            Module[] selectedModules = (Module[])this.myModulesCheckboxTreeTable.getCheckedNodes(Module.class);
            if (selectedModules.length != this.myModulesWithDartSdkLibAttachedInitial.size()) {
                return true;
            }
            for (Module module : selectedModules) {
                if (this.myModulesWithDartSdkLibAttachedInitial.contains(module)) continue;
                return true;
            }
        } else if (this.myDartSupportEnabledInitial != this.myEnableDartSupportCheckBox.isSelected()) {
            return true;
        }
        return false;
    }

    @NotNull
    private static String getTextFromCombo(@NotNull ComboboxWithBrowseButton combo) {
        if (combo == null) {
            DartConfigurable.$$$reportNull$$$0(2);
        }
        String string = FileUtilRt.toSystemIndependentName((String)combo.getComboBox().getEditor().getItem().toString().trim());
        if (string == null) {
            DartConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void reset() {
        DartSdkUpdateOption sdkUpdateOption;
        BrowserSpecificSettings browserSpecificSettings;
        this.myInReset = true;
        this.mySdkInitial = DartSdk.getDartSdk(this.myProject);
        this.myModulesWithDartSdkLibAttachedInitial.clear();
        if (this.mySdkInitial != null) {
            this.myModulesWithDartSdkLibAttachedInitial.addAll(DartSdkLibUtil.getModulesWithDartSdkEnabled(this.myProject));
        }
        this.myDartSupportEnabledInitial = !this.myModulesWithDartSdkLibAttachedInitial.isEmpty();
        this.myDartiumInitial = DartiumUtil.getDartiumBrowser();
        this.myDartiumSettingsCurrent = new ChromeSettings();
        if (this.myDartiumInitial != null && (browserSpecificSettings = this.myDartiumInitial.getSpecificSettings()) instanceof ChromeSettings) {
            this.myDartiumSettingsCurrent = (ChromeSettings)browserSpecificSettings.clone();
        }
        this.myEnableDartSupportCheckBox.setSelected(this.myDartSupportEnabledInitial);
        String sdkInitialPath = this.mySdkInitial == null ? "" : FileUtilRt.toSystemDependentName((String)this.mySdkInitial.getHomePath());
        this.mySdkPathComboWithBrowse.getComboBox().getEditor().setItem(sdkInitialPath);
        if (!sdkInitialPath.isEmpty()) {
            DartConfigurable.ensureComboModelContainsCurrentItem(this.mySdkPathComboWithBrowse.getComboBox());
        }
        this.myCheckSdkUpdateCheckBox.setSelected((sdkUpdateOption = DartSdkUpdateOption.getDartSdkUpdateOption()) != DartSdkUpdateOption.DoNotCheck);
        this.mySdkUpdateChannelCombo.setSelectedItem((Object)sdkUpdateOption);
        String dartiumInitialPath = this.myDartiumInitial == null ? "" : FileUtilRt.toSystemDependentName((String)StringUtil.notNullize((String)this.myDartiumInitial.getPath()));
        this.myDartiumPathComboWithBrowse.getComboBox().getEditor().setItem(dartiumInitialPath);
        if (!dartiumInitialPath.isEmpty()) {
            DartConfigurable.ensureComboModelContainsCurrentItem(this.myDartiumPathComboWithBrowse.getComboBox());
        }
        this.myCheckedModeCheckBox.setVisible(false);
        DartiumUtil.setCheckedMode(this.myDartiumSettingsCurrent.getEnvironmentVariables(), true);
        if (DartSdkLibUtil.isIdeWithMultipleModuleSupport()) {
            CheckedTreeNode rootNode = (CheckedTreeNode)this.myModulesCheckboxTreeTable.getTree().getModel().getRoot();
            rootNode.setChecked(false);
            Enumeration children = rootNode.children();
            while (children.hasMoreElements()) {
                CheckedTreeNode node = (CheckedTreeNode)children.nextElement();
                node.setChecked(this.myModulesWithDartSdkLibAttachedInitial.contains((Module)node.getUserObject()));
            }
        }
        this.updateControlsEnabledState();
        this.updateErrorLabel();
        this.myInReset = false;
    }

    private static void ensureComboModelContainsCurrentItem(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            DartConfigurable.$$$reportNull$$$0(4);
        }
        Object currentItem = comboBox.getEditor().getItem();
        boolean contains = false;
        for (int i = 0; i < comboBox.getModel().getSize(); ++i) {
            if (!currentItem.equals(comboBox.getModel().getElementAt(i))) continue;
            contains = true;
            break;
        }
        if (!contains) {
            ((DefaultComboBoxModel)comboBox.getModel()).insertElementAt(currentItem, 0);
            comboBox.setSelectedItem(currentItem);
            comboBox.getEditor().setItem(currentItem);
        }
    }

    public void apply() throws ConfigurationException {
        Runnable runnable = () -> {
            if (this.myEnableDartSupportCheckBox.isSelected()) {
                boolean flutter;
                String sdkHomePath = DartConfigurable.getTextFromCombo(this.mySdkPathComboWithBrowse);
                if (DartSdkUtil.isDartSdkHome(sdkHomePath)) {
                    DartSdkUtil.updateKnownSdkPaths(this.myProject, sdkHomePath);
                    DartSdkLibUtil.ensureDartSdkConfigured(this.myProject, sdkHomePath);
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
                    Module[] modules = DartSdkLibUtil.isIdeWithMultipleModuleSupport() ? (Module[])this.myModulesCheckboxTreeTable.getCheckedNodes(Module.class) : ModuleManager.getInstance((Project)this.myProject).getModules();
                    DartSdkLibUtil.enableDartSdkForSpecifiedModulesAndDisableForOthers(this.myProject, modules);
                }
                boolean bl = flutter = FlutterUtil.getFlutterRoot(sdkHomePath) != null;
                if (!flutter) {
                    DartSdkUpdateOption sdkUpdateOption = this.myCheckSdkUpdateCheckBox.isSelected() ? (DartSdkUpdateOption)((Object)((Object)this.mySdkUpdateChannelCombo.getSelectedItem())) : DartSdkUpdateOption.DoNotCheck;
                    DartSdkUpdateOption.setDartSdkUpdateOption(sdkUpdateOption);
                }
                String dartiumPath = DartConfigurable.getTextFromCombo(this.myDartiumPathComboWithBrowse);
                DartiumUtil.applyDartiumSettings(dartiumPath, this.myDartiumSettingsCurrent);
            } else if (this.myModulesWithDartSdkLibAttachedInitial.size() > 0 && this.mySdkInitial != null) {
                DartSdkLibUtil.disableDartSdk(this.myModulesWithDartSdkLibAttachedInitial);
            }
        };
        ApplicationManager.getApplication().runWriteAction(runnable);
        this.reset();
    }

    public void disposeUIResources() {
        this.mySdkInitial = null;
        this.myModulesWithDartSdkLibAttachedInitial.clear();
        this.myDartiumInitial = null;
        this.myDartiumSettingsCurrent = null;
    }

    private void updateControlsEnabledState() {
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)this.myEnableDartSupportCheckBox.isSelected(), (boolean)true);
        boolean flutter = FlutterUtil.getFlutterRoot(DartConfigurable.getTextFromCombo(this.mySdkPathComboWithBrowse)) != null;
        this.myCheckSdkUpdateCheckBox.setVisible(!flutter);
        boolean enabled = this.myCheckSdkUpdateCheckBox.isVisible() && this.myCheckSdkUpdateCheckBox.isEnabled() && this.myCheckSdkUpdateCheckBox.isSelected();
        this.mySdkUpdateChannelCombo.setEnabled(enabled);
        this.myCheckSdkUpdateButton.setEnabled(enabled);
        this.myCheckSdkUpdateCheckBoxFake.setVisible(flutter);
        this.myCheckSdkUpdateCheckBoxFake.setEnabled(false);
    }

    private void updateErrorLabel() {
        String message = this.getErrorMessage();
        this.myErrorLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'><left>" + message + "</left></font>")));
        this.myErrorLabel.setVisible(message != null);
    }

    @Nullable
    private String getErrorMessage() {
        Module[] modules;
        if (!this.myEnableDartSupportCheckBox.isSelected()) {
            return null;
        }
        String message = DartSdkUtil.getErrorMessageIfWrongSdkRootPath(DartConfigurable.getTextFromCombo(this.mySdkPathComboWithBrowse));
        if (message != null) {
            return message;
        }
        message = DartiumUtil.getErrorMessageIfWrongDartiumPath(DartConfigurable.getTextFromCombo(this.myDartiumPathComboWithBrowse));
        if (message != null) {
            return message;
        }
        if (DartSdkLibUtil.isIdeWithMultipleModuleSupport() && (modules = (Module[])this.myModulesCheckboxTreeTable.getCheckedNodes(Module.class)).length == 0) {
            return DartBundle.message("warning.no.modules.selected.dart.support.will.be.disabled", new Object[0]);
        }
        return null;
    }

    private void createUIComponents() {
        this.mySdkPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
        this.myDartiumPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
        CheckboxTree.CheckboxTreeCellRenderer checkboxTreeCellRenderer = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                boolean dartSupportEnabled = DartConfigurable.this.myEnableDartSupportCheckBox.isSelected();
                CheckedTreeNode node = (CheckedTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof Project) {
                    if (!dartSupportEnabled) {
                        this.getCheckbox().setEnabled(false);
                    }
                    this.getTextRenderer().setEnabled(dartSupportEnabled);
                    this.getTextRenderer().append(DartBundle.message("project.0", ((Project)userObject).getName()));
                } else if (userObject instanceof Module) {
                    this.getCheckbox().setEnabled(dartSupportEnabled);
                    this.getTextRenderer().setEnabled(dartSupportEnabled);
                    Icon moduleIcon = ModuleType.get((Module)((Module)userObject)).getIcon();
                    this.getTextRenderer().setIcon(dartSupportEnabled ? moduleIcon : IconLoader.getDisabledIcon((Icon)moduleIcon));
                    this.getTextRenderer().append(((Module)userObject).getName());
                }
            }
        };
        this.myModulesCheckboxTreeTable = new CheckboxTreeTable(null, checkboxTreeCellRenderer, new ColumnInfo[]{new TreeColumnInfo("")});
        this.myModulesCheckboxTreeTable.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                DartConfigurable.this.updateErrorLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/sdk/DartConfigurable$5", "nodeStateChanged"));
            }
        });
        this.myModulesCheckboxTreeTable.getTree().addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event);
            }
        });
    }

    public static void openDartSettings(@NotNull Project project) {
        if (project == null) {
            DartConfigurable.$$$reportNull$$$0(5);
        }
        ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)DART_SETTINGS_PAGE_ID, (String)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/sdk/DartConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/sdk/DartConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromCombo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureComboModelContainsCurrentItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openDartSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JButton jButton;
        JButton jButton2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableDartSupportCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("enable.dart.support.for.project.0"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkPathComboWithBrowse;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myVersionLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("1.0");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myModulesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Enable Dart support for the following modules:");
        jBLabel3.setDisplayedMnemonic('N');
        jBLabel3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckboxTreeTable checkboxTreeTable = this.myModulesCheckboxTreeTable;
        checkboxTreeTable.setPreferredScrollableViewportSize(new Dimension(-1, -1));
        jBScrollPane.setViewportView((Component)checkboxTreeTable);
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        this.myCheckedModeCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jBCheckBox3.setText("Start Dartium in checked mode ");
        jBCheckBox3.setMnemonic('C');
        jBCheckBox3.setDisplayedMnemonicIndex(17);
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(4, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dart.sdk.path.label"));
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("version.label"));
        jPanel6.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dartium.path.label"));
        jPanel7.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySdkUpdateChannelCombo = comboBox = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Stable channel");
        defaultComboBoxModel.addElement("Stable and Dev channels");
        comboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myDartiumPathComboWithBrowse;
        jPanel2.add((Component)comboboxWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myDartiumSettingsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dartium.settings.button"));
        jPanel2.add((Component)jButton2, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCheckSdkUpdateButton = jButton = new JButton();
        jButton.setText("Check now");
        jButton.setMnemonic('W');
        jButton.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.myCheckSdkUpdateCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jBCheckBox2.setText("Check SDK update:");
        jBCheckBox2.setMnemonic('U');
        jBCheckBox2.setDisplayedMnemonicIndex(10);
        jPanel8.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCheckSdkUpdateCheckBoxFake = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(false);
        jBCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jBCheckBox.setText("Check SDK update:");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(10);
        jPanel8.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("Error: Path to the Dart SDK is not specified.");
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel3.setLabelFor((Component)checkboxTreeTable);
        jBLabel4.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel6.setLabelFor((Component)comboboxWithBrowseButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

