/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartLibraryId;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartSuperCallOrFieldInitializer;
import com.jetbrains.lang.dart.psi.DartSuperExpression;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolver
implements ResolveCache.AbstractResolver<DartReference, List<? extends PsiElement>> {
    public static final DartResolver INSTANCE = new DartResolver();

    @Nullable
    public List<? extends PsiElement> resolve(@NotNull DartReference reference, boolean incompleteCode) {
        List<DartExpression> expressions;
        PsiElement parent;
        int refLength;
        int refOffset;
        PsiFile refPsiFile;
        DartServerData.DartNavigationRegion region;
        if (reference == null) {
            DartResolver.$$$reportNull$$$0(0);
        }
        if ((region = DartResolver.findRegion(refPsiFile = (reference = DartResolver.replaceQualifiedReferenceWithLast(reference)).getContainingFile(), refOffset = reference.getTextRange().getStartOffset(), refLength = reference.getTextRange().getLength())) == null && reference instanceof DartLibraryId && (parent = reference.getParent()) instanceof DartPartOfStatement) {
            refOffset = parent.getTextRange().getStartOffset();
            refLength = reference.getTextRange().getEndOffset() - refOffset;
            region = DartResolver.findRegion(refPsiFile, refOffset, refLength);
        }
        if (region == null && (reference instanceof DartSuperExpression || reference instanceof DartReferenceExpression) && (parent = reference.getParent()) instanceof DartSuperCallOrFieldInitializer && (expressions = ((DartSuperCallOrFieldInitializer)parent).getExpressionList()).size() == 2 && expressions.get(0) instanceof DartSuperExpression && expressions.get(1) instanceof DartReferenceExpression) {
            refOffset = expressions.get(0).getTextRange().getStartOffset();
            refLength = expressions.get(1).getTextRange().getEndOffset() - refOffset;
            region = DartResolver.findRegion(refPsiFile, refOffset, refLength);
        }
        return region != null ? DartResolver.getTargetElements(reference.getProject(), region) : null;
    }

    @NotNull
    public static List<? extends PsiElement> getTargetElements(@NotNull Project project, @NotNull DartServerData.DartNavigationRegion region) {
        if (project == null) {
            DartResolver.$$$reportNull$$$0(1);
        }
        if (region == null) {
            DartResolver.$$$reportNull$$$0(2);
        }
        SmartList result = new SmartList();
        for (DartServerData.DartNavigationTarget target : region.getTargets()) {
            PsiElement targetElement = DartResolver.getElementForNavigationTarget(project, target);
            if (targetElement == null) continue;
            result.add(targetElement);
        }
        SmartList smartList = result;
        if (smartList == null) {
            DartResolver.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    private static DartReference replaceQualifiedReferenceWithLast(@NotNull DartReference reference) {
        PsiElement lastChild;
        if (reference == null) {
            DartResolver.$$$reportNull$$$0(4);
        }
        if ((lastChild = reference.getLastChild()) instanceof DartReference) {
            reference = (DartReference)lastChild;
        }
        DartReference dartReference = reference;
        if (dartReference == null) {
            DartResolver.$$$reportNull$$$0(5);
        }
        return dartReference;
    }

    @Nullable
    public static DartServerData.DartNavigationRegion findRegion(PsiFile refPsiFile, int refOffset, int refLength) {
        VirtualFile refVirtualFile = DartResolveUtil.getRealVirtualFile(refPsiFile);
        if (refVirtualFile != null) {
            List<DartServerData.DartNavigationRegion> regions = DartAnalysisServerService.getInstance(refPsiFile.getProject()).getNavigation(refVirtualFile);
            return DartResolver.findRegion(regions, refOffset, refLength);
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementForNavigationTarget(Project project, DartServerData.DartNavigationTarget target) {
        String targetPath = target.getFile();
        PsiFile file = DartResolver.findPsiFile(project, targetPath);
        if (file != null) {
            int targetOffset = target.getOffset(project, file.getVirtualFile());
            PsiElement elementAt = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)targetOffset, DartComponentName.class, (boolean)false);
            if (elementAt == null) {
                elementAt = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)targetOffset, DartLibraryNameElement.class, (boolean)false);
            }
            return elementAt;
        }
        return null;
    }

    @Nullable
    public static PsiFile findPsiFile(@NotNull Project project, @NotNull String path) {
        VirtualFile virtualFile;
        if (project == null) {
            DartResolver.$$$reportNull$$$0(6);
        }
        if (path == null) {
            DartResolver.$$$reportNull$$$0(7);
        }
        if ((virtualFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static DartServerData.DartNavigationRegion findRegion(@NotNull List<DartServerData.DartNavigationRegion> regions, int offset, int length) {
        if (regions == null) {
            DartResolver.$$$reportNull$$$0(8);
        }
        int low = 0;
        int high = regions.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DartServerData.DartNavigationRegion midVal = regions.get(mid);
            int cmp = midVal.getOffset() - offset;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (midVal.getLength() == length) {
                return midVal;
            }
            return null;
        }
        return null;
    }

    public static void processRegionsInRange(@NotNull List<DartServerData.DartNavigationRegion> regions, @NotNull TextRange range, @NotNull Consumer<DartServerData.DartNavigationRegion> processor) {
        if (regions == null) {
            DartResolver.$$$reportNull$$$0(9);
        }
        if (range == null) {
            DartResolver.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            DartResolver.$$$reportNull$$$0(11);
        }
        if (regions.isEmpty()) {
            return;
        }
        int low = 0;
        int high = regions.size() - 1;
        while (low < high) {
            int mid = low + high >>> 1;
            DartServerData.DartNavigationRegion midVal = regions.get(mid);
            int cmp = midVal.getOffset() - range.getStartOffset();
            if (cmp < 0) {
                low = Math.min(high, mid + 1);
                continue;
            }
            high = Math.max(low, mid - 1);
        }
        assert (low == high) : regions.size() + "," + low + "," + high;
        int i = low;
        DartServerData.DartNavigationRegion region = regions.get(i);
        if (region.getOffset() < range.getStartOffset()) {
            if (++i < regions.size()) {
                region = regions.get(i);
            } else {
                return;
            }
        }
        while (region.getOffset() + region.getLength() <= range.getEndOffset()) {
            processor.consume((Object)region);
            if (++i < regions.size()) {
                region = regions.get(i);
                continue;
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/resolve/DartResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/resolve/DartResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceQualifiedReferenceWithLast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElements";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceQualifiedReferenceWithLast";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRegion";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRegionsInRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

