/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(1);
        }
        return DartResolveScopeProvider.getDartScope(project, file, false);
    }

    @Nullable
    public static GlobalSearchScope getDartScope(@NotNull Project project, @NotNull VirtualFile file, boolean strict) {
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (fileIndex.isInLibraryClasses(file) && !fileIndex.isInContent(file)) {
            if (sdk != null && file.getPath().startsWith(sdk.getHomePath() + "/")) {
                return DartResolveScopeProvider.getDartSdkResolveScope(project);
            }
            return DartResolveScopeProvider.getLibraryAndSdkScope(project, file, sdk);
        }
        Module module = fileIndex.getModuleForFile(file);
        if (module == null) {
            return null;
        }
        VirtualFile contextSubdir = null;
        for (VirtualFile dir = file.getParent(); dir != null && fileIndex.isInContent(dir); dir = dir.getParent()) {
            VirtualFile pubspecFile = dir.findChild("pubspec.yaml");
            if (pubspecFile != null) {
                boolean inPackages = contextSubdir != null && "packages".equals(contextSubdir.getName());
                return DartResolveScopeProvider.getDartResolveScope(module, pubspecFile, (VirtualFile)(strict || inPackages ? contextSubdir : null));
            }
            contextSubdir = dir;
        }
        return module.getModuleContentWithDependenciesScope().union((SearchScope)module.getModuleWithLibrariesScope());
    }

    @Nullable
    private static GlobalSearchScope getDartSdkResolveScope(@NotNull Project project) {
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Library library;
            if (project == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(21);
            }
            LibraryScope scope = (library = ProjectLibraryTable.getInstance((Project)project).getLibraryByName("Dart SDK")) == null ? null : new LibraryScope(project, library);
            return new CachedValueProvider.Result((Object)scope, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    private static GlobalSearchScope getLibraryAndSdkScope(@NotNull Project project, @NotNull VirtualFile file, @Nullable DartSdk sdk) {
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(6);
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(19);
            }
            if (file == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(20);
            }
            GlobalSearchScope sdkScope = sdk == null ? null : DartResolveScopeProvider.getDartSdkResolveScope(project);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            THashSet roots = new THashSet();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(file)) {
                Collections.addAll(roots, orderEntry.getFiles(OrderRootType.CLASSES));
            }
            DartLibraryScope libraryScope = new DartLibraryScope(project, (Set<VirtualFile>)roots);
            DartLibraryScope scope = sdkScope != null ? sdkScope.union((SearchScope)libraryScope) : libraryScope;
            return new CachedValueProvider.Result((Object)scope, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    @Nullable
    private static GlobalSearchScope getDartResolveScope(@NotNull Module module, @NotNull VirtualFile pubspecFile, @Nullable VirtualFile contextSubdir) {
        PsiDirectory dataHolder;
        if (module == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(7);
        }
        if (pubspecFile == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(8);
        }
        Project project = module.getProject();
        Object object = dataHolder = contextSubdir != null ? PsiManager.getInstance((Project)project).findDirectory(contextSubdir) : PsiManager.getInstance((Project)project).findFile(pubspecFile);
        if (dataHolder == null) {
            return null;
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)dataHolder, () -> {
            if (module == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(17);
            }
            if (pubspecFile == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(18);
            }
            Collection<VirtualFile> pathPackageRoots = DartResolveScopeProvider.getPathPackageRoots(module.getProject(), pubspecFile);
            VirtualFile dartRoot = pubspecFile.getParent();
            GlobalSearchScope scope = contextSubdir == null || "test".equals(contextSubdir.getName()) ? DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, dartRoot) : ("lib".equals(contextSubdir.getName()) || "packages".equals(contextSubdir.getName()) ? DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, dartRoot.findChild("lib"), dartRoot.findChild("packages")) : DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, contextSubdir, dartRoot.findChild("lib"), dartRoot.findChild("packages")));
            GlobalSearchScope scopeWithLibs = scope.intersectWith(GlobalSearchScope.projectScope((Project)project)).union((SearchScope)DartResolveScopeProvider.getModuleLibrariesClassesScope(module));
            return new CachedValueProvider.Result((Object)scopeWithLibs, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static Collection<VirtualFile> getPathPackageRoots(@NotNull Project project, @NotNull VirtualFile pubspecFile) {
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(9);
        }
        if (pubspecFile == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(10);
        }
        SmartList result = new SmartList();
        PubspecYamlUtil.processInProjectPathPackagesRecursively(project, pubspecFile, (PairConsumer<String, VirtualFile>)((PairConsumer)(arg_0, arg_1) -> DartResolveScopeProvider.lambda$getPathPackageRoots$3((Collection)result, arg_0, arg_1)));
        return result;
    }

    @NotNull
    private static GlobalSearchScope createDirectoriesScope(@NotNull Project project, @NotNull Collection<VirtualFile> pathPackageRoots, VirtualFile ... dirs) {
        if (project == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(11);
        }
        if (pathPackageRoots == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(12);
        }
        if (dirs == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(13);
        }
        GlobalSearchScope scope = null;
        for (VirtualFile dir : dirs) {
            if (dir == null || !dir.isDirectory()) continue;
            scope = scope == null ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)dir, (boolean)true) : scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)dir, (boolean)true));
        }
        assert (scope != null);
        for (VirtualFile packageRoot : pathPackageRoots) {
            scope = scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)packageRoot, (boolean)true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope getModuleLibrariesClassesScope(@NotNull Module module) {
        if (module == null) {
            DartResolveScopeProvider.$$$reportNull$$$0(15);
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                DartResolveScopeProvider.$$$reportNull$$$0(16);
            }
            THashSet roots = new THashSet();
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry)) continue;
                ContainerUtil.addAll((Collection)roots, (Object[])((LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES));
            }
            return new CachedValueProvider.Result((Object)new DartLibraryScope(module.getProject(), (Set<VirtualFile>)roots), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void lambda$getPathPackageRoots$3(Collection result, String packageName, VirtualFile packageDir) {
        result.add(packageDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPackageRoots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoriesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDartScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDartSdkResolveScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryAndSdkScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDartResolveScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathPackageRoots";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoriesScope";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModuleLibrariesClassesScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModuleLibrariesClassesScope$4";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDartResolveScope$2";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLibraryAndSdkScope$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDartSdkResolveScope$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartLibraryScope
    extends LibraryScopeBase {
        public DartLibraryScope(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
            if (project == null) {
                DartLibraryScope.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                DartLibraryScope.$$$reportNull$$$0(1);
            }
            super(project, roots.toArray(new VirtualFile[roots.size()]), VirtualFile.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider$DartLibraryScope";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

