/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetKt;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import icons.DartIcons;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

final class PubServerService
extends NetService {
    private static final Logger LOG = Logger.getInstance((String)PubServerService.class.getName());
    private static final String PUB_SERVE = "Pub Serve";
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Pub Serve", (String)"Pub Serve", (boolean)false);
    private volatile VirtualFile firstServedDir;
    private final ConcurrentMap<Channel, ClientInfo> serverToClientChannel;
    private final ChannelRegistrar serverChannelRegistrar;
    private final ConcurrentMap<VirtualFile, ServerInfo> servedDirToSocketAddress;

    public PubServerService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        if (project == null) {
            PubServerService.$$$reportNull$$$0(0);
        }
        if (consoleManager == null) {
            PubServerService.$$$reportNull$$$0(1);
        }
        super(project, consoleManager);
        this.serverToClientChannel = ContainerUtil.newConcurrentMap();
        this.serverChannelRegistrar = new ChannelRegistrar();
        this.servedDirToSocketAddress = ContainerUtil.newConcurrentMap();
        NettyUtil.nioClientBootstrap().handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{PubServerService.this.serverChannelRegistrar, new HttpClientCodec()});
                channel.pipeline().addLast(new ChannelHandler[]{new PubServeChannelHandler(), ChannelExceptionHandler.getInstance()});
            }
        });
    }

    @Nullable
    private ServerInfo getServerInfo(@NotNull Channel channel) {
        if (channel == null) {
            PubServerService.$$$reportNull$$$0(2);
        }
        for (ServerInfo serverInstanceInfo : this.servedDirToSocketAddress.values()) {
            if (!channel.remoteAddress().equals(serverInstanceInfo.address)) continue;
            return serverInstanceInfo;
        }
        return null;
    }

    @NotNull
    protected String getConsoleToolWindowId() {
        if (PUB_SERVE == null) {
            PubServerService.$$$reportNull$$$0(3);
        }
        return PUB_SERVE;
    }

    @NotNull
    protected Icon getConsoleToolWindowIcon() {
        Icon icon = DartIcons.Dart_13;
        if (icon == null) {
            PubServerService.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Dart.stop.pub.server")});
        if (defaultActionGroup == null) {
            PubServerService.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        if (consoleBuilder == null) {
            PubServerService.$$$reportNull$$$0(6);
        }
        consoleBuilder.addFilter((Filter)new DartConsoleFilter(this.getProject(), this.firstServedDir));
        consoleBuilder.addFilter((Filter)new DartRelativePathsConsoleFilter(this.getProject(), this.firstServedDir.getParent().getPath()));
        consoleBuilder.addFilter((Filter)new UrlFilter());
    }

    public boolean isPubServerProcessAlive() {
        return this.getProcessHandler().has() && !((OSProcessHandler)this.getProcessHandler().getResult()).isProcessTerminated();
    }

    public void sendToPubServer(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull VirtualFile servedDir, @NotNull String pathForPubServer) {
        if (clientChannel == null) {
            PubServerService.$$$reportNull$$$0(7);
        }
        if (clientRequest == null) {
            PubServerService.$$$reportNull$$$0(8);
        }
        if (extraHeaders == null) {
            PubServerService.$$$reportNull$$$0(9);
        }
        if (servedDir == null) {
            PubServerService.$$$reportNull$$$0(10);
        }
        if (pathForPubServer == null) {
            PubServerService.$$$reportNull$$$0(11);
        }
        clientRequest.retain();
        if (this.getProcessHandler().has()) {
            this.sendToServer(servedDir, clientChannel, clientRequest, extraHeaders, pathForPubServer);
        } else {
            this.firstServedDir = servedDir;
            this.getProcessHandler().get().done(osProcessHandler -> {
                if (servedDir == null) {
                    PubServerService.$$$reportNull$$$0(27);
                }
                if (clientChannel == null) {
                    PubServerService.$$$reportNull$$$0(28);
                }
                if (clientRequest == null) {
                    PubServerService.$$$reportNull$$$0(29);
                }
                if (extraHeaders == null) {
                    PubServerService.$$$reportNull$$$0(30);
                }
                if (pathForPubServer == null) {
                    PubServerService.$$$reportNull$$$0(31);
                }
                this.sendToServer(servedDir, clientChannel, clientRequest, extraHeaders, pathForPubServer);
            }).rejected(throwable -> {
                if (clientChannel == null) {
                    PubServerService.$$$reportNull$$$0(25);
                }
                if (extraHeaders == null) {
                    PubServerService.$$$reportNull$$$0(26);
                }
                PubServerService.sendBadGateway(clientChannel, extraHeaders);
            });
        }
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(@NotNull Project project, int port) throws ExecutionException {
        DartSdk dartSdk;
        if (project == null) {
            PubServerService.$$$reportNull$$$0(12);
        }
        if ((dartSdk = DartSdk.getDartSdk(project)) == null) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(this.firstServedDir.getParent().getPath());
        commandLine.setExePath(FileUtil.toSystemDependentName((String)DartSdkUtil.getPubPath(dartSdk)));
        commandLine.addParameter("serve");
        commandLine.addParameter(this.firstServedDir.getName());
        commandLine.addParameter("--port=" + String.valueOf(port));
        commandLine.withEnvironment("PUB_ENVIRONMENT", DartPubActionBase.getPubEnvValue());
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        processHandler.addProcessListener((ProcessListener)new PubServeOutputListener(project));
        return processHandler;
    }

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler, @NotNull Consumer<String> errorOutputConsumer) {
        InetSocketAddress firstPubServerAddress;
        ServerInfo old;
        if (promise == null) {
            PubServerService.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            PubServerService.$$$reportNull$$$0(14);
        }
        if (errorOutputConsumer == null) {
            PubServerService.$$$reportNull$$$0(15);
        }
        LOG.assertTrue((old = this.servedDirToSocketAddress.put(this.firstServedDir, new ServerInfo(firstPubServerAddress = NetKt.loopbackSocketAddress((int)port)))) == null);
        super.connectToProcess(promise, port, processHandler, errorOutputConsumer);
    }

    static void sendBadGateway(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        if (channel == null) {
            PubServerService.$$$reportNull$$$0(16);
        }
        if (extraHeaders == null) {
            PubServerService.$$$reportNull$$$0(17);
        }
        if (channel.isActive()) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_GATEWAY, (Channel)channel, null, null, (HttpHeaders)extraHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcessConnections() {
        ClientInfo[] list;
        this.servedDirToSocketAddress.clear();
        try {
            Collection clientInfos = this.serverToClientChannel.values();
            list = clientInfos.toArray(new ClientInfo[0]);
            for (ServerInfo serverInstanceInfo : this.servedDirToSocketAddress.values()) {
                serverInstanceInfo.freeServerChannels.clear();
            }
            this.serverToClientChannel.clear();
        }
        finally {
            this.serverChannelRegistrar.close();
        }
        for (ClientInfo info : list) {
            try {
                PubServerService.sendBadGateway(info.channel, info.extraHeaders);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void sendToServer(@NotNull VirtualFile servedDir, @NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull String pathToPubServe) {
        if (servedDir == null) {
            PubServerService.$$$reportNull$$$0(18);
        }
        if (clientChannel == null) {
            PubServerService.$$$reportNull$$$0(19);
        }
        if (clientRequest == null) {
            PubServerService.$$$reportNull$$$0(20);
        }
        if (extraHeaders == null) {
            PubServerService.$$$reportNull$$$0(21);
        }
        if (pathToPubServe == null) {
            PubServerService.$$$reportNull$$$0(22);
        }
        ServerInfo serverInstanceInfo = (ServerInfo)this.servedDirToSocketAddress.get(servedDir);
        InetSocketAddress address = serverInstanceInfo.address;
        HttpResponse response = Responses.response((HttpResponseStatus)HttpResponseStatus.FOUND, (HttpRequest)clientRequest, null);
        Map parameters = new QueryStringDecoder(clientRequest.uri()).parameters();
        parameters.remove("_ijt");
        QueryStringEncoder encoder = new QueryStringEncoder("http://" + address.getHostString() + ":" + address.getPort() + pathToPubServe);
        for (Map.Entry entry : parameters.entrySet()) {
            for (String value : (List)entry.getValue()) {
                encoder.addParam((String)entry.getKey(), value);
            }
        }
        response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)encoder.toString());
        Responses.send((HttpResponse)response, (Channel)clientChannel, (HttpRequest)clientRequest, (HttpHeaders)extraHeaders);
    }

    @NotNull
    Collection<String> getAllPubServeAuthorities() {
        SmartList result = new SmartList();
        for (ServerInfo serverInfo : this.servedDirToSocketAddress.values()) {
            if (serverInfo.address == null) continue;
            result.add(serverInfo.address.getHostString() + ":" + serverInfo.address.getPort());
        }
        SmartList smartList = result;
        if (smartList == null) {
            PubServerService.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    @Nullable
    String getPubServeAuthority(@NotNull VirtualFile dir) {
        ServerInfo serverInfo;
        if (dir == null) {
            PubServerService.$$$reportNull$$$0(24);
        }
        InetSocketAddress address = (serverInfo = (ServerInfo)this.servedDirToSocketAddress.get(dir)) == null ? null : serverInfo.address;
        return address != null ? address.getHostString() + ":" + address.getPort() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleManager";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/pubServer/PubServerService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 7: 
            case 19: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientChannel";
                break;
            }
            case 8: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientRequest";
                break;
            }
            case 9: 
            case 17: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraHeaders";
                break;
            }
            case 10: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servedDir";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathForPubServer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutputConsumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToPubServe";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/pubServer/PubServerService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleToolWindowId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleToolWindowIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleToolWindowActions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPubServeAuthorities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServerInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureConsole";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sendToPubServer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "connectToProcess";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendBadGateway";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sendToServer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPubServeAuthority";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendToPubServer$1";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendToPubServer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PubServeOutputListener
    extends ProcessAdapter {
        private final Project myProject;
        private boolean myNotificationAboutErrors;
        private Notification myNotification;

        public PubServeOutputListener(Project project) {
            this.myProject = project;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                PubServeOutputListener.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                PubServeOutputListener.$$$reportNull$$$0(1);
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                boolean error = event.getText().toLowerCase(Locale.US).contains("error");
                ApplicationManager.getApplication().invokeLater(() -> this.showNotificationIfNeeded(error));
            }
        }

        private void showNotificationIfNeeded(boolean isError) {
            if (ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(PubServerService.PUB_SERVE).isVisible()) {
                return;
            }
            if (this.myNotification != null && !this.myNotification.isExpired()) {
                Balloon balloon1 = this.myNotification.getBalloon();
                Balloon balloon2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindowBalloon(PubServerService.PUB_SERVE);
                if (!(balloon1 == null && balloon2 == null || !this.myNotificationAboutErrors && isError)) {
                    return;
                }
                this.myNotification.expire();
            }
            this.myNotificationAboutErrors = isError;
            String message = DartBundle.message(this.myNotificationAboutErrors ? "pub.serve.output.contains.errors" : "pub.serve.output.contains.warnings", new Object[0]);
            this.myNotification = NOTIFICATION_GROUP.createNotification("", message, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    ToolWindowManager.getInstance((Project)myProject).getToolWindow(PubServerService.PUB_SERVE).activate(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeOutputListener$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myNotification.notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeOutputListener";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ChannelHandler.Sharable
    private class PubServeChannelHandler
    extends SimpleChannelInboundHandlerAdapter<HttpObject> {
        public PubServeChannelHandler() {
            super(false);
        }

        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull HttpObject message) {
            if (context == null) {
                PubServeChannelHandler.$$$reportNull$$$0(0);
            }
            if (message == null) {
                PubServeChannelHandler.$$$reportNull$$$0(1);
            }
            Channel serverChannel = context.channel();
            ClientInfo clientInfo = (ClientInfo)PubServerService.this.serverToClientChannel.get(serverChannel);
            if (clientInfo == null || !clientInfo.channel.isActive()) {
                PubServerService.this.serverToClientChannel.remove(serverChannel);
                serverChannel.close();
                if (message instanceof ReferenceCounted) {
                    ((ReferenceCounted)message).release();
                }
            } else {
                if (message instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)message;
                    HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
                    response.headers().add(clientInfo.extraHeaders);
                }
                if (message instanceof LastHttpContent) {
                    PubServerService.this.serverToClientChannel.remove(serverChannel);
                    ServerInfo serverInfo = PubServerService.this.getServerInfo(serverChannel);
                    if (serverInfo != null) {
                        serverChannel.close();
                    }
                }
                clientInfo.channel.writeAndFlush((Object)message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeChannelHandler";
            objectArray[2] = "messageReceived";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClientInfo {
        private final Channel channel;
        private final HttpHeaders extraHeaders;

        private ClientInfo(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
            if (channel == null) {
                ClientInfo.$$$reportNull$$$0(0);
            }
            if (extraHeaders == null) {
                ClientInfo.$$$reportNull$$$0(1);
            }
            this.channel = channel;
            this.extraHeaders = extraHeaders;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "channel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extraHeaders";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/pubServer/PubServerService$ClientInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServerInfo {
        private final InetSocketAddress address;
        private final Deque<Channel> freeServerChannels = PlatformDependent.newConcurrentDeque();

        private ServerInfo(InetSocketAddress address) {
            this.address = address;
        }
    }
}

