/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.google.common.net.UrlEscapers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.pubServer.PubServerPathHandler;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a$\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u001a&\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "escapeUrl", "", "path", "getServedDirAndPathForPubServer", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Dart"})
public final class PubServerPathHandlerKt {
    private static final Logger LOG;
    private static final PathQuery pathQuery;

    private static final Pair<VirtualFile, String> getServedDirAndPathForPubServer(Project project, String path) {
        Pair pair;
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        VirtualFile file = WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)pathToFileManager, (String)path, (boolean)false, (PathQuery)pathQuery, (int)2, null);
        if (file != null && ProjectFileIndex.getInstance((Project)project).isInContent(file)) {
            return PubServerPathHandlerKt.getServedDirAndPathForPubServer(project, file);
        }
        VirtualFile servedDir = null;
        String pubServePath = null;
        int slashIndex = -1;
        while ((slashIndex = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(slashIndex + 1), (boolean)false, (int)4, null)) >= 0) {
            String string;
            String string2;
            VirtualFile parentDir;
            String pathPart;
            String string3 = path;
            int n = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n, slashIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            VirtualFile dir = WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)pathToFileManager, (String)pathPart, (boolean)false, (PathQuery)pathQuery, (int)2, null);
            if (dir == null || !dir.isDirectory() || (parentDir = dir.getParent()) == null || parentDir.findChild("pubspec.yaml") == null) continue;
            CharSequence name = dir.getNameSequence();
            if (StringUtil.equals((CharSequence)name, (CharSequence)"build") || StringUtil.equals((CharSequence)name, (CharSequence)"lib") || StringUtil.equals((CharSequence)name, (CharSequence)"packages")) {
                return null;
            }
            servedDir = dir;
            String string5 = string2 = path;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(slashIndex), (String)"(this as java.lang.String).substring(startIndex)");
            pubServePath = string;
        }
        VirtualFile virtualFile = servedDir;
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            String string = pubServePath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            pair = Pair.create((Object)it, (Object)PubServerPathHandlerKt.escapeUrl(string));
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public static final Pair<VirtualFile, String> getServedDirAndPathForPubServer(@NotNull Project project, @NotNull VirtualFile file) {
        String string;
        String string2;
        int slashIndex;
        String relativePath;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return null;
        }
        VirtualFile dartRoot = virtualFile;
        String string3 = relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)dartRoot);
        int n = slashIndex = string3 != null ? StringsKt.indexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null) : -1;
        if (slashIndex == -1) {
            string2 = null;
        } else {
            String string4 = relativePath;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            String string5 = string4;
            int n2 = 0;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, slashIndex);
            string2 = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String folderName = string2;
        if (folderName == null || Intrinsics.areEqual(folderName, (Object)"build") || Intrinsics.areEqual(folderName, (Object)"lib") || Intrinsics.areEqual((Object)"packages", (Object)folderName)) {
            return null;
        }
        String string8 = relativePath;
        if (string8 == null) {
            Intrinsics.throwNpe();
        }
        String string9 = string = string8;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.substring(slashIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
        String pubServePath = string10;
        return Pair.create((Object)dartRoot.findChild(folderName), (Object)PubServerPathHandlerKt.escapeUrl(pubServePath));
    }

    private static final String escapeUrl(String path) {
        try {
            String string = StringUtil.replace((String)UrlEscapers.urlPathSegmentEscaper().escape(path), (String)"%2F", (String)"/");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.replace(UrlEs\u2026escape(path), \"%2F\", \"/\")");
            return string;
        }
        catch (Exception e) {
            LOG.warn(path, (Throwable)e);
            return path;
        }
    }

    static {
        Logger logger = Logger.getInstance(PubServerPathHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        pathQuery = new PathQuery(false, false, false, true);
    }

    @Nullable
    public static final /* synthetic */ Pair access$getServedDirAndPathForPubServer(@NotNull Project project, @NotNull String path) {
        return PubServerPathHandlerKt.getServedDirAndPathForPubServer(project, path);
    }
}

