/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.pubServer.PubServerService;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ConsoleManager;

public class PubServerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PubServerManager.class);
    private final Project project;
    private final ConsoleManager consoleManager;
    private String myServedSdkVersion;
    private final LoadingCache<VirtualFile, PubServerService> myServedDirToPubService;

    @NotNull
    public static PubServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            PubServerManager.$$$reportNull$$$0(0);
        }
        PubServerManager pubServerManager = (PubServerManager)ServiceManager.getService((Project)project, PubServerManager.class);
        if (pubServerManager == null) {
            PubServerManager.$$$reportNull$$$0(1);
        }
        return pubServerManager;
    }

    public PubServerManager(@NotNull Project project) {
        if (project == null) {
            PubServerManager.$$$reportNull$$$0(2);
        }
        this.consoleManager = new ConsoleManager();
        this.myServedDirToPubService = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, PubServerService>(){

            public PubServerService load(@NotNull VirtualFile key) throws Exception {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new PubServerService(PubServerManager.this.project, PubServerManager.this.consoleManager);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/lang/dart/pubServer/PubServerManager$1", "load"));
            }
        });
        this.project = project;
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("name".equals(event.getPropertyName())) {
                    this.contentsChanged((VirtualFileEvent)event);
                }
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.contentsChanged((VirtualFileEvent)event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.contentsChanged(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ("pubspec.yaml".equals((file = event.getFile()).getName()) && file.getFileSystem() == LocalFileSystem.getInstance()) {
                    PubServerManager.this.pubspecYamlChanged(file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/lang/dart/pubServer/PubServerManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePropertyChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileMovement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void pubspecYamlChanged(@NotNull VirtualFile file) {
        VirtualFile mainDir;
        if (file == null) {
            PubServerManager.$$$reportNull$$$0(3);
        }
        if ((mainDir = file.getParent()) == null) {
            return;
        }
        for (VirtualFile subdir : mainDir.getChildren()) {
            PubServerService service;
            if (!subdir.isDirectory() || (service = (PubServerService)((Object)this.myServedDirToPubService.getIfPresent((Object)subdir))) == null) continue;
            Disposer.dispose((Disposable)service);
        }
    }

    public void send(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull VirtualFile servedDir, @NotNull String pathForPubServer) {
        DartSdk sdk;
        if (clientChannel == null) {
            PubServerManager.$$$reportNull$$$0(4);
        }
        if (clientRequest == null) {
            PubServerManager.$$$reportNull$$$0(5);
        }
        if (extraHeaders == null) {
            PubServerManager.$$$reportNull$$$0(6);
        }
        if (servedDir == null) {
            PubServerManager.$$$reportNull$$$0(7);
        }
        if (pathForPubServer == null) {
            PubServerManager.$$$reportNull$$$0(8);
        }
        if ((sdk = DartSdk.getDartSdk(this.project)) != null && !sdk.getVersion().equals(this.myServedSdkVersion)) {
            this.stopAllPubServerProcesses();
            this.myServedSdkVersion = sdk.getVersion();
        }
        try {
            ((PubServerService)((Object)this.myServedDirToPubService.get((Object)servedDir))).sendToPubServer(clientChannel, clientRequest, extraHeaders, servedDir, pathForPubServer);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean hasAlivePubServerProcesses() {
        for (PubServerService service : this.myServedDirToPubService.asMap().values()) {
            if (!service.isPubServerProcessAlive()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.stopAllPubServerProcesses();
    }

    public void stopAllPubServerProcesses() {
        for (PubServerService service : this.myServedDirToPubService.asMap().values()) {
            try {
                Disposer.dispose((Disposable)service);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public Collection<String> getAllAlivePubServerAuthorities() {
        SmartList result = new SmartList();
        for (PubServerService service : this.myServedDirToPubService.asMap().values()) {
            result.addAll(service.getAllPubServeAuthorities());
        }
        SmartList smartList = result;
        if (smartList == null) {
            PubServerManager.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    public Collection<String> getAlivePubServerAuthoritiesForDartRoot(@NotNull VirtualFile dartProjectRoot) {
        if (dartProjectRoot == null) {
            PubServerManager.$$$reportNull$$$0(10);
        }
        SmartList result = new SmartList();
        for (VirtualFile subdir : dartProjectRoot.getChildren()) {
            PubServerService service;
            if (!subdir.isDirectory() || (service = (PubServerService)((Object)this.myServedDirToPubService.getIfPresent((Object)subdir))) == null) continue;
            ContainerUtil.addIfNotNull((Collection)result, (Object)service.getPubServeAuthority(subdir));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PubServerManager.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @Nullable
    public String getPubServerAuthorityForServedDir(@NotNull VirtualFile servedDir) {
        if (servedDir == null) {
            PubServerManager.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(servedDir.isDirectory() && servedDir.getParent().findChild("pubspec.yaml") != null, (Object)("Bad argument: " + servedDir.getPath()));
        PubServerService service = (PubServerService)((Object)this.myServedDirToPubService.getIfPresent((Object)servedDir));
        return service != null ? service.getPubServeAuthority(servedDir) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/pubServer/PubServerManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientChannel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientRequest";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraHeaders";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servedDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathForPubServer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartProjectRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/pubServer/PubServerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAlivePubServerAuthorities";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlivePubServerAuthoritiesForDartRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pubspecYamlChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAlivePubServerAuthoritiesForDartRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPubServerAuthorityForServedDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

