/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.psi.impl.DartFileReference;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartUriElementBase
extends DartPsiCompositeElementImpl
implements DartUriElement {
    private static final Condition<PsiFileSystemItem> DART_FILE_OR_DIR_FILTER = item -> item.isDirectory() || item instanceof DartFile;

    public DartUriElementBase(@NotNull ASTNode node) {
        if (node == null) {
            DartUriElementBase.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 0 ? null : references[0];
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = new PsiReference[]{new DartFileReference(this, (String)this.getUriStringAndItsRange().first)};
        if (psiReferenceArray == null) {
            DartUriElementBase.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartUriElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartUriElementBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartUriElementManipulator
    extends AbstractElementManipulator<DartUriElement> {
        public DartUriElement handleContentChange(@NotNull DartUriElement oldUriElement, @NotNull TextRange range, @NotNull String newContent) {
            if (oldUriElement == null) {
                DartUriElementManipulator.$$$reportNull$$$0(0);
            }
            if (range == null) {
                DartUriElementManipulator.$$$reportNull$$$0(1);
            }
            if (newContent == null) {
                DartUriElementManipulator.$$$reportNull$$$0(2);
            }
            String newUriElementText = StringUtil.replaceSubstring((String)oldUriElement.getText(), (TextRange)this.getRangeInElement(oldUriElement), (String)newContent);
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)oldUriElement.getProject()).createFileFromText(DartLanguage.INSTANCE, (CharSequence)("import " + newUriElementText + ";"));
            DartImportStatement importStatement = (DartImportStatement)PsiTreeUtil.findChildOfType((PsiElement)fileFromText, DartImportStatement.class);
            assert (importStatement != null) : fileFromText.getText();
            return (DartUriElement)oldUriElement.replace((PsiElement)importStatement.getUriElement());
        }

        @NotNull
        public TextRange getRangeInElement(@NotNull DartUriElement element) {
            if (element == null) {
                DartUriElementManipulator.$$$reportNull$$$0(3);
            }
            TextRange textRange = (TextRange)element.getUriStringAndItsRange().second;
            if (textRange == null) {
                DartUriElementManipulator.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldUriElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleContentChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeInElement";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

